/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.formatters;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import fr.inria.eventcloud.api.Quadruple;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;

public class QuadruplesFormatter {
    private static final String GRAPH_TITLE = "Graph";
    private static final String META_GRAPH_TITLE = "Meta Graph";
    private static final String SUBJECT_TITLE = "Subject";
    private static final String PREDICATE_TITLE = "Predicate";
    private static final String OBJECT_TITLE = "Object";

    private QuadruplesFormatter() {
    }

    public static void output(Quadruple ... quadruples) {
        QuadruplesFormatter.output(System.out, Lists.newArrayList((Object[])quadruples), false);
    }

    public static void output(Collection<Quadruple> quadruples) {
        QuadruplesFormatter.output(System.out, quadruples, false);
    }

    public static void output(Collection<Quadruple> quadruples, boolean showMetaGraphValue) {
        QuadruplesFormatter.output(System.out, quadruples, showMetaGraphValue);
    }

    public static void output(OutputStream out, Collection<Quadruple> quadruples, boolean showMetaGraphValue) {
        int[] columnWidths = QuadruplesFormatter.findColumnWidths(quadruples, showMetaGraphValue);
        int columnWidthSum = QuadruplesFormatter.sum(columnWidths);
        int extraSpaces = 11;
        StringBuilder result = new StringBuilder();
        result.append('|');
        QuadruplesFormatter.append(result, '-', columnWidthSum + extraSpaces);
        result.append("|\n| ");
        if (showMetaGraphValue) {
            result.append(META_GRAPH_TITLE);
            QuadruplesFormatter.append(result, ' ', columnWidths[0] - META_GRAPH_TITLE.length());
        } else {
            result.append(GRAPH_TITLE);
            QuadruplesFormatter.append(result, ' ', columnWidths[0] - GRAPH_TITLE.length());
        }
        result.append(" | ");
        result.append(SUBJECT_TITLE);
        QuadruplesFormatter.append(result, ' ', columnWidths[1] - SUBJECT_TITLE.length());
        result.append(" | ");
        result.append(PREDICATE_TITLE);
        QuadruplesFormatter.append(result, ' ', columnWidths[2] - PREDICATE_TITLE.length());
        result.append(" | ");
        result.append(OBJECT_TITLE);
        QuadruplesFormatter.append(result, ' ', columnWidths[3] - OBJECT_TITLE.length());
        result.append(" |\n");
        result.append('|');
        QuadruplesFormatter.append(result, '=', columnWidthSum + extraSpaces);
        result.append("|\n");
        for (Quadruple q : quadruples) {
            Node[] nodes = q.toArray();
            if (showMetaGraphValue) {
                nodes[0] = q.createMetaGraphNode();
            }
            for (int i = 0; i < nodes.length; ++i) {
                String rdfTerm = FmtUtils.stringForNode((Node)nodes[i]);
                result.append("| ");
                result.append(rdfTerm);
                result.append(' ');
                QuadruplesFormatter.append(result, ' ', columnWidths[i] - rdfTerm.length());
                if (i != nodes.length - 1) continue;
                result.append('|');
            }
            result.append('\n');
        }
        result.append('|');
        QuadruplesFormatter.append(result, '-', columnWidthSum + extraSpaces);
        result.append('|');
        try {
            out.write(result.toString().getBytes());
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
    }

    public static String toString(Collection<Quadruple> quadruples) {
        return QuadruplesFormatter.toString(quadruples, false);
    }

    public static String toString(Collection<Quadruple> quadruples, boolean showMetaGraphValue) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        QuadruplesFormatter.output(baos, quadruples, showMetaGraphValue);
        return new String(baos.toByteArray(), Charsets.UTF_8);
    }

    private static void append(StringBuilder stringBuilder, char character, int nbTimes) {
        for (int i = 0; i < nbTimes; ++i) {
            stringBuilder.append(character);
        }
    }

    private static int sum(int ... integers) {
        int result = 0;
        for (int integer : integers) {
            result += integer;
        }
        return result;
    }

    private static int[] findColumnWidths(Collection<Quadruple> quadruples, boolean showMetaGraphValue) {
        int[] columnWidths = new int[]{showMetaGraphValue ? META_GRAPH_TITLE.length() : GRAPH_TITLE.length(), SUBJECT_TITLE.length(), PREDICATE_TITLE.length(), OBJECT_TITLE.length()};
        for (Quadruple q : quadruples) {
            Node[] nodes = q.toArray();
            if (showMetaGraphValue) {
                nodes[0] = q.createMetaGraphNode();
            }
            for (int i = 0; i < nodes.length; ++i) {
                int termLength = FmtUtils.stringForNode((Node)nodes[i]).length();
                if (termLength <= columnWidths[i]) continue;
                columnWidths[i] = termLength;
            }
        }
        return columnWidths;
    }
}

