/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.factories;

import com.google.common.base.Preconditions;
import fr.inria.eventcloud.configuration.EventCloudProperties;
import fr.inria.eventcloud.overlay.SemanticPeer;
import fr.inria.eventcloud.tracker.SemanticTracker;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.etsi.uri.gcm.util.GCM;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.proactive.core.node.Node;
import org.objectweb.proactive.extensions.p2p.structured.factories.AbstractFactory;
import org.objectweb.proactive.extensions.p2p.structured.overlay.Peer;
import org.objectweb.proactive.extensions.p2p.structured.overlay.PeerAttributeController;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.objectweb.proactive.extensions.p2p.structured.providers.SerializableProvider;
import org.objectweb.proactive.extensions.p2p.structured.tracker.Tracker;
import org.objectweb.proactive.extensions.p2p.structured.tracker.TrackerAttributeController;
import org.objectweb.proactive.extensions.p2p.structured.utils.ComponentUtils;
import org.objectweb.proactive.gcmdeployment.GCMVirtualNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soceda.socialfilter.relationshipstrengthengine.RelationshipStrengthEngineManager;

public final class SemanticFactory
extends AbstractFactory {
    private static final Logger log = LoggerFactory.getLogger(SemanticFactory.class);

    private SemanticFactory() {
    }

    public static SemanticTracker newSemanticTracker() {
        return SemanticFactory.createSemanticTracker("default", new HashMap<String, Object>());
    }

    public static SemanticTracker newSemanticTracker(String networkName) {
        return SemanticFactory.createSemanticTracker(networkName, new HashMap<String, Object>());
    }

    public static SemanticTracker newSemanticTracker(Node node) {
        return SemanticFactory.newSemanticTracker("default", node);
    }

    public static SemanticTracker newSemanticTracker(GCMVirtualNode vn) {
        return SemanticFactory.newSemanticTracker("default", vn);
    }

    public static SemanticTracker newSemanticTracker(String networkName, Node node) {
        return SemanticFactory.createSemanticTracker(networkName, ComponentUtils.createContext((Node)node));
    }

    public static SemanticTracker newSemanticTracker(String networkName, GCMVirtualNode vn) {
        return SemanticFactory.createSemanticTracker(networkName, ComponentUtils.createContext((GCMVirtualNode)vn));
    }

    private static SemanticTracker createSemanticTracker(String networkName, Map<String, Object> context) {
        try {
            SemanticTracker tracker = (SemanticTracker)ComponentUtils.createComponentAndGetInterface((String)"fr.inria.eventcloud.tracker.SemanticTracker", context, (String)"tracker-services", SemanticTracker.class, (boolean)true);
            ((TrackerAttributeController)GCM.getAttributeController((Component)((Interface)tracker).getFcItfOwner())).setAttributes((Tracker)tracker, networkName);
            log.info("SemanticTracker {} associated to network named '{}' created", (Object)tracker.getId(), (Object)networkName);
            return tracker;
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends StructuredOverlay> SemanticPeer newSemanticPeer(SerializableProvider<T> overlayProvider) {
        return SemanticFactory.createSemanticPeer(overlayProvider, new HashMap<String, Object>());
    }

    public static <T extends StructuredOverlay> SemanticPeer newSemanticPeer(SerializableProvider<T> overlayProvider, Node node) {
        return SemanticFactory.createSemanticPeer(overlayProvider, ComponentUtils.createContext((Node)node));
    }

    public static <T extends StructuredOverlay> SemanticPeer newSemanticPeer(SerializableProvider<T> overlayProvider, GCMVirtualNode vn) {
        return SemanticFactory.createSemanticPeer(overlayProvider, ComponentUtils.createContext((GCMVirtualNode)vn));
    }

    private static <T extends StructuredOverlay> SemanticPeer createSemanticPeer(SerializableProvider<T> overlayProvider, Map<String, Object> context) {
        try {
            SemanticPeer peer = (SemanticPeer)ComponentUtils.createComponentAndGetInterface((String)"fr.inria.eventcloud.overlay.SemanticPeer", context, (String)"peer-services", SemanticPeer.class, (boolean)true);
            ((PeerAttributeController)GCM.getAttributeController((Component)((Interface)peer).getFcItfOwner())).setAttributes((Peer)peer, overlayProvider);
            if (EventCloudProperties.SOCIAL_FILTER_URL.getValue() != null) {
                Component peerComponent = ((Interface)peer).getFcItfOwner();
                RelationshipStrengthEngineManager socialFilter = (RelationshipStrengthEngineManager)ComponentUtils.lookupFcInterface((String)((String)EventCloudProperties.SOCIAL_FILTER_URL.getValue()), (String)"social-filter-services", RelationshipStrengthEngineManager.class);
                GCM.getGCMLifeCycleController((Component)peerComponent).stopFc();
                GCM.getBindingController((Component)peerComponent).bindFc("social-filter-services", (Object)socialFilter);
                GCM.getGCMLifeCycleController((Component)peerComponent).startFc();
                log.info("SemanticPeer {} bound to social filter {}", (Object)peer.getId(), EventCloudProperties.SOCIAL_FILTER_URL.getValue());
            }
            log.info("SemanticPeer {} created", (Object)peer.getId());
            return peer;
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalLifeCycleException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalBindingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends StructuredOverlay> SemanticPeer[] newSemanticPeersInParallel(SerializableProvider<T> overlayProvider, int number) {
        return SemanticFactory.newSemanticPeersInParallel(overlayProvider, new Node[number]);
    }

    public static <T extends StructuredOverlay> SemanticPeer[] newSemanticPeersInParallel(SerializableProvider<T> overlayProvider, Node[] nodes) {
        Preconditions.checkNotNull((Object)nodes);
        SemanticPeer[] peers = new SemanticPeer[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            peers[i] = SemanticFactory.newSemanticPeer(overlayProvider, nodes[i]);
        }
        return peers;
    }
}

