/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.factories;

import com.google.common.base.Preconditions;
import fr.inria.eventcloud.api.EventCloudId;
import fr.inria.eventcloud.api.PublishApi;
import fr.inria.eventcloud.api.PutGetApi;
import fr.inria.eventcloud.api.SubscribeApi;
import fr.inria.eventcloud.api.properties.AlterableElaProperty;
import fr.inria.eventcloud.exceptions.EventCloudIdNotManaged;
import fr.inria.eventcloud.proxies.EventCloudCache;
import fr.inria.eventcloud.proxies.PublishProxy;
import fr.inria.eventcloud.proxies.PublishProxyAttributeController;
import fr.inria.eventcloud.proxies.PutGetProxy;
import fr.inria.eventcloud.proxies.PutGetProxyAttributeController;
import fr.inria.eventcloud.proxies.SubscribeProxy;
import fr.inria.eventcloud.proxies.SubscribeProxyAttributeController;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.etsi.uri.gcm.util.GCM;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.proactive.core.ProActiveException;
import org.objectweb.proactive.core.component.Fractive;
import org.objectweb.proactive.core.node.Node;
import org.objectweb.proactive.extensions.p2p.structured.factories.AbstractFactory;
import org.objectweb.proactive.extensions.p2p.structured.utils.ComponentUtils;
import org.objectweb.proactive.gcmdeployment.GCMVirtualNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFactory
extends AbstractFactory
implements Serializable {
    private static final long serialVersionUID = 130L;
    private static final Logger log = LoggerFactory.getLogger(ProxyFactory.class);
    protected static String publishProxyAdl = "fr.inria.eventcloud.proxies.PublishProxy";
    protected static String subscribeProxyAdl = "fr.inria.eventcloud.proxies.SubscribeProxy";
    protected static String putgetProxyAdl = "fr.inria.eventcloud.proxies.PutGetProxy";

    public static PublishApi newPublishProxy(String registryUrl, EventCloudId id) throws EventCloudIdNotManaged {
        return ProxyFactory.createPublishProxy(publishProxyAdl, new HashMap<String, Object>(), registryUrl, id);
    }

    public static PublishApi newPublishProxy(Node node, String registryUrl, EventCloudId id) throws EventCloudIdNotManaged {
        return ProxyFactory.createPublishProxy(publishProxyAdl, ComponentUtils.createContext((Node)node), registryUrl, id);
    }

    public static PublishApi newPublishProxy(GCMVirtualNode vn, String registryUrl, EventCloudId id) throws EventCloudIdNotManaged {
        return ProxyFactory.createPublishProxy(publishProxyAdl, ComponentUtils.createContext((GCMVirtualNode)vn), registryUrl, id);
    }

    protected static PublishApi createPublishProxy(String publishProxyAdl, Map<String, Object> context, String registryUrl, EventCloudId id) throws EventCloudIdNotManaged {
        ProxyFactory.checkNotNull(registryUrl, id);
        try {
            PublishProxy pubProxy = (PublishProxy)ComponentUtils.createComponentAndGetInterface((String)publishProxyAdl, context, (String)"publish-services", PublishProxy.class, (boolean)true);
            EventCloudCache eventCloudProxy = new EventCloudCache(registryUrl, id);
            ((PublishProxyAttributeController)GCM.getAttributeController((Component)((Interface)pubProxy).getFcItfOwner())).setAttributes(eventCloudProxy);
            eventCloudProxy.getRegistry().registerProxy(eventCloudProxy.getId(), pubProxy);
            return pubProxy;
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PublishApi lookupPublishProxy(String componentUri) throws IOException {
        return (PublishApi)ComponentUtils.lookupFcInterface((String)componentUri, (String)"publish-services", PublishApi.class);
    }

    public static SubscribeApi newSubscribeProxy(String registryUrl, EventCloudId id, AlterableElaProperty ... properties) throws EventCloudIdNotManaged {
        return ProxyFactory.createSubscribeProxy(subscribeProxyAdl, new HashMap<String, Object>(), registryUrl, id, properties);
    }

    public static SubscribeApi newSubscribeProxy(Node node, String registryUrl, EventCloudId id, AlterableElaProperty ... properties) throws EventCloudIdNotManaged {
        return ProxyFactory.createSubscribeProxy(subscribeProxyAdl, ComponentUtils.createContext((Node)node), registryUrl, id, properties);
    }

    public static SubscribeApi newSubscribeProxy(GCMVirtualNode vn, String registryUrl, EventCloudId id, AlterableElaProperty ... properties) throws EventCloudIdNotManaged {
        return ProxyFactory.createSubscribeProxy(subscribeProxyAdl, ComponentUtils.createContext((GCMVirtualNode)vn), registryUrl, id, properties);
    }

    protected static SubscribeApi createSubscribeProxy(String subscribeProxyAdl, Map<String, Object> context, String registryUrl, EventCloudId id, AlterableElaProperty ... properties) throws EventCloudIdNotManaged {
        ProxyFactory.checkNotNull(registryUrl, id);
        try {
            SubscribeProxy subProxy = (SubscribeProxy)ComponentUtils.createComponentAndGetInterface((String)subscribeProxyAdl, context, (String)"subscribe-services", SubscribeProxy.class, (boolean)true);
            Component subComponent = ((Interface)subProxy).getFcItfOwner();
            String componentUri = Fractive.registerByName((Component)subComponent, (String)("subscribe-proxy-" + UUID.randomUUID().toString()));
            log.info("SubscribeProxy bound to {}", (Object)componentUri);
            EventCloudCache eventCloudProxy = new EventCloudCache(registryUrl, id);
            ((SubscribeProxyAttributeController)GCM.getAttributeController((Component)subComponent)).setAttributes(eventCloudProxy, componentUri, properties);
            eventCloudProxy.getRegistry().registerProxy(id, subProxy);
            return subProxy;
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalStateException(e);
        }
        catch (ProActiveException e) {
            throw new IllegalStateException(e);
        }
    }

    public static SubscribeApi lookupSubscribeProxy(String componentUri) throws IOException {
        return (SubscribeApi)ComponentUtils.lookupFcInterface((String)componentUri, (String)"subscribe-services", SubscribeApi.class);
    }

    public static PutGetApi newPutGetProxy(String registryUrl, EventCloudId id) throws EventCloudIdNotManaged {
        return ProxyFactory.createPutGetProxy(putgetProxyAdl, new HashMap<String, Object>(), registryUrl, id);
    }

    public static PutGetApi newPutGetProxy(Node node, String registryUrl, EventCloudId id) throws EventCloudIdNotManaged {
        return ProxyFactory.createPutGetProxy(putgetProxyAdl, ComponentUtils.createContext((Node)node), registryUrl, id);
    }

    public static PutGetApi newPutGetProxy(GCMVirtualNode vn, String registryUrl, EventCloudId id) throws EventCloudIdNotManaged {
        return ProxyFactory.createPutGetProxy(putgetProxyAdl, ComponentUtils.createContext((GCMVirtualNode)vn), registryUrl, id);
    }

    protected static PutGetApi createPutGetProxy(String putgetProxyAdl, Map<String, Object> context, String registryUrl, EventCloudId id) throws EventCloudIdNotManaged {
        ProxyFactory.checkNotNull(registryUrl, id);
        try {
            PutGetProxy putgetProxy = (PutGetProxy)ComponentUtils.createComponentAndGetInterface((String)putgetProxyAdl, context, (String)"putget-services", PutGetProxy.class, (boolean)true);
            EventCloudCache eventCloudProxy = new EventCloudCache(registryUrl, id);
            ((PutGetProxyAttributeController)GCM.getAttributeController((Component)((Interface)putgetProxy).getFcItfOwner())).setAttributes(eventCloudProxy);
            eventCloudProxy.getRegistry().registerProxy(id, putgetProxy);
            return putgetProxy;
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PutGetApi lookupPutGetProxy(String componentUri) throws IOException {
        return (PutGetApi)ComponentUtils.lookupFcInterface((String)componentUri, (String)"putget-services", PutGetApi.class);
    }

    private static void checkNotNull(String registryUrl, EventCloudId id) {
        Preconditions.checkNotNull((Object)registryUrl, (Object)("Invalid registry URL: " + registryUrl));
        Preconditions.checkNotNull((Object)id, (Object)("Invalid EventCloud id: " + id));
    }
}

