/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.deployment;

import fr.inria.eventcloud.EventCloudDescription;
import fr.inria.eventcloud.deployment.EventCloudDeploymentDescriptor;
import fr.inria.eventcloud.factories.SemanticFactory;
import fr.inria.eventcloud.overlay.SemanticPeer;
import fr.inria.eventcloud.providers.SemanticPersistentOverlayProvider;
import fr.inria.eventcloud.proxies.PublishProxy;
import fr.inria.eventcloud.proxies.PutGetProxy;
import fr.inria.eventcloud.proxies.SubscribeProxy;
import fr.inria.eventcloud.tracker.SemanticTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objectweb.proactive.api.PAFuture;
import org.objectweb.proactive.extensions.p2p.structured.deployment.DeploymentDescriptor;
import org.objectweb.proactive.extensions.p2p.structured.deployment.NetworkDeployer;
import org.objectweb.proactive.extensions.p2p.structured.overlay.Peer;
import org.objectweb.proactive.extensions.p2p.structured.tracker.Tracker;
import org.objectweb.proactive.extensions.p2p.structured.utils.ComponentUtils;

public class EventCloudDeployer
extends NetworkDeployer {
    private static final long serialVersionUID = 130L;
    private final EventCloudDescription eventCloudDescription;
    private List<PublishProxy> publishProxies;
    private List<PutGetProxy> putgetProxies;
    private List<SubscribeProxy> subscribeProxies;

    public EventCloudDeployer(EventCloudDescription description, EventCloudDeploymentDescriptor deploymentDescriptor) {
        super((DeploymentDescriptor)deploymentDescriptor);
        this.eventCloudDescription = description;
        this.publishProxies = Collections.synchronizedList(new ArrayList());
        this.putgetProxies = Collections.synchronizedList(new ArrayList());
        this.subscribeProxies = Collections.synchronizedList(new ArrayList());
        if (deploymentDescriptor.getOverlayProvider() instanceof SemanticPersistentOverlayProvider) {
            ((SemanticPersistentOverlayProvider)deploymentDescriptor.getOverlayProvider()).setStreamUrl(description.getId().getStreamUrl());
        }
    }

    protected synchronized Peer createPeer() {
        if (this.descriptor.getNodeProvider() != null) {
            return SemanticFactory.newSemanticPeer(this.descriptor.getOverlayProvider(), this.descriptor.getNodeProvider().getGcmVirtualNode("PeerVN"));
        }
        return SemanticFactory.newSemanticPeer(this.descriptor.getOverlayProvider());
    }

    protected synchronized Tracker createTracker(String networkName) {
        if (this.descriptor.getNodeProvider() != null) {
            return SemanticFactory.newSemanticTracker(networkName, this.descriptor.getNodeProvider().getGcmVirtualNode("TrackerVN"));
        }
        return SemanticFactory.newSemanticTracker(networkName);
    }

    public void registerProxy(PublishProxy proxy) {
        this.publishProxies.add(proxy);
    }

    public void registerProxy(PutGetProxy proxy) {
        this.putgetProxies.add(proxy);
    }

    public void registerProxy(SubscribeProxy proxy) {
        this.subscribeProxies.add(proxy);
    }

    public boolean unregisterProxy(PublishProxy proxy) {
        return this.publishProxies.remove(proxy);
    }

    public boolean unregisterProxy(PutGetProxy proxy) {
        return this.putgetProxies.remove(proxy);
    }

    public boolean unregisterProxy(SubscribeProxy proxy) {
        return this.subscribeProxies.remove(proxy);
    }

    public EventCloudDescription getEventCloudDescription() {
        return this.eventCloudDescription;
    }

    public SemanticPeer getRandomSemanticPeer() {
        return (SemanticPeer)PAFuture.getFutureValue((Object)super.getRandomTracker().getRandomPeer());
    }

    public SemanticTracker getRandomSemanticTracker() {
        return (SemanticTracker)PAFuture.getFutureValue((Object)super.getRandomTracker());
    }

    public List<PublishProxy> getPublishProxies() {
        return this.publishProxies;
    }

    public List<PutGetProxy> getPutGetProxies() {
        return this.putgetProxies;
    }

    public List<SubscribeProxy> getSubscribeProxies() {
        return this.subscribeProxies;
    }

    protected void internalUndeploy() {
        ComponentUtils.terminateComponents(this.publishProxies);
        ComponentUtils.terminateComponents(this.putgetProxies);
        ComponentUtils.terminateComponents(this.subscribeProxies);
        ComponentUtils.terminateComponents((List)super.getRandomTracker().getPeers());
        ComponentUtils.terminateComponents((List)this.getTrackers());
    }

    protected void reset() {
        this.publishProxies = null;
        this.putgetProxies = null;
        this.subscribeProxies = null;
    }
}

