/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.datastore.stats;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.hp.hpl.jena.graph.Node;
import fr.inria.eventcloud.overlay.can.SemanticElement;
import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apfloat.Apfloat;

public abstract class StatsRecorder
implements Serializable {
    private static final long serialVersionUID = 130L;
    private AtomicLong nbQuads = new AtomicLong();
    private final transient ListeningExecutorService threadPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(2));
    private transient Queue<ListenableFuture<?>> futures = new ConcurrentLinkedQueue();

    public void quadrupleAdded(final Node g, final Node s, final Node p, final Node o) {
        final ListenableFuture future = this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                StatsRecorder.this.quadrupleAddedComputeStats(g, s, p, o);
            }
        });
        this.futures.add(future);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                StatsRecorder.this.futures.remove(future);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        this.nbQuads.incrementAndGet();
    }

    protected abstract void quadrupleAddedComputeStats(Node var1, Node var2, Node var3, Node var4);

    public void quadrupleRemoved(final Node g, final Node s, final Node p, final Node o) {
        final ListenableFuture future = this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                StatsRecorder.this.quadrupleRemovedComputeStats(g, s, p, o);
            }
        });
        this.futures.add(future);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                StatsRecorder.this.futures.remove(future);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        this.nbQuads.decrementAndGet();
    }

    protected abstract void quadrupleRemovedComputeStats(Node var1, Node var2, Node var3, Node var4);

    public abstract Apfloat computeGraphEstimation();

    public abstract Apfloat computeSubjectEstimation();

    public abstract Apfloat computePredicateEstimation();

    public abstract Apfloat computeObjectEstimation();

    public SemanticElement computeSplitEstimation(byte dimension) {
        Apfloat estimatedSplitValue = null;
        switch (dimension) {
            case 0: {
                estimatedSplitValue = this.computeGraphEstimation();
                break;
            }
            case 1: {
                estimatedSplitValue = this.computeSubjectEstimation();
                break;
            }
            case 2: {
                estimatedSplitValue = this.computePredicateEstimation();
                break;
            }
            case 3: {
                estimatedSplitValue = this.computeObjectEstimation();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid dimension specified: " + dimension);
            }
        }
        return new SemanticElement(estimatedSplitValue);
    }

    public long getNbQuads() {
        return this.nbQuads.get();
    }

    public void sync() {
        Future future;
        while ((future = (Future)this.futures.poll()) != null) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

