/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.datastore.stats;

import com.hp.hpl.jena.graph.Node;
import fr.inria.eventcloud.datastore.stats.StatsRecorder;
import fr.inria.eventcloud.overlay.can.SemanticElement;
import org.apfloat.Apfloat;
import org.objectweb.proactive.extensions.p2p.structured.utils.ApfloatUtils;

public class MeanStatsRecorder
extends StatsRecorder {
    private static final long serialVersionUID = 130L;
    private Apfloat gsum = Apfloat.ZERO;
    private Apfloat ssum = Apfloat.ZERO;
    private Apfloat psum = Apfloat.ZERO;
    private Apfloat osum = Apfloat.ZERO;

    @Override
    public synchronized void quadrupleAddedComputeStats(Node g, Node s, Node p, Node o) {
        Apfloat gf = MeanStatsRecorder.toRadix10(g);
        Apfloat sf = MeanStatsRecorder.toRadix10(s);
        Apfloat pf = MeanStatsRecorder.toRadix10(p);
        Apfloat of = MeanStatsRecorder.toRadix10(o);
        this.gsum = this.gsum.add(gf);
        this.ssum = this.ssum.add(sf);
        this.psum = this.psum.add(pf);
        this.osum = this.osum.add(of);
    }

    @Override
    protected synchronized void quadrupleRemovedComputeStats(Node g, Node s, Node p, Node o) {
        Apfloat gf = MeanStatsRecorder.toRadix10(g);
        Apfloat sf = MeanStatsRecorder.toRadix10(s);
        Apfloat pf = MeanStatsRecorder.toRadix10(p);
        Apfloat of = MeanStatsRecorder.toRadix10(o);
        this.gsum = this.gsum.subtract(gf);
        this.ssum = this.ssum.subtract(sf);
        this.psum = this.psum.subtract(pf);
        this.osum = this.osum.subtract(of);
    }

    private static final Apfloat toRadix10(Node n) {
        return ApfloatUtils.toFloatRadix10((String)SemanticElement.removePrefix(n));
    }

    @Override
    public Apfloat computeGraphEstimation() {
        return this.gsum.divide(new Apfloat(super.getNbQuads()));
    }

    @Override
    public Apfloat computeSubjectEstimation() {
        return this.ssum.divide(new Apfloat(super.getNbQuads()));
    }

    @Override
    public Apfloat computePredicateEstimation() {
        return this.psum.divide(new Apfloat(super.getNbQuads()));
    }

    @Override
    public Apfloat computeObjectEstimation() {
        return this.osum.divide(new Apfloat(super.getNbQuads()));
    }
}

