/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.datastore.stats;

import com.hp.hpl.jena.graph.Node;
import fr.inria.eventcloud.datastore.stats.StatsRecorder;
import fr.inria.eventcloud.overlay.can.SemanticElement;
import org.apfloat.Apfloat;
import org.apfloat.Apint;
import org.objectweb.proactive.extensions.p2p.structured.utils.ApfloatUtils;

public class CentroidStatsRecorder
extends StatsRecorder {
    private static final long serialVersionUID = 130L;
    private Apfloat gsum = Apfloat.ZERO;
    private Apfloat ssum = Apfloat.ZERO;
    private Apfloat psum = Apfloat.ZERO;
    private Apfloat osum = Apfloat.ZERO;
    private Apint gwsum = Apint.ZERO;
    private Apint swsum = Apint.ZERO;
    private Apint pwsum = Apint.ZERO;
    private Apint owsum = Apint.ZERO;

    @Override
    public synchronized void quadrupleAddedComputeStats(Node g, Node s, Node p, Node o) {
        String gs = SemanticElement.removePrefix(g);
        String ss = SemanticElement.removePrefix(s);
        String ps = SemanticElement.removePrefix(p);
        String os = SemanticElement.removePrefix(o);
        Apfloat gf = ApfloatUtils.toFloatRadix10((String)gs);
        Apfloat sf = ApfloatUtils.toFloatRadix10((String)ss);
        Apfloat pf = ApfloatUtils.toFloatRadix10((String)ps);
        Apfloat of = ApfloatUtils.toFloatRadix10((String)os);
        Apint gw = new Apint((long)gs.length());
        Apint sw = new Apint((long)ss.length());
        Apint pw = new Apint((long)ps.length());
        Apint ow = new Apint((long)os.length());
        this.gsum = this.gsum.add(gf.multiply((Apfloat)gw));
        this.ssum = this.ssum.add(sf.multiply((Apfloat)sw));
        this.psum = this.psum.add(pf.multiply((Apfloat)pw));
        this.osum = this.osum.add(of.multiply((Apfloat)ow));
        this.gwsum = this.gwsum.add(gw);
        this.swsum = this.swsum.add(sw);
        this.pwsum = this.pwsum.add(pw);
        this.owsum = this.owsum.add(ow);
    }

    @Override
    protected synchronized void quadrupleRemovedComputeStats(Node g, Node s, Node p, Node o) {
        String gs = SemanticElement.removePrefix(g);
        String ss = SemanticElement.removePrefix(s);
        String ps = SemanticElement.removePrefix(p);
        String os = SemanticElement.removePrefix(o);
        Apfloat gf = ApfloatUtils.toFloatRadix10((String)gs);
        Apfloat sf = ApfloatUtils.toFloatRadix10((String)ss);
        Apfloat pf = ApfloatUtils.toFloatRadix10((String)ps);
        Apfloat of = ApfloatUtils.toFloatRadix10((String)os);
        Apint gw = new Apint((long)gs.length());
        Apint sw = new Apint((long)ss.length());
        Apint pw = new Apint((long)ps.length());
        Apint ow = new Apint((long)os.length());
        this.gsum = this.gsum.subtract(gf.multiply((Apfloat)gw));
        this.ssum = this.ssum.subtract(sf.multiply((Apfloat)sw));
        this.psum = this.psum.subtract(pf.multiply((Apfloat)pw));
        this.osum = this.osum.subtract(of.multiply((Apfloat)ow));
        this.gwsum = this.gwsum.subtract(gw);
        this.swsum = this.swsum.subtract(sw);
        this.pwsum = this.pwsum.subtract(pw);
        this.owsum = this.owsum.subtract(ow);
    }

    @Override
    public Apfloat computeGraphEstimation() {
        return this.gsum.divide((Apfloat)this.gwsum);
    }

    @Override
    public Apfloat computeSubjectEstimation() {
        return this.ssum.divide((Apfloat)this.swsum);
    }

    @Override
    public Apfloat computePredicateEstimation() {
        return this.psum.divide((Apfloat)this.pwsum);
    }

    @Override
    public Apfloat computeObjectEstimation() {
        return this.osum.divide((Apfloat)this.owsum);
    }
}

