/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.datastore;

import com.hp.hpl.jena.tdb.base.file.Location;
import fr.inria.eventcloud.configuration.EventCloudProperties;
import fr.inria.eventcloud.datastore.TransactionalTdbDatastore;
import fr.inria.eventcloud.datastore.stats.StatsRecorder;
import java.io.File;

public class TransactionalTdbDatastoreBuilder {
    private final Location location;
    private boolean deleteFilesAfterClose = false;
    private StatsRecorder statsRecorder;

    public TransactionalTdbDatastoreBuilder() {
        this.location = null;
    }

    public TransactionalTdbDatastoreBuilder(String location) {
        this(new Location(location));
    }

    public TransactionalTdbDatastoreBuilder(File location) {
        this(location.getAbsolutePath());
    }

    public TransactionalTdbDatastoreBuilder(Location location) {
        this.location = location;
    }

    public TransactionalTdbDatastoreBuilder deleteFilesAfterClose() {
        return this.deleteFilesAfterClose(true);
    }

    public TransactionalTdbDatastoreBuilder deleteFilesAfterClose(boolean value) {
        this.deleteFilesAfterClose = value;
        return this;
    }

    public TransactionalTdbDatastoreBuilder recordStats() {
        try {
            return this.recordStats((StatsRecorder)((Class)EventCloudProperties.STATS_RECORDER_CLASS.getValue()).newInstance());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public TransactionalTdbDatastoreBuilder recordStats(StatsRecorder statsRecorder) {
        this.statsRecorder = statsRecorder;
        return this;
    }

    public TransactionalTdbDatastore build() {
        if (this.location == null) {
            return new TransactionalTdbDatastore(this.statsRecorder);
        }
        return new TransactionalTdbDatastore(this.location, this.statsRecorder, this.deleteFilesAfterClose);
    }
}

