/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.datastore;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.base.block.FileMode;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.Datastore;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraphImpl;
import fr.inria.eventcloud.datastore.VariableDatatype;
import fr.inria.eventcloud.datastore.WithoutPrefixFunction;
import fr.inria.eventcloud.datastore.stats.StatsRecorder;
import java.io.File;
import java.io.IOException;
import org.objectweb.proactive.extensions.p2p.structured.utils.Files;
import org.objectweb.proactive.extensions.p2p.structured.utils.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalTdbDatastore
extends Datastore {
    private static final Logger log = LoggerFactory.getLogger(TransactionalTdbDatastore.class);
    private final boolean autoRemove;
    private final Dataset dataset;
    private final Location location;
    private final StatsRecorder statsRecorder;

    protected TransactionalTdbDatastore(Location location, StatsRecorder statsRecorder, boolean autoRemove) {
        if (location != null && !location.isMem()) {
            new File(location.getDirectoryPath()).mkdirs();
            this.dataset = TDBFactory.createDataset((Location)location);
            this.location = location;
        } else {
            this.dataset = TDBFactory.createDataset();
            this.location = null;
        }
        this.autoRemove = autoRemove;
        this.statsRecorder = statsRecorder;
        this.registerPlugins();
    }

    protected TransactionalTdbDatastore(StatsRecorder statsRecorder) {
        this(null, statsRecorder, false);
    }

    public TransactionalDatasetGraph begin(AccessMode mode) {
        this.dataset.begin(mode.toJena());
        return new TransactionalDatasetGraphImpl(this.dataset, this.statsRecorder);
    }

    private void registerPlugins() {
        TypeMapper.getInstance().registerDatatype(VariableDatatype.getInstance());
        FunctionRegistry.get().put(WithoutPrefixFunction.URI, WithoutPrefixFunction.class);
    }

    @Override
    protected void _open() {
    }

    @Override
    protected void _close() {
        TDBFactory.release((Dataset)this.dataset);
        if (this.autoRemove) {
            if (SystemUtils.isWindows() && SystemTDB.fileMode() == FileMode.mapped) {
                System.gc();
            }
            try {
                Files.deleteDirectory((String)this.location.getDirectoryPath());
            }
            catch (IOException e) {
                log.error("The deletion of the repository " + this.location.getDirectoryPath() + " has failed", (Throwable)e);
            }
        }
    }

    public StatsRecorder getStatsRecorder() {
        return this.statsRecorder;
    }
}

