/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.datastore;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.datastore.QuadrupleIterator;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.datastore.stats.StatsRecorder;
import java.util.Collection;

public final class TransactionalDatasetGraphImpl
implements TransactionalDatasetGraph {
    private final Dataset dataset;
    private final StatsRecorder statsRecorder;

    public TransactionalDatasetGraphImpl(Dataset dataset, StatsRecorder statsRecorder) {
        this.dataset = dataset;
        this.statsRecorder = statsRecorder;
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.recordQuadrupleAddedIfNecessary(g, s, p, o);
        this.dataset.asDatasetGraph().add(g, s, p, o);
    }

    @Override
    public void add(Quadruple quadruple) {
        this.add(quadruple.getGraph(), quadruple.getSubject(), quadruple.getPredicate(), quadruple.getObject());
    }

    @Override
    public void add(Collection<Quadruple> quadruples) {
        for (Quadruple q : quadruples) {
            this.add(q);
        }
    }

    @Override
    public boolean contains(Quadruple quadruple) {
        return this.dataset.asDatasetGraph().contains(quadruple.getGraph(), quadruple.getSubject(), quadruple.getPredicate(), quadruple.getObject());
    }

    @Override
    public void delete(Quadruple quadruple) {
        this.recordQuadrupleRemovedIfNecessary(quadruple.getGraph(), quadruple.getSubject(), quadruple.getPredicate(), quadruple.getObject());
        this.dataset.asDatasetGraph().delete(quadruple.getGraph(), quadruple.getSubject(), quadruple.getPredicate(), quadruple.getObject());
    }

    @Override
    public void delete(Collection<Quadruple> quadruples) {
        for (Quadruple q : quadruples) {
            this.delete(q);
        }
    }

    @Override
    public void delete(QuadruplePattern quadruplePattern) {
        this.delete(quadruplePattern.getGraph(), quadruplePattern.getSubject(), quadruplePattern.getPredicate(), quadruplePattern.getObject());
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.dataset.asDatasetGraph().deleteAny(g, s, p, o);
    }

    @Override
    public QuadrupleIterator find(QuadruplePattern quadruplePattern) {
        return this.find(quadruplePattern.getGraph(), quadruplePattern.getSubject(), quadruplePattern.getPredicate(), quadruplePattern.getObject());
    }

    @Override
    public QuadrupleIterator find(Node g, Node s, Node p, Node o) {
        return new QuadrupleIterator(this.dataset.asDatasetGraph().findNG(g, s, p, o));
    }

    @Override
    public void abort() {
        this.dataset.abort();
    }

    @Override
    public void commit() {
        this.dataset.commit();
    }

    @Override
    public void end() {
        this.dataset.end();
    }

    @Override
    public Dataset getUnderlyingDataset() {
        return this.dataset;
    }

    private void recordQuadrupleAddedIfNecessary(Node g, Node s, Node p, Node o) {
        if (this.statsRecorder != null) {
            this.statsRecorder.quadrupleAdded(g, s, p, o);
        }
    }

    private void recordQuadrupleRemovedIfNecessary(Node g, Node s, Node p, Node o) {
        if (this.statsRecorder != null) {
            this.statsRecorder.quadrupleRemoved(g, s, p, o);
        }
    }
}

