/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.datastore;

import java.io.Closeable;
import java.util.UUID;

public abstract class Datastore
implements Closeable {
    protected final UUID id = UUID.randomUUID();
    protected boolean initialized = false;

    public Datastore() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Datastore datastore = Datastore.this;
                synchronized (datastore) {
                    if (Datastore.this.initialized) {
                        Datastore.this.close();
                    }
                }
            }
        }));
    }

    protected abstract void _open();

    protected abstract void _close();

    public synchronized void open() {
        if (this.initialized) {
            throw new IllegalStateException("Datastore already opened");
        }
        this._open();
        this.initialized = true;
    }

    @Override
    public synchronized void close() {
        if (!this.initialized) {
            throw new IllegalStateException("The datastore has not been initialized via open");
        }
        this._close();
        this.initialized = false;
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

