/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud;

import com.google.common.collect.ImmutableSet;
import fr.inria.eventcloud.EventCloudsRegistry;
import fr.inria.eventcloud.api.EventCloudId;
import fr.inria.eventcloud.configuration.EventCloudProperties;
import fr.inria.eventcloud.deployment.EventCloudDeployer;
import fr.inria.eventcloud.proxies.PublishProxy;
import fr.inria.eventcloud.proxies.PutGetProxy;
import fr.inria.eventcloud.proxies.SubscribeProxy;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.proactive.Body;
import org.objectweb.proactive.annotation.multiactivity.Compatible;
import org.objectweb.proactive.annotation.multiactivity.DefineGroups;
import org.objectweb.proactive.annotation.multiactivity.DefineRules;
import org.objectweb.proactive.annotation.multiactivity.Group;
import org.objectweb.proactive.annotation.multiactivity.MemberOf;
import org.objectweb.proactive.core.ProActiveException;
import org.objectweb.proactive.core.component.Fractive;
import org.objectweb.proactive.extensions.p2p.structured.AbstractComponent;
import org.objectweb.proactive.extensions.p2p.structured.deployment.NetworkDeployer;
import org.objectweb.proactive.extensions.p2p.structured.tracker.Tracker;
import org.objectweb.proactive.multiactivity.MultiActiveService;

@DefineGroups(value={@Group(name="parallel", selfCompatible=true), @Group(name="deployers", selfCompatible=false)})
@DefineRules(value={@Compatible(value={"deployers", "parallel"})})
public class EventCloudsRegistryImpl
extends AbstractComponent
implements EventCloudsRegistry {
    public static final String EVENTCLOUDS_REGISTRY_ADL = "fr.inria.eventcloud.EventCloudsRegistry";
    public static final String EVENTCLOUDS_REGISTRY_SERVICES_ITF = "eventclouds-registry-services";
    public static final String REGISTRY_VN = "RegistryVN";
    private Map<EventCloudId, EventCloudDeployer> eventCloudDeployers;
    private String registryUrl;

    public void initComponentActivity(Body body) {
        this.configurationProperty = "eventcloud.configuration";
        this.propertiesClass = EventCloudProperties.class;
        super.initComponentActivity(body);
        this.eventCloudDeployers = new HashMap<EventCloudId, EventCloudDeployer>();
        this.registryUrl = null;
    }

    public void runComponentActivity(Body body) {
        new MultiActiveService(body).multiActiveServing(((Integer)EventCloudProperties.MAO_SOFT_LIMIT_EVENTCLOUDS_REGISTRY.getValue()).intValue(), false, false);
    }

    @Override
    public String register(String bindingName) throws ProActiveException {
        this.registryUrl = Fractive.registerByName((Component)Fractive.getComponentRepresentativeOnThis(), (String)bindingName);
        return this.registryUrl;
    }

    @Override
    public void unregister() throws IOException {
        if (this.registryUrl != null) {
            Fractive.unregister((String)this.registryUrl);
        }
    }

    @Override
    @MemberOf(value="deployers")
    public boolean register(EventCloudDeployer deployer) {
        if (this.eventCloudDeployers.containsKey(deployer.getEventCloudDescription().getId())) {
            return false;
        }
        return this.eventCloudDeployers.put(deployer.getEventCloudDescription().getId(), deployer) == null;
    }

    @Override
    @MemberOf(value="deployers")
    public Set<EventCloudId> listEventClouds() {
        return ImmutableSet.copyOf(this.eventCloudDeployers.keySet());
    }

    @Override
    @MemberOf(value="deployers")
    public boolean contains(EventCloudId id) {
        return this.eventCloudDeployers.containsKey(id);
    }

    @Override
    @MemberOf(value="deployers")
    public EventCloudDeployer find(EventCloudId id) {
        return this.eventCloudDeployers.get(id);
    }

    @Override
    @MemberOf(value="deployers")
    public List<Tracker> findTrackers(EventCloudId id) {
        if (this.contains(id)) {
            return this.eventCloudDeployers.get(id).getTrackers();
        }
        return null;
    }

    @Override
    @MemberOf(value="deployers")
    public void registerProxy(EventCloudId id, PublishProxy proxy) {
        this.checkEventCloudIdAndRetrieveNetworkDeployer(id).registerProxy(proxy);
    }

    @Override
    @MemberOf(value="deployers")
    public void registerProxy(EventCloudId id, PutGetProxy proxy) {
        this.checkEventCloudIdAndRetrieveNetworkDeployer(id).registerProxy(proxy);
    }

    @Override
    @MemberOf(value="deployers")
    public void registerProxy(EventCloudId id, SubscribeProxy proxy) {
        this.checkEventCloudIdAndRetrieveNetworkDeployer(id).registerProxy(proxy);
    }

    @Override
    @MemberOf(value="deployers")
    public List<PublishProxy> getPublishProxies(EventCloudId id) {
        this.checkEventCloudId(id);
        return this.eventCloudDeployers.get(id).getPublishProxies();
    }

    @Override
    @MemberOf(value="deployers")
    public List<PutGetProxy> getPutGetProxies(EventCloudId id) {
        this.checkEventCloudId(id);
        return this.eventCloudDeployers.get(id).getPutGetProxies();
    }

    @Override
    @MemberOf(value="deployers")
    public List<SubscribeProxy> getSubscribeProxies(EventCloudId id) {
        this.checkEventCloudId(id);
        return this.eventCloudDeployers.get(id).getSubscribeProxies();
    }

    @Override
    @MemberOf(value="deployers")
    public boolean unregisterProxy(EventCloudId id, PublishProxy proxy) {
        return this.checkEventCloudIdAndRetrieveNetworkDeployer(id).unregisterProxy(proxy);
    }

    @Override
    @MemberOf(value="deployers")
    public boolean unregisterProxy(EventCloudId id, PutGetProxy proxy) {
        return this.checkEventCloudIdAndRetrieveNetworkDeployer(id).unregisterProxy(proxy);
    }

    @Override
    @MemberOf(value="deployers")
    public boolean unregisterProxy(EventCloudId id, SubscribeProxy proxy) {
        return this.checkEventCloudIdAndRetrieveNetworkDeployer(id).unregisterProxy(proxy);
    }

    @MemberOf(value="deployers")
    private void checkEventCloudId(EventCloudId id) {
        if (!this.contains(id)) {
            throw new IllegalArgumentException("EventCloud identifier not managed: " + id);
        }
    }

    @MemberOf(value="deployers")
    private EventCloudDeployer checkEventCloudIdAndRetrieveNetworkDeployer(EventCloudId id) {
        this.checkEventCloudId(id);
        NetworkDeployer networkDeployer = this.eventCloudDeployers.get(id);
        if (!(networkDeployer instanceof EventCloudDeployer)) {
            throw new IllegalArgumentException("Network deployer associated to EventCloud identifier '" + id + "' is not an instance of EventCloudDeployer");
        }
        return (EventCloudDeployer)networkDeployer;
    }

    @Override
    @MemberOf(value="deployers")
    public boolean undeploy(EventCloudId id) {
        EventCloudDeployer deployer = this.eventCloudDeployers.remove(id);
        if (deployer != null) {
            deployer.undeploy();
            return true;
        }
        return false;
    }
}

