/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud;

import fr.inria.eventcloud.api.EventCloudId;
import fr.inria.eventcloud.api.properties.UnalterableElaProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EventCloudDescription
implements Serializable {
    private static final long serialVersionUID = 130L;
    private final EventCloudId id;
    private final long creationTime;
    private List<UnalterableElaProperty> elaProperties;

    public EventCloudDescription() {
        this(new EventCloudId(), new UnalterableElaProperty[0]);
    }

    public EventCloudDescription(String streamUrl, UnalterableElaProperty ... elaProperties) {
        this(new EventCloudId(streamUrl), elaProperties);
    }

    public EventCloudDescription(EventCloudId eventCloudId, UnalterableElaProperty ... elaProperties) {
        this.id = eventCloudId;
        this.creationTime = System.currentTimeMillis();
        if (elaProperties.length > 0) {
            this.elaProperties = new ArrayList<UnalterableElaProperty>(elaProperties.length);
            for (UnalterableElaProperty prop : elaProperties) {
                this.elaProperties.add(prop);
            }
        }
    }

    public EventCloudId getId() {
        return this.id;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public List<UnalterableElaProperty> getElaProperties() {
        return this.elaProperties;
    }
}

