/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.adapters.rdf2go;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.api.wrappers.ModelWrapper;
import fr.inria.eventcloud.api.wrappers.ResultSetWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ontoware.aifbcommons.collection.ClosableIterable;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.impl.jena29.TypeConversion;
import org.ontoware.rdf2go.model.QuadPattern;
import org.ontoware.rdf2go.model.QueryResultTable;
import org.ontoware.rdf2go.model.QueryRow;
import org.ontoware.rdf2go.model.impl.QueryRowImpl;
import org.ontoware.rdf2go.model.impl.StatementImpl;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;

public abstract class Rdf2goAdapter<T> {
    protected T delegate;

    protected Rdf2goAdapter(T delegate) {
        this.delegate = delegate;
    }

    protected static final Quadruple toQuadruple(URI context, Resource subject, URI predicate, Node object) {
        return new Quadruple(TypeConversion.toJenaNode((Object)context), TypeConversion.toJenaNode((Object)subject), TypeConversion.toJenaNode((Object)predicate), TypeConversion.toJenaNode((Object)object));
    }

    protected static final Quadruple toQuadruple(org.ontoware.rdf2go.model.Statement stmt) {
        return Rdf2goAdapter.toQuadruple(stmt.getContext(), stmt.getSubject(), stmt.getPredicate(), stmt.getObject());
    }

    protected static final QuadruplePattern toQuadruplePattern(QuadPattern quadPattern) {
        return new QuadruplePattern(TypeConversion.toJenaNode((Object)quadPattern.getContext()), TypeConversion.toJenaNode((Object)quadPattern.getSubject()), TypeConversion.toJenaNode((Object)quadPattern.getPredicate()), TypeConversion.toJenaNode((Object)quadPattern.getObject()));
    }

    protected static final ClosableIterator<org.ontoware.rdf2go.model.Statement> toClosableIterator(List<Quadruple> collection) {
        ArrayList<StatementImpl> stmts = new ArrayList<StatementImpl>();
        for (Quadruple quad : collection) {
            stmts.add(new StatementImpl((URI)TypeConversion.toRDF2Go((com.hp.hpl.jena.graph.Node)quad.getGraph()), (Resource)TypeConversion.toRDF2Go((com.hp.hpl.jena.graph.Node)quad.getSubject()), (URI)TypeConversion.toRDF2Go((com.hp.hpl.jena.graph.Node)quad.getPredicate()), TypeConversion.toRDF2Go((com.hp.hpl.jena.graph.Node)quad.getObject())));
        }
        return Rdf2goAdapter.generateClosableIterator(stmts);
    }

    public static final ClosableIterable<org.ontoware.rdf2go.model.Statement> toClosableIterable(ModelWrapper model) {
        StmtIterator stmts = model.listStatements();
        ArrayList<StatementImpl> list = new ArrayList<StatementImpl>();
        while (stmts.hasNext()) {
            Statement stmt = (Statement)stmts.next();
            list.add(new StatementImpl(null, (Resource)TypeConversion.toRDF2Go((com.hp.hpl.jena.graph.Node)stmt.getSubject().asNode()), (URI)TypeConversion.toRDF2Go((com.hp.hpl.jena.graph.Node)stmt.getPredicate().asNode()), TypeConversion.toRDF2Go((com.hp.hpl.jena.graph.Node)stmt.getObject().asNode())));
        }
        return Rdf2goAdapter.generateClosableIterable(list);
    }

    protected static QueryResultTable toQueryResultTable(final ResultSetWrapper resultSet) {
        return new QueryResultTable(){
            private static final long serialVersionUID = 130L;

            public ClosableIterator<QueryRow> iterator() {
                ArrayList<QueryRowImpl> rows = new ArrayList<QueryRowImpl>();
                while (resultSet.hasNext()) {
                    QuerySolution solution = resultSet.next();
                    QueryRowImpl row = new QueryRowImpl();
                    Iterator<String> i$ = this.getVariables().iterator();
                    while (i$.hasNext()) {
                        String var;
                        RDFNode node = solution.get(var = i$.next());
                        row.put((Object)var, (Object)TypeConversion.toRDF2Go((com.hp.hpl.jena.graph.Node)(node == null ? null : node.asNode())));
                    }
                    rows.add(row);
                }
                return Rdf2goAdapter.generateClosableIterator(rows);
            }

            public List<String> getVariables() {
                return resultSet.getResultVars();
            }
        };
    }

    private static final <T> ClosableIterable<T> generateClosableIterable(final List<T> statements) {
        return new ClosableIterable<T>(){
            private static final long serialVersionUID = 130L;

            public ClosableIterator<T> iterator() {
                return Rdf2goAdapter.generateClosableIterator(statements);
            }
        };
    }

    private static <T> ClosableIterator<T> generateClosableIterator(final List<T> rows) {
        return new ClosableIterator<T>(){
            private Iterator<T> iterator;
            {
                this.iterator = rows.iterator();
            }

            public void close() {
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public T next() {
                return this.iterator.next();
            }

            public void remove() {
                this.iterator.remove();
            }
        };
    }
}

