/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.util;

import eu.trowl.util.Types;
import java.util.Map;

public class Timer {
    public static Map<String, Timer> timers = Types.newMap();
    private boolean started;
    private String name;
    private long startTime;
    private long lastTime;
    private long totalTime;
    private int count;

    public static Timer get(String name) {
        if (!timers.containsKey(name)) {
            Timer t = new Timer(name);
            timers.put(name, t);
            return t;
        }
        return timers.get(name);
    }

    private Timer(String name) {
        if (!timers.containsKey(name)) {
            this.name = name;
            this.reset();
        }
    }

    public void reset() {
        this.started = false;
        this.totalTime = 0L;
        this.startTime = 0L;
        this.lastTime = 0L;
        this.count = 0;
    }

    public void start() {
        if (!this.started) {
            this.startTime = System.nanoTime();
            this.started = true;
        }
        ++this.count;
    }

    public void stop() {
        if (this.started) {
            this.lastTime = System.nanoTime() - this.startTime;
            this.totalTime += this.lastTime;
            this.started = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public double getTotalSeconds() {
        return (double)this.totalTime / 1000000.0;
    }

    public long getTotalMilliSeconds() {
        return this.totalTime / 1000L;
    }

    public long getTotalNanoSeconds() {
        return this.totalTime;
    }

    public long getTotal() {
        return this.totalTime;
    }

    public double getAverageSeconds() {
        return this.getTotalSeconds() / (double)this.count;
    }

    public double getAverageMilliSeconds() {
        return (double)this.getTotalMilliSeconds() / (double)this.count;
    }

    public double getAverageNanoSeconds() {
        return (double)this.getTotalNanoSeconds() / (double)this.count;
    }

    public double getAverage() {
        return (double)this.getTotal() / (double)this.count;
    }

    public long getLast() {
        return this.lastTime;
    }

    public String toString() {
        if (this.count > 1) {
            return String.valueOf(this.name) + " Avg: " + this.getAverageSeconds() + " Count: " + this.count + " Total: " + this.getTotalSeconds() + " s";
        }
        return String.valueOf(this.name) + " Total: " + this.getTotalSeconds() + " s";
    }
}

