/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.util;

import eu.trowl.TrOWLRuntimeException;
import eu.trowl.util.Log;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;

public class Settings {
    private static boolean loaded = false;
    private static Properties defaults = null;
    private static Properties custom = null;

    private static void load() {
        defaults = new Properties();
        try {
            if (Settings.class.getResourceAsStream("/configuration.properties") != null) {
                defaults.load(Settings.class.getResourceAsStream("/configuration.properties"));
            } else {
                defaults.load(new FileInputStream("configuration.properties"));
            }
        }
        catch (Exception ex) {
            try {
                defaults.load(new FileInputStream("/configuration.properties"));
            }
            catch (Exception e2) {
                TrOWLRuntimeException e = new TrOWLRuntimeException("Error loading default properties file");
                e.initCause(ex);
                throw e;
            }
        }
        custom = new Properties();
        String customConfig = System.getProperties().containsKey("TrOWL.ConfigFile") ? System.getProperty("TrOWL.ConfigFile") : "trowl.properties";
        try {
            custom.load(new FileInputStream(customConfig));
        }
        catch (IOException ex) {
            Log.log(Level.FINER, "Unable to load configuration file " + customConfig);
        }
        loaded = true;
    }

    public static String get(String key) {
        if (!loaded) {
            Settings.load();
        }
        if (System.getProperties().containsKey("TrOWL." + key) && System.getProperty("TrOWL." + key) != null && !System.getProperty("TrOWL." + key).equals("")) {
            return System.getProperty("TrOWL." + key);
        }
        if (custom.containsKey(key) && !custom.get(key).equals("")) {
            return custom.getProperty(key);
        }
        if (defaults.containsKey(key)) {
            return defaults.getProperty(key);
        }
        return null;
    }
}

