/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.rdf;

import eu.trowl.rdf.Node;
import java.net.URI;
import org.semanticweb.owlapi.model.IRI;

public class Resource
extends Node {
    public Resource() {
        this.type = 1;
    }

    public Resource(String name) {
        this.value = name;
        this.type = 1;
    }

    public Resource(URI name) {
        this.value = name.toString();
        this.uriValue = name;
        this.type = 1;
    }

    public static Resource fromBNode(String name) {
        Resource r = new Resource(name);
        r.type = 8;
        return r;
    }

    public static Resource fromNode(Node in) {
        Resource r = new Resource(in.getURI());
        r.type = 1;
        return r;
    }

    public static Resource fromURI(URI name) {
        return new Resource(name);
    }

    public static Resource fromIRI(IRI name) {
        return new Resource(name.toURI());
    }

    @Override
    public boolean sameAs(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.value != null && this.value.equals(obj.toString());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static /* bridge */ /* synthetic */ Node fromURI(URI uRI) {
        return Resource.fromURI(uRI);
    }
}

