/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.rdf;

import java.net.URI;
import java.net.URISyntaxException;

public class Node {
    protected int type;
    protected String value;
    protected URI uriValue;
    protected String lang = "";
    protected String datatype;
    private static int anonCount = 0;
    public static final int TYPE_RESOURCE = 1;
    public static final int TYPE_LITERAL = 2;
    public static final int TYPE_VARIABLE = 4;
    public static final int TYPE_BNODE = 8;
    public static final String ANON_PREFIX = "_trowl:";

    public Node() {
    }

    public Node(String value) {
        this.value = value;
    }

    public String getType() {
        return this.datatype;
    }

    public static Node fromString(String uri) throws URISyntaxException {
        Node n = new Node();
        if (uri.startsWith("<") && uri.endsWith(">")) {
            n.setURI(new URI(uri.substring(1, uri.length() - 1)));
        } else {
            n.setLiteral(uri);
        }
        return n;
    }

    public static Node fromURI(URI uri) {
        Node n = new Node();
        n.setURI(uri);
        return n;
    }

    public static Node fromVar(String var) {
        Node n = new Node();
        n.setVar(var);
        return n;
    }

    public static Node bNode(String label) {
        Node n = new Node();
        n.setLabel(label);
        return n;
    }

    public static Node bNode() {
        Node n = new Node();
        n.setLabel(ANON_PREFIX + String.valueOf(anonCount++));
        return n;
    }

    private void setURI(URI uri) {
        this.uriValue = uri;
        this.value = uri.toString();
        this.type = 1;
    }

    private void setVar(String var) {
        this.value = var.startsWith("?") || var.startsWith("$") ? var.substring(1) : var;
        this.type = 4;
    }

    private void setLabel(String var) {
        this.value = var;
        this.type = 8;
    }

    private void setLiteral(String var) {
        this.value = var;
        this.type = 2;
    }

    public URI getURI() {
        if (this.type == 1 || this.type == 8) {
            return this.uriValue;
        }
        return null;
    }

    public String getLang() {
        if (this.type != 2) {
            return null;
        }
        return this.lang;
    }

    public boolean isResource() {
        return this.type == 1 || this.type == 8;
    }

    public boolean isVar() {
        return this.type == 4;
    }

    public String getVar() {
        if (this.type == 4) {
            return this.value;
        }
        return null;
    }

    public String toString() {
        if (this.isVar()) {
            return "?" + this.value;
        }
        return this.value;
    }

    public boolean sameAs(Object a) {
        if (a == null || this.value == null) {
            return false;
        }
        return this.value.equals(a.toString());
    }
}

