/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.rdf;

import eu.trowl.rdf.IStream;
import eu.trowl.rdf.Literal;
import eu.trowl.rdf.Node;
import eu.trowl.rdf.RDFHandler;
import eu.trowl.rdf.Resource;
import eu.trowl.rdf.Triple;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;

public class NTripleReader {
    protected IStream in = null;
    protected boolean inErr = false;
    protected int errCount = 0;
    protected static final int sbLength = 200;
    protected URI base;
    protected RDFHandler handler;

    public void read(RDFHandler h, InputStream in, URI base) {
        this.read(h, new InputStreamReader(in), base);
    }

    public void read(RDFHandler h, Reader reader, URI base) {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.handler = h;
        this.base = base;
        this.in = new IStream(reader);
        this.readRDF();
    }

    public void read(RDFHandler h, URI uri) {
        try {
            this.read(h, new InputStreamReader(uri.toURL().openStream()), uri);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void readRDF() {
        ** GOTO lbl27
        {
            this.inErr = false;
            this.skipWhiteSpace();
            if (this.in.eof()) {
                return;
            }
            subject = this.readResource();
            if (this.inErr) ** GOTO lbl23
            this.skipWhiteSpace();
            predicate = this.readResource();
            if (this.inErr) ** GOTO lbl23
            this.skipWhiteSpace();
            object = this.readNode();
            if (this.inErr) ** GOTO lbl23
            this.skipWhiteSpace();
            if (this.badEOF() || !this.expect(".")) ** GOTO lbl23
            try {
                this.handler.processTriple(new Triple(subject, predicate, object));
            }
            catch (Exception var4_4) {
                // empty catch block
            }
            do {
                if (!this.in.eof()) continue block2;
lbl23:
                // 5 sources

                if (!this.inErr) continue;
                ++this.errCount;
                while (!this.in.eof() && this.in.readChar() != '\n') {
                }
lbl27:
                // 3 sources

            } while (!this.in.eof());
        }
    }

    public Resource readResource() {
        char inChar = this.in.readChar();
        if (this.badEOF()) {
            return null;
        }
        if (inChar == '_') {
            if (!this.expect(":")) {
                return null;
            }
            String name = this.readName();
            if (name == null) {
                this.syntaxError("expected bNode label");
                return null;
            }
            return Resource.fromBNode(name);
        }
        if (inChar == '<') {
            String uri = this.readURI();
            if (uri == null) {
                this.inErr = true;
                return null;
            }
            inChar = this.in.readChar();
            if (inChar != '>') {
                this.syntaxError("expected '>'");
                return null;
            }
            try {
                return Resource.fromURI(new URI(uri));
            }
            catch (URISyntaxException ex) {
                this.syntaxError("invalid URI found: " + uri);
                return null;
            }
        }
        this.syntaxError("unexpected input in Resource: " + String.valueOf(inChar));
        return null;
    }

    public Node readNode() {
        this.skipWhiteSpace();
        char nextc = this.in.nextChar();
        switch (nextc) {
            case '\"': {
                return this.readLiteral(false);
            }
            case 'x': {
                return this.readLiteral(true);
            }
            case '<': 
            case '_': {
                return this.readResource();
            }
        }
        this.syntaxError("unexpected input in Node: " + String.valueOf(nextc));
        return null;
    }

    protected void syntaxError(String err) {
        System.err.println(err);
        this.inErr = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Literal readLiteral(boolean wellFormed) {
        StringBuffer lit = new StringBuffer(200);
        if (!this.expect("\"")) {
            System.err.println("first quote");
            return null;
        }
        while (true) {
            int inChar;
            block21: {
                block22: {
                    char c;
                    block24: {
                        block23: {
                            inChar = this.in.readChar();
                            if (this.badEOF()) {
                                return null;
                            }
                            if (inChar != 92) break block22;
                            c = this.in.readChar();
                            if (this.in.eof()) {
                                this.inErr = true;
                                return null;
                            }
                            if (c != 'n') break block23;
                            inChar = 10;
                            break block21;
                        }
                        if (c != 'r') break block24;
                        inChar = 13;
                        break block21;
                    }
                    if (c == 't') {
                        inChar = 9;
                        break block21;
                    } else if (c == '\\' || c == '\"') {
                        inChar = c;
                        break block21;
                    } else {
                        if (c != 'u') {
                            this.syntaxError("illegal escape sequence '" + c + "'");
                            return null;
                        }
                        inChar = this.readUnicode4Escape();
                        if (this.inErr) {
                            return null;
                        }
                    }
                    break block21;
                }
                if (inChar == 34) {
                    String lang;
                    if ('@' == this.in.nextChar()) {
                        this.expect("@");
                        lang = this.readLang();
                    } else if ('-' == this.in.nextChar()) {
                        this.expect("-");
                        this.deprecated("Language tags should be introduced with @ not -.");
                        lang = this.readLang();
                    } else {
                        lang = "";
                    }
                    if (wellFormed) {
                        Literal.create(lit.toString(), wellFormed);
                    } else {
                        if ('^' != this.in.nextChar()) {
                            return Literal.create(lit.toString(), lang);
                        }
                        String datatypeURI = null;
                        if (!this.expect("^^<")) {
                            this.syntaxError("ill-formed datatype");
                            return null;
                        }
                        datatypeURI = this.readURI();
                        if (datatypeURI == null || !this.expect(">")) {
                            return null;
                        }
                        if (lang.length() > 0) {
                            this.deprecated("Language tags are not permitted on typed literals.");
                        }
                        return Literal.createTyped(lit.toString(), datatypeURI);
                    }
                }
            }
            lit = lit.append((char)inChar);
        }
    }

    private char readUnicode4Escape() {
        char[] buf = new char[]{this.in.readChar(), this.in.readChar(), this.in.readChar(), this.in.readChar()};
        if (this.badEOF()) {
            return '\u0000';
        }
        try {
            return (char)Integer.parseInt(new String(buf), 16);
        }
        catch (NumberFormatException e) {
            this.syntaxError("bad unicode escape sequence");
            return '\u0000';
        }
    }

    private void deprecated(String s) {
    }

    private String readLang() {
        StringBuffer lang = new StringBuffer(15);
        char inChar;
        while (!Character.isWhitespace(inChar = this.in.nextChar()) && inChar != '.' && inChar != '^') {
            lang = lang.append(this.in.readChar());
        }
        return lang.toString();
    }

    protected boolean badEOF() {
        if (this.in.eof()) {
            this.syntaxError("premature end of file");
        }
        return this.inErr;
    }

    protected String readURI() {
        StringBuffer uri = new StringBuffer(200);
        while (this.in.nextChar() != '>') {
            char inChar = this.in.readChar();
            if (inChar == '\\') {
                this.expect("u");
                inChar = this.readUnicode4Escape();
            }
            if (this.badEOF()) {
                return null;
            }
            uri = uri.append(inChar);
        }
        return uri.toString();
    }

    protected String readName() {
        StringBuffer name = new StringBuffer(200);
        while (!Character.isWhitespace(this.in.nextChar())) {
            name = name.append(this.in.readChar());
            if (!this.badEOF()) continue;
            return null;
        }
        return name.toString();
    }

    protected boolean expect(String str) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char want = str.charAt(i);
            if (this.badEOF()) {
                return false;
            }
            char inChar = this.in.readChar();
            b.append(inChar);
            if (inChar != want) {
                this.syntaxError("expected \"" + str + "\" found \"" + b.toString() + "\"");
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void skipWhiteSpace() {
        while (Character.isWhitespace(this.in.nextChar()) || this.in.nextChar() == '#') {
            char inChar = this.in.readChar();
            if (this.in.eof()) {
                return;
            }
            if (inChar != '#') continue;
            while (inChar != '\n') {
                inChar = this.in.readChar();
                if (!this.in.eof()) continue;
                return;
            }
        }
    }

    protected String syntaxErrorMessage(String sort, String msg, int linepos, int charpos) {
        return this.base + sort + " at line " + linepos + " position " + charpos + ": " + msg;
    }
}

