/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.query.sparql.endpoint;

import eu.trowl.db.DB;
import eu.trowl.db.DBFactory;
import eu.trowl.query.CSVResultSetFormatter;
import eu.trowl.query.HTMLResultSetFormatter;
import eu.trowl.query.JSONResultSetFormatter;
import eu.trowl.query.Query;
import eu.trowl.query.QueryException;
import eu.trowl.query.QueryFactory;
import eu.trowl.query.ResultSet;
import eu.trowl.query.ResultSetFormatter;
import eu.trowl.query.TSVResultSetFormatter;
import eu.trowl.query.XMLResultSetFormatter;
import eu.trowl.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class QueryServlet
extends HttpServlet {
    private static String htmlForm = null;
    private static DB db = null;

    public QueryServlet(String repository) {
        block16: {
            if (db == null) {
                try {
                    db = DBFactory.construct(repository);
                    db.connect();
                }
                catch (Exception ex) {
                    Log.log(Level.SEVERE, null, ex);
                }
            }
            if (htmlForm == null) {
                InputStream is = QueryServlet.class.getResourceAsStream("/queryForm.html");
                Reader in = null;
                try {
                    try {
                        int read;
                        char[] buffer = new char[65536];
                        StringBuilder out = new StringBuilder();
                        in = new InputStreamReader(is, "UTF-8");
                        do {
                            if ((read = in.read(buffer, 0, buffer.length)) <= 0) continue;
                            out.append(buffer, 0, read);
                        } while (read >= 0);
                        htmlForm = out.toString();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(QueryServlet.class.getName()).log(Level.SEVERE, null, ex);
                        try {
                            in.close();
                        }
                        catch (Exception ex2) {
                            Logger.getLogger(QueryServlet.class.getName()).log(Level.SEVERE, null, ex2);
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(QueryServlet.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(QueryServlet.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        Log.info("Query Servlet started successfully");
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block18: {
            PrintWriter out = response.getWriter();
            try {
                try {
                    ResultSetFormatter formatter;
                    String queryString = request.getParameter("query");
                    if (queryString == null || queryString.length() == 0) {
                        if (htmlForm == null) {
                            response.sendError(204);
                        } else {
                            response.setContentType("text/html;charset=UTF-8");
                            out.print(htmlForm);
                        }
                        break block18;
                    }
                    Query sparql = QueryFactory.create(queryString);
                    sparql.setDB(db);
                    ResultSet rs = sparql.execute();
                    String output = request.getParameter("output");
                    if (output.equals("xml")) {
                        response.setContentType("text/xml;charset=UTF-8");
                        formatter = new XMLResultSetFormatter(rs);
                    } else if (output.equals("html")) {
                        response.setContentType("text/html;charset=UTF-8");
                        formatter = new HTMLResultSetFormatter(rs);
                    } else if (output.equals("json")) {
                        response.setContentType("application/json;charset=UTF-8");
                        formatter = new JSONResultSetFormatter(rs);
                        response.setHeader("Content-Disposition", "attachment;filename=results.json");
                    } else if (output.equals("csv")) {
                        response.setContentType("text/csv;charset=UTF-8");
                        formatter = new CSVResultSetFormatter(rs);
                        response.setHeader("Content-Disposition", "attachment;filename=results.csv");
                    } else if (output.equals("tsv")) {
                        response.setContentType("text/tsv;charset=UTF-8");
                        formatter = new TSVResultSetFormatter(rs);
                        response.setHeader("Content-Disposition", "attachment;filename=results.tsv");
                    } else {
                        response.setContentType("text/xml;charset=UTF-8");
                        formatter = new XMLResultSetFormatter(rs);
                    }
                    ((ResultSetFormatter)formatter).write(out);
                }
                catch (QueryException e) {
                    PrintWriter writer = new PrintWriter(out);
                    writer.println(e.getMessage());
                    e.printStackTrace();
                    out.close();
                }
            }
            finally {
                out.close();
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "TrOWL Query Servlet";
    }
}

