/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.query.sparql;

import eu.trowl.query.Concept;
import eu.trowl.query.Query;
import eu.trowl.query.QuerySyntaxException;
import eu.trowl.query.QueryTypeException;
import eu.trowl.query.Role;
import eu.trowl.query.sparql.FromClause;
import eu.trowl.query.sparql.SelectClause;
import eu.trowl.query.sparql.WhereClause;
import eu.trowl.rdf.Node;
import eu.trowl.rdf.SPARQLTriple;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SPARQLQuery
extends Query {
    private final SelectClause selectClause = new SelectClause();
    private final FromClause fromClause = new FromClause();
    private final WhereClause whereClause = new WhereClause();
    protected ArrayList<Concept> concepts;
    protected ArrayList<Role> roles;
    private int queryType = 0;
    private URI baseURI = null;
    public static final int TYPE_SELECT = 1;
    public static final int TYPE_ASK = 2;
    public static final int TYPE_DESCRIBE = 4;
    public static final int TYPE_CONSTRUCT = 8;
    private Map<String, URI> prefixes = new HashMap<String, URI>();

    public void setQuerySelectType() throws QueryTypeException {
        this.queryType = 1;
    }

    public void setQueryDescribeType() throws QueryTypeException {
        this.queryType = 4;
    }

    public void setQueryAskType() throws QueryTypeException {
        this.queryType = 2;
    }

    public void setQueryConstructType() throws QueryTypeException {
        this.queryType = 8;
    }

    public void setDistinct(boolean val) {
    }

    public void setReduced(boolean val) {
    }

    public void setQueryResultStar(boolean val) {
        this.queryResultStar = val;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public WhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setPrefix(String name, URI uri) {
        this.prefixes.put(name, uri);
    }

    public URI getPrefix(String name) {
        if (this.prefixes.containsKey(name)) {
            return this.prefixes.get(name);
        }
        URI value = null;
        value = this.lookupPrefix(name);
        this.setPrefix(name, value);
        return value;
    }

    private URI lookupPrefix(String name) {
        try {
            URL prefixURL = new URL("http://prefix.cc/" + name + ".file.txt");
            BufferedReader in = new BufferedReader(new InputStreamReader(prefixURL.openStream()));
            String raw = in.readLine();
            in.close();
            URI value = URI.create(raw.substring(raw.indexOf("\t") + 1));
            return value;
        }
        catch (Exception ex) {
            Logger.getLogger(SPARQLQuery.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setBaseURI(URI uri) {
        this.baseURI = uri;
    }

    @Override
    public void process() throws QuerySyntaxException {
        for (Node v : this.selectClause.getVariables()) {
            this.addBoundVar(v.getVar());
        }
        if (this.whereClause != null && this.whereClause.getBasicGraphPattern() != null && this.whereClause.getBasicGraphPattern().getTriples() != null) {
            for (SPARQLTriple t : this.whereClause.getBasicGraphPattern().getTriples()) {
                if (this.queryResultStar) {
                    if (t.getSubject().isVar()) {
                        this.addBoundVar(t.getSubject().getVar());
                    }
                    if (t.getPredicate().isVar()) {
                        this.addBoundVar(t.getPredicate().getVar());
                    }
                    if (t.getObject().isVar()) {
                        this.addBoundVar(t.getObject().getVar());
                    }
                }
                if (t.getPredicate().isVar()) {
                    throw new QuerySyntaxException("Variables not supported in property position in queries");
                }
                if (t.isType()) {
                    if (t.getObject().isVar()) {
                        throw new QuerySyntaxException("Variables not supported as object in rdf:type triples");
                    }
                    this.classes.add(new Concept(t.getObject().toString(), t.getSubject()));
                    continue;
                }
                if (t.isSubClass() || t.isSubProperty()) continue;
                if (t.isFoundAt()) {
                    if (t.getObject().isVar() && t.getSubject().isVar()) {
                        this.foundAt.put(t.getSubject().getVar(), t.getObject().getVar());
                        continue;
                    }
                    throw new QuerySyntaxException("trowl:foundAt must be part of a triple with two variables");
                }
                this.properties.add(new Role(t.getPredicate().toString(), t.getSubject().toString(), t.getObject().toString()));
            }
        }
    }
}

