/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.query.sparql;

import eu.trowl.query.QuerySyntaxException;
import eu.trowl.query.sparql.GraphPattern;
import eu.trowl.query.sparql.SPARQLQuery;
import eu.trowl.rdf.Node;
import eu.trowl.rdf.SPARQLTriple;
import eu.trowl.vocab.XSD;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SPARQLParserBase {
    private SPARQLQuery query;

    public SPARQLQuery getQuery() {
        if (this.query == null) {
            try {
                this.query = new SPARQLQuery();
            }
            catch (Exception ex) {
                Logger.getLogger(SPARQLParserBase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.query;
    }

    public Node createVariable(String name, int line, int col) {
        return Node.fromVar(name);
    }

    public Node createNodeFromURI(String uri, int line, int col) throws QuerySyntaxException {
        try {
            return Node.fromURI(this.trimURI(uri));
        }
        catch (URISyntaxException ex) {
            QuerySyntaxException e = new QuerySyntaxException("Invalid URI in node: line " + line + ", col " + col);
            e.initCause(ex);
            throw e;
        }
    }

    public URI trimURI(String in) throws URISyntaxException {
        return new URI(in.substring(1, in.length() - 1));
    }

    public Node createBNode(String label, int line, int col) {
        return Node.bNode(label);
    }

    public Node createBNode() {
        return Node.bNode();
    }

    public Node makeNode(String lex, String lang, Node datatype) {
        return Node.fromVar(lex);
    }

    public Node makeNode(String lex, String lang, URI uri) {
        return Node.fromVar(lex);
    }

    public Node makeNodeInteger(String val) {
        return this.makeNode(val, null, XSD.INTEGER);
    }

    public Node makeNodeDecimal(String val) {
        return this.makeNode(val, null, XSD.DECIMAL);
    }

    public Node makeNodeDouble(String val) {
        return this.makeNode(val, null, XSD.DOUBLE);
    }

    public void addGraphURI(URI uri) {
        this.query.getFromClause().addGraphURI(uri);
    }

    protected void insert(GraphPattern g, Node s, Node p, Node o) {
        g.addTriple(new SPARQLTriple(s, p, o));
    }

    protected String stripQuotes(String in) {
        return in.substring(1, in.length() - 1);
    }

    protected String stripQuotes3(String in) {
        return in.substring(3, in.length() - 3);
    }

    protected Node createNodeFromPrefixedName(String s, int line, int col) throws QuerySyntaxException {
        String prefix = s.substring(0, s.indexOf(58));
        String postfix = s.substring(s.indexOf(58) + 1);
        URI expanded = this.getQuery().getPrefix(prefix);
        if (expanded == null) {
            throw new QuerySyntaxException("Unresolved prefix name: " + s);
        }
        try {
            return Node.fromURI(new URI(String.valueOf(expanded.toString()) + postfix));
        }
        catch (URISyntaxException ex) {
            QuerySyntaxException e = new QuerySyntaxException("Invalid URI in node: line " + line + ", col " + col);
            e.initCause(ex);
            throw e;
        }
    }

    protected void setFixedPrefix(String prefix, URI uri) {
        this.getQuery().setPrefix(prefix.substring(0, prefix.length() - 1), uri);
    }

    protected String unescapeString(String in, int line, int col) {
        return in;
    }
}

