/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.query;

import eu.trowl.query.ResultSet;
import eu.trowl.query.ResultSetFormatter;
import java.util.ArrayList;
import java.util.List;

public class TextResultSetFormatter
extends ResultSetFormatter {
    private StringBuffer out;

    public TextResultSetFormatter(ResultSet rs) {
        super(rs);
    }

    @Override
    public String format() {
        this.out = new StringBuffer();
        int cols = this.rs.getMetaData().getColumnCount();
        ArrayList<Integer> maxWidth = new ArrayList<Integer>();
        int i = 1;
        while (i <= cols) {
            maxWidth.add(new Integer(this.rs.getMetaData().getColumnName(i).length()));
            ++i;
        }
        while (this.rs.next()) {
            i = 1;
            while (i <= cols) {
                if ((Integer)maxWidth.get(i - 1) < this.rs.getString(i).length()) {
                    maxWidth.set(i - 1, new Integer(this.rs.getString(i).length()));
                }
                ++i;
            }
        }
        int total = this.totalWidth(maxWidth);
        int i2 = 1;
        while (i2 <= cols) {
            this.buf(this.rs.getMetaData().getColumnName(i2), (Integer)maxWidth.get(i2 - 1));
            this.out.append(' ');
            if (i2 < cols) {
                this.sep();
                this.out.append(' ');
            }
            ++i2;
        }
        this.out.append('\n');
        this.repeat('-', total);
        this.rs.beforeFirst();
        while (this.rs.next()) {
            i2 = 1;
            while (i2 <= cols) {
                this.buf(this.rs.getString(i2), (Integer)maxWidth.get(i2 - 1));
                this.out.append(' ');
                if (i2 < cols) {
                    this.sep();
                    this.out.append(' ');
                }
                ++i2;
            }
            this.out.append('\n');
        }
        this.repeat('-', total);
        return this.out.toString();
    }

    private void repeat(char what, int howmany) {
        int i = 0;
        while (i < howmany) {
            this.out.append(what);
            ++i;
        }
        this.out.append('\n');
    }

    private int totalWidth(List<Integer> w) {
        int t = 0;
        int i = 0;
        while (i < w.size()) {
            t += 2;
            t += w.get(i).intValue();
            ++i;
        }
        return t;
    }

    private void sep() {
        this.out.append("|");
    }

    private void buf(String what, int len) {
        this.out.append(what);
        int i = what.length();
        while (i < len) {
            this.out.append(' ');
            ++i;
        }
    }
}

