/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.query;

import eu.trowl.query.ResultSet;
import eu.trowl.query.ResultSetFormatter;
import eu.trowl.util.Log;
import eu.trowl.util.Types;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JSONResultSetFormatter
extends ResultSetFormatter {
    public JSONResultSetFormatter(ResultSet rs) {
        super(rs);
    }

    @Override
    public String format() {
        StringWriter in = new StringWriter();
        try {
            this.write(in);
        }
        catch (IOException ex) {
            Log.log(Level.SEVERE, "StringWriter managed to throw an IO exception while writing an XML Result", ex);
        }
        return in.toString();
    }

    @Override
    public void write(Writer out) throws IOException {
        JSONObject main = new JSONObject();
        JSONObject head = new JSONObject();
        JSONObject results = new JSONObject();
        JSONArray bindings = new JSONArray();
        JSONArray vars = new JSONArray();
        List v = Types.newList();
        int cols = this.rs.getMetaData().getColumnCount();
        int i = 0;
        while (i < cols) {
            v.add(this.rs.getMetaData().getColumnName(i + 1));
            ++i;
        }
        vars.addAll(v);
        head.put((Object)"vars", (Object)vars);
        main.put((Object)"head", (Object)head);
        while (this.rs.next()) {
            JSONObject row = new JSONObject();
            int i2 = 0;
            while (i2 < cols) {
                row.put(v.get(i2), this.rs.getObject(i2 + 1));
                ++i2;
            }
            bindings.add((Object)row);
        }
        results.put((Object)"bindings", (Object)bindings);
        main.put((Object)"results", (Object)results);
        main.writeJSONString(out);
    }
}

