/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.query;

import eu.trowl.query.ResultSet;
import eu.trowl.query.ResultSetFormatter;
import eu.trowl.query.ResultSetMetaData;
import eu.trowl.util.Log;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class HTMLResultSetFormatter
extends ResultSetFormatter {
    public HTMLResultSetFormatter(ResultSet rs) {
        super(rs);
    }

    @Override
    public String format() {
        StringWriter in = new StringWriter();
        try {
            this.write(in);
        }
        catch (IOException ex) {
            Log.log(Level.SEVERE, "StringWriter managed to throw an IO exception while writing an XML Result", ex);
        }
        return in.toString();
    }

    @Override
    public void write(Writer out) throws IOException {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("html");
            writer.writeDefaultNamespace("http://www.w3.org/1999/xhtml#");
            writer.writeDTD("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Strinct//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            writer.writeStartElement("head");
            writer.writeStartElement("title");
            writer.writeCData("TrOWL Query Results");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("body");
            writer.writeStartElement("table");
            writer.writeStartElement("th");
            int i = 0;
            while (i < columnCount) {
                writer.writeStartElement("td");
                writer.writeCData(rsmd.getColumnName(i + 1));
                writer.writeEndElement();
                ++i;
            }
            writer.writeEndElement();
            writer.writeStartElement("results");
            writer.writeAttribute("ordered", String.valueOf(this.rs.hasRowRanks()));
            writer.writeAttribute("distinct", "false");
            writer.writeEndElement();
            while (this.rs.next()) {
                writer.writeStartElement("result");
                i = 0;
                while (i < columnCount) {
                    writer.writeStartElement("binding");
                    writer.writeAttribute("name", rsmd.getColumnName(i + 1));
                    writer.writeStartElement("uri");
                    writer.writeCharacters(this.rs.getString(i + 1));
                    writer.writeEndElement();
                    writer.writeEndElement();
                    ++i;
                }
                if (this.rs.hasRowRanks()) {
                    writer.writeStartElement("binding");
                    writer.writeAttribute("name", "Rank");
                    writer.writeStartElement("bnode");
                    writer.writeCharacters(String.valueOf(this.rs.getRank()));
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndDocument();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(HTMLResultSetFormatter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

