/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.query;

import eu.trowl.query.ResultSet;
import eu.trowl.query.ResultSetFormatter;
import eu.trowl.util.Log;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;

public abstract class DelimitedResultSetFormatter
extends ResultSetFormatter {
    protected String delimiter;

    public DelimitedResultSetFormatter(ResultSet rs) {
        super(rs);
    }

    @Override
    public String format() {
        StringWriter in = new StringWriter();
        try {
            this.write(in);
        }
        catch (IOException ex) {
            Log.log(Level.SEVERE, "StringWriter managed to throw an IO exception while writing an XML Result", ex);
        }
        return in.toString();
    }

    @Override
    public void write(Writer out) throws IOException {
        int cols = this.rs.getMetaData().getColumnCount();
        int i = 0;
        while (i < cols) {
            out.write(this.rs.getMetaData().getColumnName(i + 1));
            if (i + 1 < cols) {
                out.write(this.delimiter);
            }
            ++i;
        }
        while (this.rs.next()) {
            i = 0;
            while (i < cols) {
                out.write(this.rs.getMetaData().getColumnName(i + 1));
                if (i + 1 < cols) {
                    out.write(this.delimiter);
                }
                ++i;
            }
        }
    }
}

