/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.util;

import java.util.ArrayList;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.util.SimpleIRIMapper;

public class Generator {
    public static void generate(String prefix, String physical, Set<OWLAxiom> axioms) throws OWLOntologyCreationException, OWLOntologyChangeException, UnknownOWLOntologyException, OWLOntologyStorageException {
        IRI ontologyURI = IRI.create((String)prefix);
        IRI physicalURI = IRI.create((String)physical);
        SimpleIRIMapper mapper = new SimpleIRIMapper(ontologyURI, physicalURI);
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        manager.addIRIMapper((OWLOntologyIRIMapper)mapper);
        OWLOntology ontology = manager.createOntology(ontologyURI);
        ArrayList<AddAxiom> addAxioms = new ArrayList<AddAxiom>();
        for (OWLAxiom axiom : axioms) {
            addAxioms.add(new AddAxiom(ontology, axiom));
        }
        manager.applyChanges(addAxioms);
        manager.saveOntology(ontology);
        System.out.println("Ontology Saved to " + physical);
    }

    public static void generate(String prefix, String physical, ArrayList<OWLLogicalAxiom> axioms) throws OWLOntologyCreationException, OWLOntologyChangeException, UnknownOWLOntologyException, OWLOntologyStorageException {
        IRI ontologyURI = IRI.create((String)prefix);
        IRI physicalURI = IRI.create((String)physical);
        SimpleIRIMapper mapper = new SimpleIRIMapper(ontologyURI, physicalURI);
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        manager.addIRIMapper((OWLOntologyIRIMapper)mapper);
        OWLOntology ontology = manager.createOntology(ontologyURI);
        ArrayList<AddAxiom> addAxioms = new ArrayList<AddAxiom>();
        for (OWLAxiom oWLAxiom : axioms) {
            addAxioms.add(new AddAxiom(ontology, oWLAxiom));
        }
        manager.applyChanges(addAxioms);
        manager.saveOntology(ontology);
        System.out.println("Ontology Saved to " + physical);
    }
}

