/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.tms.reasoner.el;

import eu.trowl.owlapi3.rel.tms.classify.el.Classifier;
import eu.trowl.owlapi3.rel.tms.classify.el.NFClassifier;
import eu.trowl.owlapi3.rel.tms.factory.el.OntologyFactory;
import eu.trowl.owlapi3.rel.tms.model.Atomic;
import eu.trowl.owlapi3.rel.tms.model.AxiomPool;
import eu.trowl.owlapi3.rel.tms.model.Basic;
import eu.trowl.owlapi3.rel.tms.model.Description;
import eu.trowl.owlapi3.rel.tms.model.Implies;
import eu.trowl.owlapi3.rel.tms.model.Individual;
import eu.trowl.owlapi3.rel.tms.model.Ontology;
import eu.trowl.owlapi3.rel.tms.model.QueueEntry;
import eu.trowl.owlapi3.rel.tms.model.Role;
import eu.trowl.owlapi3.rel.tms.model.RoleConcept;
import eu.trowl.owlapi3.rel.tms.model.Some;
import eu.trowl.owlapi3.rel.tms.model.Traceability;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.Version;

public class RELReasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    protected Version version = new Version(0, 9, 0, 0);
    protected Ontology elcontology;
    public final OWLOntologyManager manager;
    protected final OWLDataFactory factory;
    protected OntologyFactory elcfactory = null;
    protected boolean nominalfree = false;
    public ArrayList<OWLNamedIndividual> inconsistentIndividuals = new ArrayList();
    protected Classifier classifier;
    protected OWLOntology ontology = null;
    protected OWLClassNodeSet satisfiable = new OWLClassNodeSet();
    protected OWLClassNodeSet leaves = new OWLClassNodeSet();
    public boolean bufferred = true;
    protected Set<OWLAxiom> toadd = new HashSet<OWLAxiom>();
    protected Set<OWLAxiom> toremove = new HashSet<OWLAxiom>();
    protected List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();

    public RELReasoner(OWLOntologyManager manager, OWLOntology ontology) {
        this(manager, ontology, false);
    }

    public RELReasoner(OWLOntologyManager manager, OWLOntology ontology, boolean NF) {
        this.manager = manager;
        this.factory = manager.getOWLDataFactory();
        this.ontology = ontology;
        this.nominalfree = NF;
        this.initialiseClassifier();
        this.loadOntology();
        this.classify();
    }

    protected void initialiseClassifier() {
        this.classifier = new NFClassifier();
    }

    public void loadOntology() {
        this.elcfactory = new OntologyFactory(this.ontology, this.nominalfree);
        this.elcfactory.createbuilder();
        this.elcontology = this.elcfactory.createELOntology();
    }

    public void loadOntology(String output) throws OWLOntologyCreationException, UnknownOWLOntologyException, OWLOntologyChangeException, OWLOntologyStorageException {
        this.elcfactory = new OntologyFactory(this.ontology, this.nominalfree);
        this.elcfactory.createbuilder();
        this.elcontology = this.elcfactory.createELOntology(output);
    }

    public OWLOntology getRootOntology() {
        return this.ontology;
    }

    protected Description getDescription(OWLClassExpression desc) {
        if (this.elcontology.classID.get(desc) != null) {
            return this.elcontology.descriptions.get(this.elcontology.classID.get(desc));
        }
        return null;
    }

    protected Role getRole(OWLObjectPropertyExpression role) {
        if (this.elcontology.roleID.get(role) != null) {
            return this.elcontology.roles.get(this.elcontology.roleID.get(role));
        }
        return null;
    }

    protected Role getRole(OWLDataPropertyExpression role) {
        OWLObjectProperty objrole = this.factory.getOWLObjectProperty(role.asOWLDataProperty().getIRI());
        if (this.elcontology.roleID.get(objrole) != null) {
            return this.elcontology.roles.get(this.elcontology.roleID.get(objrole));
        }
        return null;
    }

    public boolean isoriginal(OWLClass concept) {
        Basic elpconcept = (Basic)this.getDescription((OWLClassExpression)concept);
        if (elpconcept != null) {
            return elpconcept.original;
        }
        return false;
    }

    public boolean isConsistent() {
        return this.elcontology.consistency;
    }

    public void classify() {
        this.classifier.ontology = this.elcontology;
        this.classifier.Completion(false);
        this.postprocess();
    }

    public void reclassify() {
        this.classifier.Completion(true);
        this.postprocess();
    }

    private void postprocess() {
        OWLClassNode ancestor;
        Basic sub;
        HashSet<Basic> satis = new HashSet<Basic>(this.elcontology.allconcepts);
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        satis.removeAll(bot.equivalence);
        this.leaves = new OWLClassNodeSet();
        this.satisfiable = new OWLClassNodeSet();
        HashSet<Basic> leaf = new HashSet<Basic>(satis);
        for (Basic basic : satis) {
            if (!leaf.contains(basic)) continue;
            Atomic atom = (Atomic)basic;
            for (Basic sub2 : atom.subsumers.keySet()) {
                if (atom.equivalence.contains(sub2)) continue;
                leaf.removeAll(sub2.equivalence);
            }
        }
        while (satis.size() > 0) {
            sub = satis.iterator().next();
            satis.removeAll(sub.equivalence);
            ancestor = new OWLClassNode();
            for (Basic eq : sub.equivalence) {
                if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                ancestor.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
            }
            if (ancestor.getSize() <= 0) continue;
            this.satisfiable.addNode((Node)ancestor);
        }
        while (leaf.size() > 0) {
            sub = leaf.iterator().next();
            leaf.removeAll(sub.equivalence);
            ancestor = new OWLClassNode();
            for (Basic eq : sub.equivalence) {
                if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                ancestor.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
            }
            if (ancestor.getSize() <= 0) continue;
            this.leaves.addNode((Node)ancestor);
        }
        this.elcontology.classified = true;
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression arg0) {
        OWLClassNode equivalence = new OWLClassNode();
        Description desc = this.getDescription(arg0);
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        if (desc != null && desc instanceof Atomic) {
            Atomic atomic = (Atomic)desc;
            if (atomic.equivalence.contains(bot) && atomic.id != 0) {
                return this.getEquivalentClasses((OWLClassExpression)this.factory.getOWLNothing());
            }
            for (Basic eq : atomic.equivalence) {
                if (!(eq instanceof Atomic) || !eq.original) continue;
                equivalence.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
            }
        }
        return equivalence;
    }

    public Node<OWLClass> getUnsatisfiableClasses() {
        OWLClassNode toreturn = new OWLClassNode();
        Basic bot = (Basic)this.elcontology.descriptions.get(0);
        for (Basic concept : bot.equivalence) {
            if (!(concept instanceof Atomic)) continue;
            toreturn.add((OWLObject)this.factory.getOWLClass(((Atomic)concept).uri));
        }
        return toreturn;
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression arg0, boolean arg1) {
        OWLClassNodeSet descendants = new OWLClassNodeSet();
        Description desc = this.getDescription(arg0);
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        if (desc != null && desc instanceof Atomic) {
            Atomic atom = (Atomic)desc;
            if (atom.equivalence.contains(bot)) {
                return descendants;
            }
            HashSet<Basic> subsumees = new HashSet<Basic>();
            if (arg1) {
                for (Basic sub : this.elcontology.allconcepts) {
                    if (sub.subsumers.containsKey(bot) || atom.equivalence.contains(sub) || subsumees.contains(sub) || !sub.subsumers.containsKey(atom)) continue;
                    boolean toadd = true;
                    for (Basic subsub : sub.subsumers.keySet()) {
                        if (!subsub.original || sub.equivalence.contains(subsub) || atom.equivalence.contains(subsub) || !subsub.subsumers.containsKey(atom)) continue;
                        toadd = false;
                        break;
                    }
                    if (!toadd) continue;
                    subsumees.addAll(sub.equivalence);
                }
            } else {
                for (Basic sub : this.elcontology.allconcepts) {
                    if (!sub.subsumers.containsKey(atom) || sub.equivalence.contains(atom)) continue;
                    subsumees.add(sub);
                }
                subsumees.addAll(bot.equivalence);
            }
            while (subsumees.size() > 0) {
                Basic sub;
                sub = (Basic)subsumees.iterator().next();
                subsumees.removeAll(sub.equivalence);
                OWLClassNode descendant = new OWLClassNode();
                for (Basic eq : sub.equivalence) {
                    if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                    descendant.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
                }
                if (descendant.getSize() <= 0) continue;
                descendants.addNode((Node)descendant);
            }
        }
        return descendants;
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression arg0, boolean arg1) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ancestors;
        block9: {
            ancestors = new OWLClassNodeSet();
            Description desc = this.getDescription(arg0);
            Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
            if (desc == null || !(desc instanceof Atomic)) break block9;
            Atomic atom = (Atomic)desc;
            HashSet<Basic> subsumers = new HashSet<Basic>();
            if (arg1) {
                if (atom.equivalence.contains(bot)) {
                    return this.leaves;
                }
                for (Basic sub : atom.subsumers.keySet()) {
                    if (!sub.original || atom.equivalence.contains(sub) || subsumers.contains(sub)) continue;
                    boolean toadd = true;
                    for (Basic sub2 : atom.subsumers.keySet()) {
                        if (!sub2.original || atom.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.containsKey(sub)) continue;
                        toadd = false;
                        break;
                    }
                    if (!toadd) continue;
                    subsumers.addAll(sub.equivalence);
                }
            } else {
                if (atom.equivalence.contains(bot)) {
                    return this.satisfiable;
                }
                for (Basic sub : atom.subsumers.keySet()) {
                    if (atom.equivalence.contains(sub) || !sub.original) continue;
                    subsumers.add(sub);
                }
            }
            while (subsumers.size() > 0) {
                Basic sub;
                sub = (Basic)subsumers.iterator().next();
                subsumers.removeAll(sub.equivalence);
                OWLClassNode ancestor = new OWLClassNode();
                for (Basic eq : sub.equivalence) {
                    if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                    ancestor.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
                }
                if (ancestor.getSize() <= 0) continue;
                ancestors.addNode((Node)ancestor);
            }
        }
        return ancestors;
    }

    public boolean isSatisfiable(OWLClassExpression arg0) {
        OWLSubClassOfAxiom axiom1 = this.factory.getOWLSubClassOfAxiom(arg0, (OWLClassExpression)this.factory.getOWLNothing());
        return !this.entail(axiom1);
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression arg0, boolean arg1) {
        return this.getIndividuals(arg0);
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual arg0, OWLDataProperty arg1) {
        return new HashSet<OWLLiteral>();
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Basic top;
        OWLClassNodeSet toreturn = new OWLClassNodeSet();
        Role role = this.getRole(arg0);
        if (role != null && role.somes.get(top = (Basic)this.elcontology.descriptions.get(1)) != null) {
            HashSet<Basic> domains = new HashSet<Basic>();
            for (QueueEntry entry : role.somes.get((Object)top).Ohat.keySet()) {
                if (!(entry instanceof Implies)) continue;
                Implies imply = (Implies)entry;
                if (imply.lhs.size() != 0 || !imply.rhs.original) continue;
                domains.add(imply.rhs);
            }
            while (domains.size() > 0) {
                Basic sub = (Basic)domains.iterator().next();
                domains.removeAll(sub.equivalence);
                OWLClassNode type = new OWLClassNode();
                for (Basic eq : sub.equivalence) {
                    if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                    type.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
                }
                if (type.getSize() <= 0) continue;
                toreturn.addNode((Node)type);
            }
        }
        return toreturn;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty arg0, boolean arg1) {
        return new OWLClassNodeSet();
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNode equivalence = new OWLObjectPropertyNode();
        Role desc = this.getRole(arg0);
        if (desc != null) {
            for (Role eq : desc.equivalence) {
                if (!eq.original) continue;
                equivalence.add((OWLObject)this.factory.getOWLObjectProperty(eq.uri));
            }
        }
        return equivalence;
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNode equivalence = new OWLDataPropertyNode();
        Role desc = this.getRole((OWLDataPropertyExpression)arg0);
        if (desc != null) {
            for (Role eq : desc.equivalence) {
                if (!eq.original) continue;
                equivalence.add((OWLObject)this.factory.getOWLDataProperty(eq.uri));
            }
        }
        return equivalence;
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet toreturn = new OWLClassNodeSet();
        Role role = this.getRole(arg0);
        if (role != null) {
            block0: for (Map.Entry<Basic, Some> entry : role.somes.entrySet()) {
                if (!(entry.getKey().complement instanceof Atomic) || !entry.getKey().complement.original) continue;
                Atomic range = (Atomic)entry.getKey().complement;
                for (QueueEntry ohat : entry.getValue().Ohat.keySet()) {
                    if (!(ohat instanceof Implies)) continue;
                    Implies imply = (Implies)ohat;
                    if (imply.lhs.size() != 0 || imply.rhs.id != 0) continue;
                    OWLClassNode type = new OWLClassNode();
                    for (Basic eq : range.equivalence) {
                        if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                        type.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
                    }
                    if (type.getSize() <= 0) continue block0;
                    toreturn.addNode((Node)type);
                    continue block0;
                }
            }
        }
        return toreturn;
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet descendants;
        block7: {
            descendants = new OWLObjectPropertyNodeSet();
            Role role = this.getRole(arg0);
            if (role == null) break block7;
            HashSet<Role> subsumees = new HashSet<Role>();
            if (arg1) {
                for (Role sub : this.elcontology.roles.values()) {
                    if (role.equivalence.contains(sub) || subsumees.contains(sub) || !sub.subsumers.containsKey(role)) continue;
                    boolean toadd = true;
                    for (Role subsub : sub.subsumers.keySet()) {
                        if (!subsub.original || sub.equivalence.contains(subsub) || role.equivalence.contains(subsub) || !subsub.subsumers.containsKey(role)) continue;
                        toadd = false;
                        break;
                    }
                    if (!toadd) continue;
                    subsumees.addAll(sub.equivalence);
                }
            } else {
                for (Role sub : this.elcontology.roles.values()) {
                    if (!sub.subsumers.containsKey(role)) continue;
                    subsumees.add(sub);
                }
            }
            while (subsumees.size() > 0) {
                Role sub;
                sub = (Role)subsumees.iterator().next();
                subsumees.removeAll(sub.equivalence);
                OWLObjectPropertyNode descendant = new OWLObjectPropertyNode();
                for (Role eq : sub.equivalence) {
                    if (!eq.original) continue;
                    descendant.add((OWLObject)this.factory.getOWLObjectProperty(eq.uri));
                }
                if (descendant.getSize() <= 0) continue;
                descendants.addNode((Node)descendant);
            }
        }
        return descendants;
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet descendants;
        block7: {
            descendants = new OWLDataPropertyNodeSet();
            Role role = this.getRole((OWLDataPropertyExpression)arg0);
            if (role == null) break block7;
            HashSet<Role> subsumees = new HashSet<Role>();
            if (arg1) {
                for (Role sub : this.elcontology.roles.values()) {
                    if (role.equivalence.contains(sub) || subsumees.contains(sub) || !sub.subsumers.containsKey(role)) continue;
                    boolean toadd = true;
                    for (Role subsub : sub.subsumers.keySet()) {
                        if (!subsub.original || sub.equivalence.contains(subsub) || role.equivalence.contains(subsub) || !subsub.subsumers.containsKey(role)) continue;
                        toadd = false;
                        break;
                    }
                    if (!toadd) continue;
                    subsumees.addAll(sub.equivalence);
                }
            } else {
                for (Role sub : this.elcontology.roles.values()) {
                    if (!sub.subsumers.containsKey(role)) continue;
                    subsumees.add(sub);
                }
            }
            while (subsumees.size() > 0) {
                Role sub;
                sub = (Role)subsumees.iterator().next();
                subsumees.removeAll(sub.equivalence);
                OWLDataPropertyNode descendant = new OWLDataPropertyNode();
                for (Role eq : sub.equivalence) {
                    if (!eq.original) continue;
                    descendant.add((OWLObject)this.factory.getOWLDataProperty(eq.uri));
                }
                if (descendant.getSize() <= 0) continue;
                descendants.addNode((Node)descendant);
            }
        }
        return descendants;
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet ancestors;
        block7: {
            ancestors = new OWLObjectPropertyNodeSet();
            Role role = this.getRole(arg0);
            if (role == null) break block7;
            HashSet<Role> subsumers = new HashSet<Role>();
            if (arg1) {
                for (Role sub : role.subsumers.keySet()) {
                    if (!sub.original || role.equivalence.contains(sub) || subsumers.contains(sub)) continue;
                    boolean toadd = true;
                    for (Role sub2 : role.subsumers.keySet()) {
                        if (!sub2.original || role.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.containsKey(sub)) continue;
                        toadd = false;
                        break;
                    }
                    if (!toadd) continue;
                    subsumers.addAll(sub.equivalence);
                }
            } else {
                for (Role sub : role.subsumers.keySet()) {
                    subsumers.add(sub);
                }
            }
            while (subsumers.size() > 0) {
                Role sub;
                sub = (Role)subsumers.iterator().next();
                subsumers.removeAll(sub.equivalence);
                OWLObjectPropertyNode ancestor = new OWLObjectPropertyNode();
                for (Role eq : sub.equivalence) {
                    if (!eq.original) continue;
                    ancestor.add((OWLObject)this.factory.getOWLObjectProperty(eq.uri));
                }
                if (ancestor.getSize() <= 0) continue;
                ancestors.addNode((Node)ancestor);
            }
        }
        return ancestors;
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet ancestors;
        block7: {
            ancestors = new OWLDataPropertyNodeSet();
            Role role = this.getRole((OWLDataPropertyExpression)arg0);
            if (role == null) break block7;
            HashSet<Role> subsumers = new HashSet<Role>();
            if (arg1) {
                for (Role sub : role.subsumers.keySet()) {
                    if (!sub.original || role.equivalence.contains(sub) || subsumers.contains(sub)) continue;
                    boolean toadd = true;
                    for (Role sub2 : role.subsumers.keySet()) {
                        if (!sub2.original || role.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.containsKey(sub)) continue;
                        toadd = false;
                        break;
                    }
                    if (!toadd) continue;
                    subsumers.addAll(sub.equivalence);
                }
            } else {
                for (Role sub : role.subsumers.keySet()) {
                    subsumers.add(sub);
                }
            }
            while (subsumers.size() > 0) {
                Role sub;
                sub = (Role)subsumers.iterator().next();
                subsumers.removeAll(sub.equivalence);
                OWLDataPropertyNode ancestor = new OWLDataPropertyNode();
                for (Role eq : sub.equivalence) {
                    if (!eq.original) continue;
                    ancestor.add((OWLObject)this.factory.getOWLDataProperty(eq.uri));
                }
                if (ancestor.getSize() <= 0) continue;
                ancestors.addNode((Node)ancestor);
            }
        }
        return ancestors;
    }

    public void dispose() {
        this.manager.removeOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public void flush() {
        try {
            this.add(this.toadd);
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
        this.clean(this.toremove);
        this.toadd = new HashSet<OWLAxiom>();
        this.toremove = new HashSet<OWLAxiom>();
        this.reclassify();
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.factory.getOWLNothing());
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return new OWLDataPropertyNode();
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return new OWLObjectPropertyNode();
    }

    public BufferingMode getBufferingMode() {
        return null;
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression arg0) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        return new OWLClassNodeSet();
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return null;
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return null;
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return this.toadd;
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return this.toremove;
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return this.changes;
    }

    public String getReasonerName() {
        return "REL";
    }

    public Version getReasonerVersion() {
        return this.version;
    }

    public long getTimeOut() {
        return 0L;
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.factory.getOWLThing());
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return new OWLDataPropertyNode();
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return new OWLObjectPropertyNode();
    }

    public void interrupt() {
    }

    public boolean isEntailed(OWLAxiom arg0) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        if (arg0 instanceof OWLSubClassOfAxiom) {
            return this.entail((OWLSubClassOfAxiom)arg0);
        }
        throw new UnsupportedEntailmentTypeException(arg0);
    }

    public boolean isEntailed(Set<? extends OWLAxiom> arg0) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        for (OWLAxiom oWLAxiom : arg0) {
            if (this.isEntailed(oWLAxiom)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> arg0) {
        return false;
    }

    public Individual getIndividual(OWLIndividual indi) {
        return null;
    }

    public NodeSet<OWLNamedIndividual> getIndividuals(OWLClassExpression concept) {
        OWLNamedIndividualNodeSet individuals = new OWLNamedIndividualNodeSet();
        System.out.println("This configuration does not support individual.");
        return individuals;
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual arg0, OWLObjectPropertyExpression arg1) {
        OWLNamedIndividualNodeSet toreturn = new OWLNamedIndividualNodeSet();
        System.out.println("This configuration does not support individual.");
        return toreturn;
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual arg0, boolean arg1) {
        OWLClassNodeSet types = new OWLClassNodeSet();
        System.out.println("This configuration does not support individual.");
        return types;
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Role role = this.getRole(arg0);
        if (role != null) {
            OWLObjectPropertyNode inverse = new OWLObjectPropertyNode();
            for (Role invrole : role.inverse.equivalence) {
                if (!invrole.original) continue;
                inverse.add((OWLObject)this.factory.getOWLObjectProperty(invrole.uri));
            }
            return inverse;
        }
        return new OWLObjectPropertyNode();
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLNamedIndividualNodeSet indis = new OWLNamedIndividualNodeSet();
        System.out.println("This configuration does not support individual.");
        return indis;
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet props = new OWLDataPropertyNodeSet();
        Role role = this.getRole(arg0);
        if (role != null) {
            for (Role diff : role.disjoints) {
                OWLDataPropertyNode node = new OWLDataPropertyNode();
                for (Role equa : diff.equivalence) {
                    if (!equa.original) continue;
                    node.add((OWLObject)this.factory.getOWLDataProperty(equa.uri));
                }
                if (node.getSize() <= 0) continue;
                props.addNode((Node)node);
            }
        }
        return props;
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet props = new OWLObjectPropertyNodeSet();
        Role role = this.getRole(arg0);
        if (role != null) {
            for (Role diff : role.disjoints) {
                OWLObjectPropertyNode node = new OWLObjectPropertyNode();
                for (Role equa : diff.equivalence) {
                    if (!equa.original) continue;
                    node.add((OWLObject)this.factory.getOWLObjectProperty(equa.uri));
                }
                if (node.getSize() <= 0) continue;
                props.addNode((Node)node);
            }
        }
        return props;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLNamedIndividualNode node = new OWLNamedIndividualNode();
        Individual indi = this.getIndividual((OWLIndividual)arg0);
        if (indi != null) {
            for (Individual equa : indi.sameIndividuals.keySet()) {
                if (!equa.original) continue;
                node.add((OWLObject)this.factory.getOWLNamedIndividual(equa.uri));
            }
        }
        return node;
    }

    public boolean entail(OWLSubClassOfAxiom axiom) {
        Description sub = this.getDescription(axiom.getSubClass());
        Description sup = this.getDescription(axiom.getSuperClass());
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        boolean answer = false;
        if (sub != null && sup != null && sub instanceof Basic && sup instanceof Basic) {
            Basic bsub = (Basic)sub;
            Basic bsup = (Basic)sup;
            answer = bsub.subsumers.containsKey(bsup) || bsub.subsumers.containsKey(bot);
        }
        return answer;
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        System.out.println("REL does not support precomputation yet.");
        return null;
    }

    public boolean isPrecomputed(InferenceType arg0) {
        System.out.println("REL does not support precomputation yet.");
        return false;
    }

    public void precomputeInferences(InferenceType ... arg0) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        System.out.println("REL does not support precomputation yet.");
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> arg0) throws OWLException {
        for (OWLOntologyChange oWLOntologyChange : arg0) {
            if (!oWLOntologyChange.getOntology().equals(this.ontology)) continue;
            this.changes.add(oWLOntologyChange);
            if (oWLOntologyChange instanceof AddAxiom) {
                this.toadd.add(oWLOntologyChange.getAxiom());
                continue;
            }
            this.toremove.add(oWLOntologyChange.getAxiom());
        }
        if (!this.bufferred && this.changes.size() > 0) {
            this.flush();
        }
    }

    public void clean(OWLOntology onto) {
        this.clean(onto.getAxioms());
    }

    public void clean(Set<OWLAxiom> axioms) {
        this.elcontology.classified = false;
        this.elcontology.consistency = true;
        for (Description description : this.elcontology.descriptions.values()) {
            HashSet<QueueEntry> toremove = new HashSet<QueueEntry>();
            block1: for (Map.Entry<QueueEntry, Traceability> entry : description.Ohat.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    toremove.add(entry.getKey());
                    continue block1;
                }
            }
            for (QueueEntry queueEntry : toremove) {
                description.Ohat.remove(queueEntry);
            }
            if (!(description instanceof Basic)) continue;
            Basic basic = (Basic)description;
            HashSet desp = new HashSet();
            block4: for (Map.Entry<Description, Traceability> entry : basic.queue.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    desp.add(entry.getKey());
                    continue block4;
                }
            }
            Iterator iterator = desp.iterator();
            while (iterator.hasNext()) {
                Description description2 = (Description)iterator.next();
                basic.queue.remove(description2);
            }
            HashSet<Basic> hashSet = new HashSet<Basic>();
            block7: for (Map.Entry<Basic, Traceability> entry : basic.subsumers.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    hashSet.add(entry.getKey());
                    continue block7;
                }
            }
            for (Basic basic2 : hashSet) {
                basic.subsumers.remove(basic2);
                basic.equivalence.remove(basic2);
                basic2.equivalence.remove(basic);
            }
            HashSet<RoleConcept> hashSet2 = new HashSet<RoleConcept>();
            block10: for (RoleConcept roleConcept : basic.LeftConnection) {
                Role role = roleConcept.role;
                Basic concept = roleConcept.concept;
                Traceability trace = role.Relations.get(concept).get(basic);
                if (trace == null) continue;
                for (OWLLogicalAxiom axiom5 : trace.getAxioms()) {
                    if (!axioms.contains(axiom5)) continue;
                    hashSet2.add(roleConcept);
                    continue block10;
                }
            }
            for (RoleConcept roleConcept : hashSet2) {
                basic.LeftConnection.remove(roleConcept);
            }
        }
        for (Role role : this.elcontology.roles.values()) {
            HashMap relations = new HashMap();
            for (Map.Entry<Basic, HashMap<Basic, Traceability>> entry : role.Relations.entrySet()) {
                HashSet<Basic> hashSet = new HashSet<Basic>();
                block15: for (Map.Entry<Basic, Traceability> entry2 : entry.getValue().entrySet()) {
                    if (entry2.getValue() == null) continue;
                    for (OWLLogicalAxiom oWLLogicalAxiom : entry2.getValue().getAxioms()) {
                        if (!axioms.contains(oWLLogicalAxiom)) continue;
                        hashSet.add(entry2.getKey());
                        continue block15;
                    }
                }
                if (hashSet.size() <= 0) continue;
                relations.put(entry.getKey(), hashSet);
            }
            for (Map.Entry entry : relations.entrySet()) {
                for (Basic basic : (HashSet)entry.getValue()) {
                    role.Relations.get(entry.getKey()).remove(basic);
                }
                if (role.Relations.get(entry.getKey()).size() != 0) continue;
                role.Relations.remove(entry.getKey());
            }
            HashSet<Role> hashSet = new HashSet<Role>();
            block19: for (Map.Entry<Role, Traceability> entry : role.subsumers.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    hashSet.add(entry.getKey());
                    continue block19;
                }
            }
            for (Role subsumer : hashSet) {
                role.subsumers.remove(subsumer);
                role.equivalence.remove(subsumer);
                subsumer.equivalence.remove(role);
            }
            HashMap compositions = new HashMap();
            for (Map.Entry<Role, HashMap<Role, Traceability>> entry : role.RightComposition.entrySet()) {
                HashSet<Role> hashSet3 = new HashSet<Role>();
                block23: for (Map.Entry entry3 : entry.getValue().entrySet()) {
                    if (entry3.getValue() == null) continue;
                    for (OWLLogicalAxiom axiom : ((Traceability)entry3.getValue()).getAxioms()) {
                        if (!axioms.contains(axiom)) continue;
                        hashSet3.add((Role)entry3.getKey());
                        continue block23;
                    }
                }
                if (hashSet3.size() <= 0) continue;
                compositions.put(entry.getKey(), hashSet3);
            }
            for (Map.Entry entry : compositions.entrySet()) {
                for (Role role2 : (HashSet)entry.getValue()) {
                    role.RightComposition.get(entry.getKey()).remove(role2);
                }
                if (role.RightComposition.get(entry.getKey()).size() != 0) continue;
                role.RightComposition.remove(entry.getKey());
            }
        }
    }

    public void add(OWLOntology toAdd) {
        this.elcfactory.add(toAdd);
    }

    public void add(Set<OWLAxiom> toAdd) throws OWLOntologyCreationException {
        this.elcfactory.add(toAdd);
    }

    public AxiomPool justify(OWLClass sub, OWLClass sup) {
        Description des2;
        AxiomPool justification = null;
        Description des1 = this.getDescription((OWLClassExpression)sub);
        if (des1 != null && des1 instanceof Basic && (des2 = this.getDescription((OWLClassExpression)sup)) != null && des2 instanceof Basic) {
            Basic bsc1 = (Basic)des1;
            Basic bsc2 = (Basic)des2;
            if (bsc1.subsumers.get(bsc2) != null) {
                justification = new AxiomPool(bsc1.subsumers.get(bsc2).getAxioms(), 0);
            }
        }
        return justification;
    }

    public AxiomPool justify(OWLIndividual indi, OWLClass cls) {
        Basic basic;
        Description desc;
        AxiomPool justification = null;
        Individual ind = this.getIndividual(indi);
        if (ind != null && (desc = this.getDescription((OWLClassExpression)cls)) != null && desc instanceof Basic && ind.classifications.get(basic = (Basic)desc) != null) {
            justification = new AxiomPool(ind.classifications.get(basic).getAxioms(), 0);
        }
        return justification;
    }

    public AxiomPool justify(OWLIndividual indi1, OWLObjectPropertyExpression prop, OWLIndividual indi2) {
        Role role;
        Individual ind2;
        AxiomPool justification = null;
        Individual ind1 = this.getIndividual(indi1);
        if (ind1 != null && (ind2 = this.getIndividual(indi2)) != null && (role = this.getRole(prop)) != null && ind1.relations.get(role).get(ind2) != null) {
            justification = new AxiomPool(ind1.relations.get(role).get(ind2).getAxioms(), 0);
        }
        return justification;
    }
}

