/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.tms.reasoner.dl;

import eu.trowl.owlapi3.rel.tms.classify.dl.NFClassifier;
import eu.trowl.owlapi3.rel.tms.factory.dl.OntologyFactory;
import eu.trowl.owlapi3.rel.tms.model.Atomic;
import eu.trowl.owlapi3.rel.tms.model.AxiomPool;
import eu.trowl.owlapi3.rel.tms.model.Basic;
import eu.trowl.owlapi3.rel.tms.model.Description;
import eu.trowl.owlapi3.rel.tms.model.Individual;
import eu.trowl.owlapi3.rel.tms.model.QueueEntry;
import eu.trowl.owlapi3.rel.tms.model.Role;
import eu.trowl.owlapi3.rel.tms.model.RoleConcept;
import eu.trowl.owlapi3.rel.tms.model.Traceability;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;

public class RELReasoner
extends eu.trowl.owlapi3.rel.tms.reasoner.el.RELReasoner
implements OWLOntologyChangeListener {
    public RELReasoner(OWLOntologyManager manager, OWLOntology ontology) {
        this(manager, ontology, false);
    }

    public RELReasoner(OWLOntologyManager manager, OWLOntology ontology, boolean NF) {
        super(manager, ontology, NF);
    }

    @Override
    protected void initialiseClassifier() {
        this.classifier = new NFClassifier();
    }

    @Override
    public void loadOntology() {
        this.elcfactory = new OntologyFactory(this.ontology, this.nominalfree);
        this.elcfactory.createbuilder();
        this.elcontology = this.elcfactory.createELOntology();
    }

    @Override
    public void loadOntology(String output) throws OWLOntologyCreationException, UnknownOWLOntologyException, OWLOntologyChangeException, OWLOntologyStorageException {
        this.elcfactory = new OntologyFactory(this.ontology, this.nominalfree);
        this.elcfactory.createbuilder();
        this.elcontology = this.elcfactory.createELOntology(output);
    }

    @Override
    public Individual getIndividual(OWLIndividual indi) {
        if (this.elcontology.individualID.get(indi) != null) {
            return this.elcontology.individuals.get(this.elcontology.individualID.get(indi));
        }
        return null;
    }

    @Override
    public NodeSet<OWLNamedIndividual> getIndividuals(OWLClassExpression concept) {
        OWLNamedIndividualNodeSet individuals = new OWLNamedIndividualNodeSet();
        HashSet<Individual> indis = new HashSet<Individual>();
        if (this.elcontology.classID.get(concept) == null) {
            System.out.println("This configuration does not support instance retrieval for this expression. Emplty set is returned.");
            return individuals;
        }
        if (!(this.elcontology.descriptions.get(this.elcontology.classID.get(concept)) instanceof Atomic)) {
            System.out.println("This configuration does not support instance retrieval for this expression. Emplty set is returned.");
            return individuals;
        }
        Atomic elpconcept = (Atomic)this.elcontology.descriptions.get(this.elcontology.classID.get(concept));
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        for (Individual indi : this.elcontology.individuals.values()) {
            if (!indi.classifications.containsKey(bot) && !indi.classifications.containsKey(elpconcept)) continue;
            indis.add(indi);
        }
        while (indis.size() > 0) {
            Individual head = (Individual)indis.iterator().next();
            indis.removeAll(head.sameIndividuals.keySet());
            OWLNamedIndividualNode node = new OWLNamedIndividualNode();
            for (Individual same : head.sameIndividuals.keySet()) {
                node.add((OWLObject)this.factory.getOWLNamedIndividual(same.uri));
            }
            individuals.addNode((Node)node);
        }
        return individuals;
    }

    @Override
    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual arg0, OWLObjectPropertyExpression arg1) {
        OWLNamedIndividualNodeSet toreturn = new OWLNamedIndividualNodeSet();
        Individual indi = this.getIndividual((OWLIndividual)arg0);
        Role role = this.getRole(arg1);
        if (indi != null && role != null && indi.relations.get(role) != null) {
            HashSet<Individual> indi2s = new HashSet<Individual>(indi.relations.get(role).keySet());
            while (!indi2s.isEmpty()) {
                Individual indi2 = indi2s.iterator().next();
                OWLNamedIndividualNode node = new OWLNamedIndividualNode();
                for (Individual equa : indi2.sameIndividuals.keySet()) {
                    if (!equa.original) continue;
                    node.add((OWLObject)this.factory.getOWLNamedIndividual(equa.uri));
                }
                if (node.getSize() > 0) {
                    toreturn.addNode((Node)node);
                }
                indi2s.removeAll(indi2.sameIndividuals.keySet());
            }
        }
        return toreturn;
    }

    @Override
    public NodeSet<OWLClass> getTypes(OWLNamedIndividual arg0, boolean arg1) {
        OWLClassNodeSet types = new OWLClassNodeSet();
        Individual indi = this.getIndividual((OWLIndividual)arg0);
        if (indi == null) {
            return types;
        }
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        HashSet<Object> classes = new HashSet();
        if (indi.classifications.containsKey(bot)) {
            classes = this.elcontology.allconcepts;
        } else {
            for (Basic cls : indi.classifications.keySet()) {
                if (!(cls instanceof Atomic) || !cls.original) continue;
                classes.add(cls);
            }
        }
        if (arg1) {
            HashSet<Object> toremove = new HashSet<Object>(classes);
            for (Basic basic : toremove) {
                for (Basic basic2 : toremove) {
                    if (!basic.subsumers.containsKey(basic2) || basic.equivalence.contains(basic2)) continue;
                    classes.removeAll(basic2.equivalence);
                }
            }
        }
        while (classes.size() > 0) {
            Basic sub = (Basic)classes.iterator().next();
            classes.removeAll(sub.equivalence);
            OWLClassNode oWLClassNode = new OWLClassNode();
            for (Basic eq : sub.equivalence) {
                if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                oWLClassNode.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
            }
            if (oWLClassNode.getSize() <= 0) continue;
            types.addNode((Node)oWLClassNode);
        }
        return types;
    }

    @Override
    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLNamedIndividualNodeSet indis = new OWLNamedIndividualNodeSet();
        Individual indi = this.getIndividual((OWLIndividual)arg0);
        if (indi != null) {
            for (Individual diff : indi.differentIndividuals.keySet()) {
                OWLNamedIndividualNode node = new OWLNamedIndividualNode();
                for (Individual equa : diff.sameIndividuals.keySet()) {
                    if (!equa.original) continue;
                    node.add((OWLObject)this.factory.getOWLNamedIndividual(equa.uri));
                }
                if (node.getSize() <= 0) continue;
                indis.addNode((Node)node);
            }
        }
        return indis;
    }

    @Override
    public boolean isEntailed(OWLAxiom arg0) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        if (arg0 instanceof OWLSubClassOfAxiom) {
            return this.entail((OWLSubClassOfAxiom)arg0);
        }
        if (arg0 instanceof OWLClassAssertionAxiom) {
            return this.entail((OWLClassAssertionAxiom)arg0);
        }
        if (arg0 instanceof OWLObjectPropertyAssertionAxiom) {
            return this.entail((OWLObjectPropertyAssertionAxiom)arg0);
        }
        throw new UnsupportedEntailmentTypeException(arg0);
    }

    @Override
    public boolean entail(OWLSubClassOfAxiom axiom) {
        Description sub = this.getDescription(axiom.getSubClass());
        Description sup = this.getDescription(axiom.getSuperClass());
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        boolean answer = false;
        if (sub != null && sup != null && sub instanceof Basic && sup instanceof Basic) {
            Basic bsub = (Basic)sub;
            Basic bsup = (Basic)sup;
            answer = bsub.subsumers.containsKey(bsup) || bsub.subsumers.containsKey(bot);
        }
        return answer;
    }

    public boolean entail(OWLClassAssertionAxiom axiom) {
        Individual indi = this.getIndividual(axiom.getIndividual());
        Description desc = this.getDescription(axiom.getClassExpression());
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        boolean answer = false;
        if (desc.equals(bot)) {
            System.out.println("OWL:Nothing can not have any instance, return false");
            return answer;
        }
        if (indi != null && desc != null && desc instanceof Basic) {
            Basic bdesc = (Basic)desc;
            answer = indi.classifications.containsKey(bdesc);
        }
        return answer;
    }

    public boolean entail(OWLObjectPropertyAssertionAxiom axiom) {
        Individual sub = this.getIndividual(axiom.getSubject());
        Individual obj = this.getIndividual((OWLIndividual)axiom.getObject());
        Role role = this.getRole((OWLObjectPropertyExpression)axiom.getProperty());
        boolean answer = false;
        if (sub != null && obj != null && role != null) {
            answer = sub.relations.containsKey(role) && sub.relations.get(role).containsKey(obj);
        }
        return answer;
    }

    @Override
    public void clean(Set<OWLAxiom> axioms) {
        this.elcontology.classified = false;
        this.elcontology.consistency = true;
        for (Description description : this.elcontology.descriptions.values()) {
            HashSet<QueueEntry> toremove = new HashSet<QueueEntry>();
            block1: for (Map.Entry<QueueEntry, Traceability> entry : description.Ohat.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    toremove.add(entry.getKey());
                    continue block1;
                }
            }
            for (QueueEntry queueEntry : toremove) {
                description.Ohat.remove(queueEntry);
            }
            if (!(description instanceof Basic)) continue;
            Basic basic = (Basic)description;
            HashSet<Description> hashSet = new HashSet<Description>();
            block4: for (Map.Entry<Description, Traceability> entry : basic.queue.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    hashSet.add(entry.getKey());
                    continue block4;
                }
            }
            for (Description description2 : hashSet) {
                basic.queue.remove(description2);
            }
            HashSet<Basic> hashSet2 = new HashSet<Basic>();
            block7: for (Map.Entry<Basic, Traceability> entry : basic.subsumers.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    hashSet2.add(entry.getKey());
                    continue block7;
                }
            }
            for (Basic basic2 : hashSet2) {
                basic.subsumers.remove(basic2);
                basic.equivalence.remove(basic2);
                basic2.equivalence.remove(basic);
            }
            HashSet<RoleConcept> hashSet3 = new HashSet<RoleConcept>();
            block10: for (RoleConcept roleConcept : basic.LeftConnection) {
                Role role = roleConcept.role;
                Basic basic3 = roleConcept.concept;
                Traceability trace = role.Relations.get(basic3).get(basic);
                if (trace == null) continue;
                for (OWLLogicalAxiom axiom5 : trace.getAxioms()) {
                    if (!axioms.contains(axiom5)) continue;
                    hashSet3.add(roleConcept);
                    continue block10;
                }
            }
            for (RoleConcept roleConcept : hashSet3) {
                basic.LeftConnection.remove(roleConcept);
            }
        }
        for (Role role : this.elcontology.roles.values()) {
            HashMap relations = new HashMap();
            for (Map.Entry<Basic, HashMap<Basic, Traceability>> entry : role.Relations.entrySet()) {
                HashSet<Basic> hashSet = new HashSet<Basic>();
                block15: for (Map.Entry<Basic, Traceability> entry2 : entry.getValue().entrySet()) {
                    if (entry2.getValue() == null) continue;
                    for (OWLLogicalAxiom oWLLogicalAxiom : entry2.getValue().getAxioms()) {
                        if (!axioms.contains(oWLLogicalAxiom)) continue;
                        hashSet.add(entry2.getKey());
                        continue block15;
                    }
                }
                if (hashSet.size() <= 0) continue;
                relations.put(entry.getKey(), hashSet);
            }
            for (Map.Entry entry : relations.entrySet()) {
                for (Basic basic : (HashSet)entry.getValue()) {
                    role.Relations.get(entry.getKey()).remove(basic);
                }
                if (role.Relations.get(entry.getKey()).size() != 0) continue;
                role.Relations.remove(entry.getKey());
            }
            HashSet<Role> hashSet = new HashSet<Role>();
            block19: for (Map.Entry<Role, Traceability> entry : role.subsumers.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    hashSet.add(entry.getKey());
                    continue block19;
                }
            }
            for (Role role2 : hashSet) {
                role.subsumers.remove(role2);
                role.equivalence.remove(role2);
                role2.equivalence.remove(role);
            }
            HashMap hashMap = new HashMap();
            for (Map.Entry<Role, HashMap<Role, Traceability>> entry : role.RightComposition.entrySet()) {
                HashSet<Role> hashSet4 = new HashSet<Role>();
                block23: for (Map.Entry<Role, Traceability> entry3 : entry.getValue().entrySet()) {
                    if (entry3.getValue() == null) continue;
                    for (OWLLogicalAxiom oWLLogicalAxiom : entry3.getValue().getAxioms()) {
                        if (!axioms.contains(oWLLogicalAxiom)) continue;
                        hashSet4.add(entry3.getKey());
                        continue block23;
                    }
                }
                if (hashSet4.size() <= 0) continue;
                hashMap.put(entry.getKey(), hashSet4);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                for (Role role3 : (HashSet)entry.getValue()) {
                    role.RightComposition.get(entry.getKey()).remove(role3);
                }
                if (role.RightComposition.get(entry.getKey()).size() != 0) continue;
                role.RightComposition.remove(entry.getKey());
            }
        }
        for (Individual indi : this.elcontology.individuals.values()) {
            HashSet<Description> desp = new HashSet<Description>();
            block28: for (Map.Entry<Description, Traceability> entry : indi.queue.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    desp.add(entry.getKey());
                    continue block28;
                }
            }
            for (Description description : desp) {
                indi.queue.remove(description);
            }
            HashSet<Basic> hashSet = new HashSet<Basic>();
            block31: for (Map.Entry<Basic, Traceability> entry : indi.classifications.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    hashSet.add(entry.getKey());
                    continue block31;
                }
            }
            for (Basic basic : hashSet) {
                indi.classifications.remove(basic);
            }
            HashSet<Basic> hashSet5 = new HashSet<Basic>();
            block34: for (Map.Entry<Basic, Traceability> entry : indi.origCls.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    hashSet5.add(entry.getKey());
                    continue block34;
                }
            }
            for (Basic basic : hashSet5) {
                indi.origCls.remove(basic);
            }
            HashMap hashMap = new HashMap();
            for (Map.Entry<Role, HashMap<Individual, Traceability>> entry : indi.relations.entrySet()) {
                HashSet<Individual> hashSet6 = new HashSet<Individual>();
                block38: for (Map.Entry<Individual, Traceability> entry4 : entry.getValue().entrySet()) {
                    if (entry4.getValue() == null) continue;
                    for (OWLLogicalAxiom axiom8 : entry4.getValue().getAxioms()) {
                        if (!axioms.contains(axiom8)) continue;
                        hashSet6.add(entry4.getKey());
                        continue block38;
                    }
                }
                if (hashSet6.size() == 0) continue;
                hashMap.put(entry.getKey(), hashSet6);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                for (Individual individual : (HashSet)entry.getValue()) {
                    indi.relations.get(entry.getKey()).remove(individual);
                }
                if (indi.relations.get(entry.getKey()).size() != 0) continue;
                indi.relations.remove(entry.getKey());
            }
            HashSet<Individual> hashSet7 = new HashSet<Individual>();
            block42: for (Map.Entry<Individual, Traceability> entry : indi.sameIndividuals.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    hashSet7.add(entry.getKey());
                    continue block42;
                }
            }
            for (Individual individual : hashSet7) {
                indi.sameIndividuals.remove(individual);
                individual.sameIndividuals.remove(indi);
            }
            HashSet<Individual> hashSet8 = new HashSet<Individual>();
            block45: for (Map.Entry<Individual, Traceability> entry : indi.differentIndividuals.entrySet()) {
                if (entry.getValue() == null) continue;
                for (OWLLogicalAxiom oWLLogicalAxiom : entry.getValue().getAxioms()) {
                    if (!axioms.contains(oWLLogicalAxiom)) continue;
                    hashSet8.add(entry.getKey());
                    continue block45;
                }
            }
            for (Individual individual : hashSet8) {
                indi.differentIndividuals.remove(individual);
                individual.differentIndividuals.remove(indi);
            }
        }
    }

    public ArrayList<AxiomPool> inconistencyJustification() {
        ArrayList<AxiomPool> justifications = new ArrayList<AxiomPool>();
        for (Traceability trace : this.elcontology.inconsistencyJust) {
            AxiomPool just = new AxiomPool(trace.getAxioms(), 0);
            justifications.add(just);
        }
        return justifications;
    }
}

