/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.tms.factory.el;

import eu.trowl.owlapi3.rel.tms.factory.el.OntologyBuilder;
import eu.trowl.owlapi3.rel.tms.model.Ontology;
import java.util.ArrayList;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;

public class OntologyFactory {
    protected final OWLOntologyManager manager;
    protected final Set<OWLOntology> ontologies;
    protected OntologyBuilder builder;
    protected Ontology elcontology;
    protected boolean nominalfree;

    public OntologyFactory(OWLOntology ontology, boolean nominalfree) {
        this.manager = ontology.getOWLOntologyManager();
        this.ontologies = ontology.getImportsClosure();
        this.nominalfree = true;
        this.elcontology = new Ontology();
    }

    public void createbuilder() {
        if (this.nominalfree) {
            this.builder = new OntologyBuilder(this.ontologies, this.manager, this.elcontology);
        } else {
            System.out.println("This configuration does not support nominal!");
        }
    }

    public Ontology createELOntology(String output) throws OWLOntologyCreationException, UnknownOWLOntologyException, OWLOntologyChangeException, OWLOntologyStorageException {
        this.builder.startOutput(output);
        this.elcontology = this.createELOntology();
        this.builder.endOutput();
        return this.elcontology;
    }

    public Ontology createELOntology() {
        ArrayList<OWLLogicalAxiom> RBox = new ArrayList<OWLLogicalAxiom>();
        ArrayList<OWLLogicalAxiom> TBox = new ArrayList<OWLLogicalAxiom>();
        ArrayList<OWLLogicalAxiom> ABox = new ArrayList<OWLLogicalAxiom>();
        for (OWLOntology ontology : this.ontologies) {
            for (OWLLogicalAxiom axiom : ontology.getLogicalAxioms()) {
                if (axiom instanceof OWLSubPropertyChainOfAxiom || axiom instanceof OWLInverseObjectPropertiesAxiom || axiom instanceof OWLFunctionalObjectPropertyAxiom || axiom instanceof OWLInverseFunctionalObjectPropertyAxiom || axiom instanceof OWLFunctionalDataPropertyAxiom) {
                    RBox.add(axiom);
                    continue;
                }
                if (axiom instanceof OWLClassAssertionAxiom || axiom instanceof OWLObjectPropertyAssertionAxiom) {
                    ABox.add(axiom);
                    continue;
                }
                TBox.add(axiom);
            }
        }
        for (OWLLogicalAxiom axiom : RBox) {
            axiom.accept((OWLAxiomVisitor)this.builder);
        }
        this.builder.createInverseRoles();
        for (OWLLogicalAxiom axiom : TBox) {
            axiom.accept((OWLAxiomVisitor)this.builder);
        }
        for (OWLLogicalAxiom axiom : ABox) {
            axiom.accept((OWLAxiomVisitor)this.builder);
        }
        this.builder.OrderingCardinality();
        this.elcontology = this.builder.getELOntology();
        return this.elcontology;
    }

    public void add(OWLOntology toAdd) {
        ArrayList<OWLLogicalAxiom> RBox = new ArrayList<OWLLogicalAxiom>();
        ArrayList<OWLLogicalAxiom> TBox = new ArrayList<OWLLogicalAxiom>();
        ArrayList<OWLLogicalAxiom> ABox = new ArrayList<OWLLogicalAxiom>();
        for (OWLLogicalAxiom axiom : toAdd.getLogicalAxioms()) {
            OWLObjectPropertyExpression exp2;
            OWLSubPropertyChainOfAxiom ax;
            if (axiom instanceof OWLSubPropertyChainOfAxiom) {
                ax = (OWLSubPropertyChainOfAxiom)axiom;
                for (OWLObjectPropertyExpression exp2 : ax.getPropertyChain()) {
                    if (this.elcontology.roleID.get(exp2.asOWLObjectProperty()) == null) continue;
                    this.elcontology.reRoles.add(this.elcontology.roles.get(this.elcontology.roleID.get(exp2.asOWLObjectProperty())));
                }
            }
            if (axiom instanceof OWLTransitiveObjectPropertyAxiom && this.elcontology.roleID.get((exp2 = (OWLObjectPropertyExpression)(ax = (OWLTransitiveObjectPropertyAxiom)axiom).getProperty()).asOWLObjectProperty()) != null) {
                this.elcontology.reRoles.add(this.elcontology.roles.get(this.elcontology.roleID.get(exp2.asOWLObjectProperty())));
            }
            if (axiom instanceof OWLSubPropertyChainOfAxiom || axiom instanceof OWLInverseObjectPropertiesAxiom || axiom instanceof OWLFunctionalObjectPropertyAxiom || axiom instanceof OWLInverseFunctionalObjectPropertyAxiom || axiom instanceof OWLFunctionalDataPropertyAxiom) {
                RBox.add(axiom);
                continue;
            }
            if (axiom instanceof OWLClassAssertionAxiom || axiom instanceof OWLObjectPropertyAssertionAxiom) {
                ABox.add(axiom);
                continue;
            }
            TBox.add(axiom);
        }
        this.builder.add(toAdd);
        for (OWLLogicalAxiom axiom : RBox) {
            axiom.accept((OWLAxiomVisitor)this.builder);
        }
        this.builder.createInverseRoles();
        for (OWLLogicalAxiom axiom : TBox) {
            axiom.accept((OWLAxiomVisitor)this.builder);
        }
        for (OWLLogicalAxiom axiom : ABox) {
            axiom.accept((OWLAxiomVisitor)this.builder);
        }
        this.builder.OrderingCardinality(toAdd);
    }

    public void add(Set<OWLAxiom> toAdd) throws OWLOntologyCreationException {
        if (toAdd.size() > 0) {
            OWLOntology tempO = this.manager.createOntology(toAdd);
            this.add(tempO);
            this.manager.removeOntology(tempO);
        }
    }
}

