/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.tms.factory.dl;

import eu.trowl.owlapi3.rel.tms.model.And;
import eu.trowl.owlapi3.rel.tms.model.Atomic;
import eu.trowl.owlapi3.rel.tms.model.Basic;
import eu.trowl.owlapi3.rel.tms.model.CardinAtomic;
import eu.trowl.owlapi3.rel.tms.model.CardinalityEntry;
import eu.trowl.owlapi3.rel.tms.model.Description;
import eu.trowl.owlapi3.rel.tms.model.Individual;
import eu.trowl.owlapi3.rel.tms.model.Ontology;
import eu.trowl.owlapi3.rel.tms.model.Role;
import eu.trowl.owlapi3.rel.tms.model.Some;
import eu.trowl.owlapi3.rel.tms.model.Traceability;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;

class OntologyBuilder
extends eu.trowl.owlapi3.rel.tms.factory.el.OntologyBuilder {
    protected HashMap<OWLIndividual, Integer> individualID;
    protected HashMap<Integer, Individual> individuals;
    protected int individualindex;

    public OntologyBuilder(Set<OWLOntology> ontologies, OWLOntologyManager manager, Ontology ELContology) {
        super(ontologies, manager, ELContology);
    }

    @Override
    protected void initialise(Set<OWLOntology> ontologies) {
        this.individualID = this.elcontology.individualID;
        this.individuals = this.elcontology.individuals;
        this.individualindex = 0;
        this.top.complement = this.bot;
        this.bot.complement = this.top;
        OWLClass thing = this.factory.getOWLThing();
        OWLClass nothing = this.factory.getOWLNothing();
        OWLClass namedindividual = this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2002/07/owl#NamedIndividual"));
        for (OWLOntology ontology : ontologies) {
            for (OWLClass concept : ontology.getClassesInSignature()) {
                if (concept.equals(thing) || concept.equals(nothing) || concept.equals(namedindividual)) continue;
                Atomic newconcept = new Atomic(concept);
                newconcept.id = newconcept.id;
                this.classID.put(concept, newconcept.id);
                this.descriptions.put(newconcept.id, newconcept);
                this.imply(newconcept);
                this.allconcepts.add(newconcept);
                Atomic nA = new Atomic();
                nA.id = ++this.classindex;
                nA.original = false;
                nA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex++));
                this.classID.put(this.factory.getOWLObjectComplementOf((OWLClassExpression)concept), nA.id);
                this.descriptions.put(nA.id, nA);
                this.imply(nA);
                newconcept.complement = nA;
                nA.complement = newconcept;
            }
        }
        for (OWLOntology ontology : ontologies) {
            for (OWLObjectProperty role : ontology.getObjectPropertiesInSignature()) {
                Role newrole = new Role(role, this.propertyindex++);
                this.propertyID.put(role, newrole.id);
                this.roles.put(newrole.id, newrole);
                Role inv = new Role(this.propertyindex);
                inv.original = false;
                inv.uri = IRI.create((String)("RELAPPROX#RELAPPROXR" + this.propertyindex++));
                this.propertyID.put(role.getInverseProperty(), inv.id);
                this.roles.put(inv.id, inv);
                newrole.inverse = inv;
                inv.inverse = newrole;
            }
        }
        for (OWLOntology ontology : ontologies) {
            for (OWLDataProperty drole : ontology.getDataPropertiesInSignature()) {
                OWLObjectProperty role = this.factory.getOWLObjectProperty(drole.getIRI());
                Role newrole = new Role(role, this.propertyindex++);
                newrole.original = false;
                this.propertyID.put(role, newrole.id);
                this.roles.put(newrole.id, newrole);
                Role inv = new Role(this.propertyindex);
                inv.original = false;
                inv.uri = IRI.create((String)("RELAPPROX#RELAPPROXR" + this.propertyindex++));
                this.propertyID.put(role.getInverseProperty(), inv.id);
                this.roles.put(inv.id, inv);
                newrole.inverse = inv;
                inv.inverse = newrole;
            }
        }
        for (OWLOntology ontology : ontologies) {
            for (OWLIndividual individual : ontology.getIndividualsInSignature()) {
                Individual newindividual = new Individual(individual);
                ++this.individualindex;
                newindividual.id = newindividual.id;
                this.individualID.put(individual, newindividual.id);
                this.individuals.put(newindividual.id, newindividual);
            }
        }
    }

    @Override
    public void add(OWLOntology ontology) {
        OWLClass thing = this.factory.getOWLThing();
        OWLClass nothing = this.factory.getOWLNothing();
        OWLClass namedindividual = this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2002/07/owl#NamedIndividual"));
        for (OWLClass concept : ontology.getClassesInSignature()) {
            if (concept.equals(thing) || concept.equals(nothing) || concept.equals(namedindividual) || this.classID.containsKey(concept)) continue;
            Atomic newconcept = new Atomic(concept);
            newconcept.id = newconcept.id;
            this.classID.put(concept, newconcept.id);
            this.descriptions.put(newconcept.id, newconcept);
            this.imply(newconcept);
            this.allconcepts.add(newconcept);
            Atomic nA = new Atomic();
            nA.id = ++this.classindex;
            nA.original = false;
            nA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex++));
            this.classID.put(this.factory.getOWLObjectComplementOf((OWLClassExpression)concept), nA.id);
            this.descriptions.put(nA.id, nA);
            this.imply(nA);
            newconcept.complement = nA;
            nA.complement = newconcept;
        }
        for (OWLObjectProperty role : ontology.getObjectPropertiesInSignature()) {
            if (this.propertyID.containsKey(role)) continue;
            Role newrole = new Role(role, this.propertyindex++);
            this.propertyID.put(role, newrole.id);
            this.roles.put(newrole.id, newrole);
            Role inv = new Role(this.propertyindex);
            inv.original = false;
            inv.uri = IRI.create((String)("RELAPPROX#RELAPPROXR" + this.propertyindex++));
            this.propertyID.put(role.getInverseProperty(), inv.id);
            this.roles.put(inv.id, inv);
            newrole.inverse = inv;
            inv.inverse = newrole;
        }
        for (OWLDataProperty drole : ontology.getDataPropertiesInSignature()) {
            OWLObjectProperty role = this.factory.getOWLObjectProperty(drole.getIRI());
            if (this.propertyID.containsKey(role)) continue;
            Role newrole = new Role(role, this.propertyindex++);
            newrole.original = false;
            this.propertyID.put(role, newrole.id);
            this.roles.put(newrole.id, newrole);
            Role inv = new Role(this.propertyindex);
            inv.original = false;
            inv.uri = IRI.create((String)("RELAPPROX#RELAPPROXR" + this.propertyindex++));
            this.propertyID.put(role.getInverseProperty(), inv.id);
            this.roles.put(inv.id, inv);
            newrole.inverse = inv;
            inv.inverse = newrole;
        }
        for (OWLIndividual individual : ontology.getIndividualsInSignature()) {
            if (this.individualID.containsKey(individual)) continue;
            Individual newindividual = new Individual(individual);
            ++this.individualindex;
            newindividual.id = newindividual.id;
            this.individualID.put(individual, newindividual.id);
            this.individuals.put(newindividual.id, newindividual);
        }
    }

    @Override
    public Ontology getELOntology() {
        return this.elcontology;
    }

    @Override
    protected Description getDescription(OWLClassExpression concept) {
        Description NC = null;
        if (this.classID.get(concept) != null) {
            NC = (Description)this.descriptions.get(this.classID.get(concept));
        } else if (concept instanceof OWLObjectComplementOf) {
            OWLObjectComplementOf comp = (OWLObjectComplementOf)concept;
            OWLClassExpression des = comp.getOperand();
            Basic nNCA = (Basic)this.getDescription(des);
            NC = nNCA.complement;
            if (NC == null) {
                Atomic NCA = new Atomic();
                NCA.id = this.classindex;
                NCA.original = false;
                NCA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex++));
                this.classID.put(concept, NCA.id);
                this.descriptions.put(NCA.id, NCA);
                this.imply(NCA);
                NCA.complement = nNCA;
                nNCA.complement = NCA;
                NC = NCA;
            }
        } else if (concept instanceof OWLObjectIntersectionOf) {
            OWLObjectIntersectionOf intersection = (OWLObjectIntersectionOf)concept;
            HashSet<Description> interapprox = new HashSet<Description>();
            for (OWLClassExpression des : intersection.getOperands()) {
                Description desapprox = this.getDescription(des);
                interapprox.add(desapprox);
            }
            NC = new And(interapprox);
            NC.id = this.nonbasicindex--;
            this.classID.put(concept, NC.id);
            this.descriptions.put(NC.id, NC);
        } else if (concept instanceof OWLObjectUnionOf) {
            OWLObjectUnionOf union = (OWLObjectUnionOf)concept;
            OWLClassExpression complement = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)union));
            Atomic NCA = new Atomic();
            NCA.id = this.classindex;
            NCA.original = false;
            NCA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex++));
            this.classID.put(concept, NCA.id);
            this.descriptions.put(NCA.id, NCA);
            this.imply(NCA);
            Atomic nNCA = new Atomic();
            nNCA.id = this.classindex;
            nNCA.original = false;
            nNCA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex++));
            Description complementapprox = this.getDescription(complement);
            this.classID.put(complement, nNCA.id);
            this.descriptions.put(nNCA.id, nNCA);
            this.imply(nNCA);
            NCA.complement = nNCA;
            nNCA.complement = NCA;
            this.normalise(nNCA, complementapprox, null);
            this.normalise(complementapprox, (Description)nNCA, null);
            NC = NCA;
        } else if (concept instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom some = (OWLObjectSomeValuesFrom)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)some.getProperty();
            Role role = this.getRole(property);
            Some someA = new Some(role, this.getDescription((OWLClassExpression)some.getFiller()));
            NC = someA;
            NC.id = this.nonbasicindex--;
            this.classID.put(concept, NC.id);
            this.descriptions.put(NC.id, NC);
        } else if (concept instanceof OWLObjectAllValuesFrom) {
            OWLObjectAllValuesFrom all = (OWLObjectAllValuesFrom)concept;
            OWLClassExpression complement = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)all));
            Atomic NCA = new Atomic();
            NCA.id = this.classindex;
            NCA.original = false;
            NCA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex++));
            this.classID.put(concept, NCA.id);
            this.descriptions.put(NCA.id, NCA);
            this.imply(NCA);
            Atomic nNCA = new Atomic();
            nNCA.id = this.classindex;
            nNCA.original = false;
            nNCA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex++));
            Some complementapprox = (Some)this.getDescription(complement);
            this.classID.put(complement, nNCA.id);
            this.descriptions.put(nNCA.id, nNCA);
            this.imply(nNCA);
            if (complementapprox.concept instanceof Basic) {
                complementapprox.role.somes.put((Basic)complementapprox.concept, complementapprox);
            }
            NCA.complement = nNCA;
            nNCA.complement = NCA;
            this.normalise(nNCA, (Description)complementapprox, null);
            this.normalise(complementapprox, (Description)nNCA, null);
            NC = NCA;
        } else if (concept instanceof OWLObjectMinCardinality) {
            Atomic newfiller;
            Atomic fillerA;
            OWLObjectMinCardinality min = (OWLObjectMinCardinality)concept;
            int n = min.getCardinality();
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)min.getProperty();
            Role role = this.getRole(property);
            OWLClassExpression filler = (OWLClassExpression)min.getFiller();
            Description fillerapprox = this.getDescription(filler);
            if (!(fillerapprox instanceof Atomic)) {
                OWLClassExpression nfiller = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(filler));
                Atomic nfillerapporx = (Atomic)this.getDescription(nfiller);
                fillerapprox = nfillerapporx.complement;
            }
            if (this.CardinalityTable.get(fillerA = (Atomic)fillerapprox) == null) {
                HashMap<Integer, Atomic> fillerapproxentry = new HashMap<Integer, Atomic>();
                fillerapproxentry.put(1, fillerA);
                this.CardinalityTable.put(fillerA, fillerapproxentry);
            }
            if ((newfiller = (Atomic)((HashMap)this.CardinalityTable.get(fillerA)).get(n)) == null) {
                String newuri = String.valueOf(fillerA.uri.toString()) + "RELAPPROXQ" + n;
                CardinAtomic newcardinfiller = new CardinAtomic();
                newcardinfiller.id = this.classindex++;
                newcardinfiller.uri = IRI.create((String)newuri);
                newcardinfiller.original = false;
                newcardinfiller.value = fillerA;
                newcardinfiller.cardin = n;
                newfiller = newcardinfiller;
                ((HashMap)this.CardinalityTable.get(fillerA)).put(n, newfiller);
                this.descriptions.put(newfiller.id, newfiller);
                this.imply(newfiller);
            }
            NC = new Some(role, newfiller);
            NC.id = this.nonbasicindex--;
            this.classID.put(concept, NC.id);
            this.descriptions.put(NC.id, NC);
        } else if (concept instanceof OWLObjectMaxCardinality) {
            OWLObjectMaxCardinality max = (OWLObjectMaxCardinality)concept;
            OWLClassExpression complement = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)max));
            Atomic NCA = new Atomic();
            NCA.id = this.classindex;
            NCA.original = false;
            NCA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex++));
            this.classID.put(concept, NCA.id);
            this.descriptions.put(NCA.id, NCA);
            this.imply(NCA);
            Atomic nNCA = new Atomic();
            nNCA.id = this.classindex;
            nNCA.original = false;
            nNCA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex++));
            Some complementapprox = (Some)this.getDescription(complement);
            this.classID.put(complement, nNCA.id);
            this.descriptions.put(nNCA.id, nNCA);
            this.imply(nNCA);
            if (complementapprox.concept instanceof Basic) {
                complementapprox.role.somes.put((Basic)complementapprox.concept, complementapprox);
            }
            NCA.complement = nNCA;
            nNCA.complement = NCA;
            this.normalise(nNCA, (Description)complementapprox, null);
            this.normalise(complementapprox, (Description)nNCA, null);
            NC = NCA;
        } else {
            Atomic NCA = new Atomic();
            NCA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex));
            NCA.id = this.classindex++;
            NCA.original = false;
            this.classID.put(concept, NCA.id);
            this.descriptions.put(NCA.id, NCA);
            this.imply(NCA);
            NC = NCA;
        }
        if (NC instanceof Basic) {
            Basic ANC = (Basic)NC;
            if (ANC.complement == null) {
                Atomic nNCA = new Atomic();
                nNCA.id = this.classindex;
                nNCA.original = false;
                nNCA.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex++));
                this.classID.put(this.factory.getOWLObjectComplementOf(concept), nNCA.id);
                this.descriptions.put(nNCA.id, nNCA);
                this.imply(nNCA);
                ANC.complement = nNCA;
                nNCA.complement = ANC;
            }
        }
        return NC;
    }

    @Override
    public Role getRole(OWLObjectPropertyExpression property) {
        Role RN = super.getRole(property);
        if (RN == null && property instanceof OWLObjectInverseOf) {
            OWLObjectInverseOf inverse = (OWLObjectInverseOf)property;
            Role iRN = this.getRole(inverse.getInverse());
            RN = iRN.inverse;
            if (RN == null) {
                RN = new Role(this.propertyindex++);
                RN.uri = IRI.create((String)("RELAPPROX#RELAPPROXR" + this.propertyindex));
                RN.original = false;
                this.propertyID.put(property, RN.id);
                this.roles.put(RN.id, RN);
                RN.inverse = iRN;
                iRN.inverse = RN;
            }
        }
        return RN;
    }

    public Individual getIndividual(OWLIndividual individual) {
        Individual IN = null;
        if (this.individualID.get(individual) != null) {
            IN = this.individuals.get(this.individualID.get(individual));
        } else {
            IN = new Individual(individual);
            IN.id = this.individualindex++;
            this.individualID.put(individual, IN.id);
            this.individuals.put(IN.id, IN);
        }
        return IN;
    }

    public void normalise(Individual indi, Description concept, Traceability trace) {
        if (concept instanceof Atomic) {
            indi.origCls.put((Atomic)concept, trace);
            indi.classifications.put((Atomic)concept, trace);
        } else if (concept instanceof And) {
            this.normalise(indi, (And)concept, trace);
        } else if (concept instanceof Some) {
            this.normalise(indi, (Some)concept, trace);
        } else {
            System.out.println("wrong classification");
        }
    }

    public boolean normalise(Individual indi, And and, Traceability trace) {
        boolean change = false;
        for (Description operand : and.operands) {
            if (operand instanceof And) {
                this.normalise(indi, (And)operand, trace);
                continue;
            }
            if (operand instanceof Some) {
                this.normalise(indi, (Some)operand, trace);
                continue;
            }
            indi.origCls.put((Atomic)operand, trace);
            indi.classifications.put((Atomic)operand, trace);
        }
        return change;
    }

    private boolean normalise(Individual indi, Some some, Traceability trace) {
        boolean change = false;
        Atomic newclassification = this.getNamedClass(some);
        indi.origCls.put(newclassification, trace);
        indi.classifications.put(newclassification, trace);
        this.normalise(newclassification, (Description)some, trace);
        return change;
    }

    @Override
    public void OrderingCardinality() {
        for (Map.Entry entry : this.CardinalityTable.entrySet()) {
            Atomic filler = (Atomic)entry.getKey();
            HashMap cardins = (HashMap)entry.getValue();
            CardinalityEntry[] number = new CardinalityEntry[cardins.size()];
            int size = 0;
            Iterator iterator = cardins.keySet().iterator();
            while (iterator.hasNext()) {
                CardinalityEntry newentry;
                int n = (Integer)iterator.next();
                int i = 0;
                while (i < size) {
                    if (number[i].n < n) break;
                    ++i;
                }
                int j = size;
                while (j > i) {
                    number[j] = number[j - 1];
                    --j;
                }
                number[i] = newentry = new CardinalityEntry((Atomic)cardins.get(n), n);
                ++size;
            }
            filler.cardins = number;
            int i = 0;
            while (i < size - 1) {
                this.normalise(number[i].basen, (Description)number[i + 1].basen, null);
                ++i;
            }
        }
        if (this.constants.size() > 0) {
            OWLDifferentIndividualsAxiom axiom = this.factory.getOWLDifferentIndividualsAxiom((Set)this.constants);
            this.visit(axiom);
        }
        this.elcontology.classNum = this.classindex;
        this.elcontology.permanentclassNum = this.classindex;
        this.elcontology.roleNum = this.propertyindex;
        this.elcontology.individualNum = this.individualindex;
        this.elcontology.tracekey = this.tracekey;
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        OWLIndividual sub = axiom.getSubject();
        OWLIndividual obj = (OWLIndividual)axiom.getObject();
        Individual subject = this.getIndividual(sub);
        Individual object = this.getIndividual(obj);
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        Role role = this.getRole(property);
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        HashMap<Individual, Traceability> objects = subject.relations.get(role);
        if (objects == null) {
            objects = new HashMap();
            subject.relations.put(role, objects);
        }
        objects.put(object, trace);
        HashMap<Individual, Traceability> subjects = object.relations.get(role.inverse);
        if (subjects == null) {
            subjects = new HashMap();
            object.relations.put(role.inverse, subjects);
        }
        subjects.put(subject, trace);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        OWLIndividual sub = axiom.getSubject();
        OWLNamedIndividual obj = this.factory.getOWLNamedIndividual(IRI.create((String)("RELAPPROX#RELAPPROXI" + ((OWLLiteral)axiom.getObject()).getLiteral())));
        this.constants.add(obj);
        Individual subject = this.getIndividual(sub);
        Individual object = this.getIndividual((OWLIndividual)obj);
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        Role role = this.getRole(property);
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        HashMap<Individual, Traceability> objects = subject.relations.get(role);
        if (objects == null) {
            objects = new HashMap();
            subject.relations.put(role, objects);
        }
        objects.put(object, trace);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        Individual indi = this.getIndividual(axiom.getIndividual());
        Description classification = this.getDescription(this.getNNF(axiom.getClassExpression()));
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        this.normalise(indi, classification, trace);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        OWLClassExpression range = (OWLClassExpression)axiom.getRange();
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        this.getRole((OWLObjectPropertyExpression)property).related = true;
        OWLObjectSomeValuesFrom some = this.factory.getOWLObjectSomeValuesFrom(property, (OWLClassExpression)this.factory.getOWLObjectComplementOf(range));
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        this.normalise(this.getDescription(this.getNNF((OWLClassExpression)some)), (Description)this.bot, trace);
        OWLObjectSomeValuesFrom some2 = this.factory.getOWLObjectSomeValuesFrom(property.getInverseProperty(), (OWLClassExpression)this.factory.getOWLThing());
        this.normalise(this.getDescription(this.getNNF((OWLClassExpression)some2)), this.getDescription(this.getNNF(range)), trace);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        Set individuals = axiom.getIndividuals();
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        for (OWLIndividual individual1 : individuals) {
            Individual indi1 = this.getIndividual(individual1);
            for (OWLIndividual individual2 : individuals) {
                if (individual1.equals(individual2)) continue;
                Individual indi2 = this.getIndividual(individual2);
                indi1.differentIndividuals.put(indi2, trace);
                indi2.differentIndividuals.put(indi1, trace);
            }
        }
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        Set individuals = axiom.getIndividuals();
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        for (OWLIndividual individual1 : individuals) {
            Individual indi1 = this.getIndividual(individual1);
            for (OWLIndividual individual2 : individuals) {
                if (individual1.equals(individual2)) continue;
                Individual indi2 = this.getIndividual(individual2);
                indi1.sameIndividuals.put(indi2, trace);
                indi2.sameIndividuals.put(indi1, trace);
            }
        }
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        Role role1 = this.getRole(axiom.getFirstProperty());
        Role role2 = this.getRole(axiom.getSecondProperty());
        Traceability inversetrace = new Traceability();
        inversetrace.add((OWLLogicalAxiom)axiom);
        role1.subsumers.put(role2.inverse, inversetrace);
        role2.subsumers.put(role1.inverse, inversetrace);
        role1.inverse.subsumers.put(role2, inversetrace);
        role2.inverse.subsumers.put(role1, inversetrace);
    }

    @Override
    public Atomic getNamedClass(Description desc) {
        Atomic A = (Atomic)this.normalisationNames.get(desc);
        if (A == null) {
            A = new Atomic();
            A.id = this.classindex;
            A.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex));
            A.original = false;
            ++this.classindex;
            this.descriptions.put(A.id, A);
            this.normalisationNames.put(desc, A);
            this.imply(A);
            Atomic Acomp = new Atomic();
            Acomp.id = this.classindex;
            Acomp.uri = IRI.create((String)("RELAPPROX#RELAPPROXC" + this.classindex));
            Acomp.original = false;
            ++this.classindex;
            this.descriptions.put(Acomp.id, Acomp);
            this.imply(Acomp);
            A.complement = Acomp;
            Acomp.complement = A;
        }
        return A;
    }

    @Override
    public void createInverseRoles() {
        ArrayList<Role> nInvRoles = new ArrayList<Role>();
        for (Role role : this.roles.values()) {
            if (role.inverse != null) continue;
            nInvRoles.add(role);
        }
        for (Role role : nInvRoles) {
            Role inv = new Role(this.propertyindex);
            inv.original = false;
            inv.uri = IRI.create((String)("RELAPPROX#RELAPPROXR" + this.propertyindex++));
            this.propertyID.put(this.factory.getOWLObjectProperty(role.uri).getInverseProperty(), inv.id);
            this.roles.put(inv.id, inv);
            role.inverse = inv;
            inv.inverse = role;
        }
    }
}

