/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.reasoner.el;

import eu.trowl.owlapi3.rel.normal.classify.dl.CombinedClassifier;
import eu.trowl.owlapi3.rel.normal.factory.dl.OntologyFactory;
import eu.trowl.owlapi3.rel.normal.model.Atomic;
import eu.trowl.owlapi3.rel.normal.model.Basic;
import eu.trowl.owlapi3.rel.normal.model.Description;
import eu.trowl.owlapi3.rel.normal.model.Implies;
import eu.trowl.owlapi3.rel.normal.model.Ontology;
import eu.trowl.owlapi3.rel.normal.model.QueueEntry;
import eu.trowl.owlapi3.rel.normal.model.Role;
import eu.trowl.owlapi3.rel.normal.model.RoleConcept;
import eu.trowl.owlapi3.rel.normal.model.Singleton;
import eu.trowl.owlapi3.rel.util.RELReasonerConfiguration;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.Version;

public class RELReasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    protected static OntologyFactory elcfactory = null;
    public boolean bufferred = true;
    public OWLReasonerConfiguration configuration = null;
    public ArrayList<OWLNamedIndividual> inconsistentIndividuals = new ArrayList();
    public final OWLOntologyManager manager;
    protected boolean bgp = false;
    protected List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
    protected CombinedClassifier classifier;
    protected boolean disjoint = false;
    protected Ontology elcontology;
    protected final OWLDataFactory factory;
    protected HashSet<Basic> leaf;
    protected OWLClassNodeSet leaves;
    protected boolean MetaOn = false;
    protected OWLOntology ontology = null;
    protected OWLClassNodeSet satisfiable;
    protected Set<OWLAxiom> toadd = new HashSet<OWLAxiom>();
    protected Set<OWLAxiom> toremove = new HashSet<OWLAxiom>();
    protected OWLClassNode unsats;
    protected Version version = new Version(1, 5, 0, 0);
    Set<InferenceType> current_Precompute = new HashSet<InferenceType>();
    HashSet<Basic> satis;
    Set<InferenceType> supported_Precompute = new HashSet<InferenceType>();
    Set<InferenceType> supported_TBox_Precompute = new HashSet<InferenceType>();

    public RELReasoner(OWLOntologyManager manager, OWLOntology ontology, boolean bgp, boolean MetaOn, boolean disjoint) {
        this.manager = manager;
        this.factory = manager.getOWLDataFactory();
        this.ontology = ontology;
        this.bgp = bgp;
        this.MetaOn = MetaOn;
        this.disjoint = disjoint;
        this.supported_Precompute.add(InferenceType.CLASS_HIERARCHY);
        this.supported_Precompute.add(InferenceType.DATA_PROPERTY_HIERARCHY);
        this.supported_Precompute.add(InferenceType.DISJOINT_CLASSES);
        this.supported_Precompute.add(InferenceType.OBJECT_PROPERTY_HIERARCHY);
        this.supported_Precompute.add(InferenceType.CLASS_ASSERTIONS);
        this.supported_Precompute.add(InferenceType.DIFFERENT_INDIVIDUALS);
        this.supported_Precompute.add(InferenceType.OBJECT_PROPERTY_ASSERTIONS);
        this.supported_Precompute.add(InferenceType.SAME_INDIVIDUAL);
        this.supported_TBox_Precompute.add(InferenceType.CLASS_HIERARCHY);
        this.supported_TBox_Precompute.add(InferenceType.DATA_PROPERTY_HIERARCHY);
        this.supported_TBox_Precompute.add(InferenceType.DISJOINT_CLASSES);
        this.supported_TBox_Precompute.add(InferenceType.OBJECT_PROPERTY_HIERARCHY);
        if (bgp) {
            this.current_Precompute.add(InferenceType.CLASS_ASSERTIONS);
        }
        this.configuration = new RELReasonerConfiguration();
        this.initialiseClassifier();
        this.loadOntology();
    }

    public int countersubsumers() {
        return this.elcontology.countsubsumers();
    }

    public void dispose() {
        this.manager.removeOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public void flush() {
        this.toadd = new HashSet<OWLAxiom>();
        this.toremove = new HashSet<OWLAxiom>();
        this.initialiseClassifier();
        this.loadOntology();
        this.elcontology.tBox_Classified = false;
        this.elcontology.aBox_Classified = false;
        this.precomputeInferences(new InferenceType[0]);
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.factory.getOWLNothing());
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return new OWLDataPropertyNode();
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return new OWLObjectPropertyNode();
    }

    public BufferingMode getBufferingMode() {
        if (this.bufferred) {
            return BufferingMode.BUFFERING;
        }
        return BufferingMode.NON_BUFFERING;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty arg0, boolean arg1) {
        System.out.print("getDataPropertyDomains method is not supported yet!");
        return new OWLClassNodeSet();
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual arg0, OWLDataProperty arg1) {
        System.out.println("getDataPropertyValues method is not supported yet!");
        return new HashSet<OWLLiteral>();
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.aBox_Classified) {
            this.precomputeInferences(InferenceType.DIFFERENT_INDIVIDUALS);
        }
        OWLNamedIndividualNodeSet indis = new OWLNamedIndividualNodeSet();
        Singleton indi = this.getIndividual((OWLIndividual)arg0);
        if (indi != null) {
            for (Singleton diff : indi.differentIndividuals) {
                OWLNamedIndividualNode node = new OWLNamedIndividualNode();
                for (Basic equa : diff.equivalence) {
                    if (!equa.original || !(equa instanceof Singleton)) continue;
                    node.add((OWLObject)this.factory.getOWLNamedIndividual(equa.asSingleton().uri));
                }
                if (node.getSize() <= 0) continue;
                indis.addNode((Node)node);
            }
        }
        return indis;
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression concept) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.DISJOINT_CLASSES);
        }
        OWLClassNodeSet disjoints = new OWLClassNodeSet();
        System.out.println("getDisjointClasses method is not supported yet!");
        return disjoints;
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.DATA_PROPERTY_HIERARCHY);
        }
        OWLDataPropertyNodeSet props = new OWLDataPropertyNodeSet();
        Role role = this.getRole(arg0);
        if (role != null) {
            for (Role diff : role.disjoints) {
                OWLDataPropertyNode node = new OWLDataPropertyNode();
                for (Role equa : diff.equivalence) {
                    if (!equa.original) continue;
                    node.add((OWLObject)this.factory.getOWLDataProperty(equa.uri));
                }
                if (node.getSize() <= 0) continue;
                props.addNode((Node)node);
            }
        }
        return props;
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.OBJECT_PROPERTY_HIERARCHY);
        }
        OWLObjectPropertyNodeSet props = new OWLObjectPropertyNodeSet();
        Role role = this.getRole(arg0);
        if (role != null) {
            for (Role diff : role.disjoints) {
                OWLObjectPropertyNode node = new OWLObjectPropertyNode();
                for (Role equa : diff.equivalence) {
                    if (!equa.original) continue;
                    node.add((OWLObject)this.factory.getOWLObjectProperty(equa.uri));
                }
                if (node.getSize() <= 0) continue;
                props.addNode((Node)node);
            }
        }
        return props;
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression concept) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        }
        OWLClassNode equivalence = new OWLClassNode();
        Description desc = this.getDescription(concept);
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        boolean duo = false;
        if (desc == null || !(desc instanceof Atomic)) {
            duo = true;
            OWLClass tempclass = this.factory.getOWLClass(IRI.create((String)"http://trowl.eu/REL#tempC"));
            Map.Entry<Basic, Basic> entry = elcfactory.loadAxiom((OWLClassExpression)tempclass, concept);
            CombinedClassifier classifier = new CombinedClassifier();
            classifier.ontology = this.elcontology;
            classifier.completion_duo(this.elcontology.aBox_Classified);
            desc = (Atomic)entry.getValue();
        }
        Atomic atomic = (Atomic)desc;
        if ((atomic.equivalence.contains(bot) || atomic.subsumers.contains(bot) || atomic.tempSubsumers.contains(bot)) && atomic.id != 0) {
            return this.getEquivalentClasses((OWLClassExpression)this.factory.getOWLNothing());
        }
        if (atomic.id == 0) {
            return this.unsats;
        }
        for (Basic eq : atomic.equivalence) {
            if (!(eq instanceof Atomic) || !eq.original) continue;
            equivalence.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
        }
        for (Basic sup : atomic.tempSubsumers) {
            if (!(sup instanceof Atomic) || !sup.original || !sup.subsumers.contains(atomic) && !sup.tempSubsumers.contains(atomic)) continue;
            equivalence.add((OWLObject)this.factory.getOWLClass(((Atomic)sup).uri));
        }
        if (duo) {
            elcfactory.clean();
        }
        return equivalence;
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.DATA_PROPERTY_HIERARCHY);
        }
        OWLDataPropertyNode equivalence = new OWLDataPropertyNode();
        Role desc = this.getRole((OWLDataPropertyExpression)arg0);
        if (desc != null) {
            for (Role eq : desc.equivalence) {
                if (!eq.original) continue;
                equivalence.add((OWLObject)this.factory.getOWLDataProperty(eq.uri));
            }
        }
        return equivalence;
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.OBJECT_PROPERTY_HIERARCHY);
        }
        OWLObjectPropertyNode equivalence = new OWLObjectPropertyNode();
        Role desc = this.getRole(arg0);
        if (desc != null) {
            for (Role eq : desc.equivalence) {
                if (!eq.original) continue;
                equivalence.add((OWLObject)this.factory.getOWLObjectProperty(eq.uri));
            }
        }
        return equivalence;
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.configuration.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.configuration.getIndividualNodeSetPolicy();
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression arg0, boolean arg1) {
        return this.getIndividuals(arg0);
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Role role;
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.OBJECT_PROPERTY_HIERARCHY);
        }
        if ((role = this.getRole(arg0)) != null) {
            OWLObjectPropertyNode inverse = new OWLObjectPropertyNode();
            for (Role invrole : role.inverse.equivalence) {
                if (!invrole.original) continue;
                inverse.add((OWLObject)this.factory.getOWLObjectProperty(invrole.uri));
            }
            return inverse;
        }
        return new OWLObjectPropertyNode();
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectSomeValuesFrom exp = this.factory.getOWLObjectSomeValuesFrom(arg0, (OWLClassExpression)this.factory.getOWLThing());
        return this.getSuperClasses((OWLClassExpression)exp, arg1);
    }

    public Map<OWLNamedIndividual, Set<OWLNamedIndividual>> getObjectPropertyInstances(OWLObjectProperty owlOP) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.aBox_Classified) {
            this.precomputeInferences(InferenceType.OBJECT_PROPERTY_ASSERTIONS);
        }
        Role role = this.getRole((OWLObjectPropertyExpression)owlOP);
        HashMap<OWLNamedIndividual, Set<OWLNamedIndividual>> insts = new HashMap<OWLNamedIndividual, Set<OWLNamedIndividual>>();
        for (Singleton indi : role.subjects) {
            if (!indi.original) continue;
            OWLNamedIndividual sub = this.factory.getOWLNamedIndividual(indi.uri);
            HashSet<OWLNamedIndividual> objs = new HashSet<OWLNamedIndividual>();
            for (Basic obj : role.Relations.get(indi)) {
                if (!obj.original || !(obj instanceof Singleton)) continue;
                objs.add(this.factory.getOWLNamedIndividual(obj.uri));
            }
            if (objs.size() <= 0) continue;
            insts.put(sub, objs);
        }
        return insts;
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectSomeValuesFrom exp = this.factory.getOWLObjectSomeValuesFrom(arg0.getInverseProperty(), (OWLClassExpression)this.factory.getOWLThing());
        return this.getSuperClasses((OWLClassExpression)exp, arg1);
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual arg0, OWLObjectPropertyExpression arg1) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.aBox_Classified) {
            this.precomputeInferences(InferenceType.OBJECT_PROPERTY_ASSERTIONS);
        }
        OWLNamedIndividualNodeSet toreturn = new OWLNamedIndividualNodeSet();
        Singleton indi = this.getIndividual((OWLIndividual)arg0);
        Role role0 = this.getRole(arg1);
        if (indi != null && role0 != null) {
            for (Role role : role0.subroles) {
                if (role.Relations.get(indi) == null) continue;
                HashSet indi2s = new HashSet(role.Relations.get(indi));
                while (!indi2s.isEmpty()) {
                    Basic bsc = (Basic)indi2s.iterator().next();
                    if (bsc instanceof Singleton) {
                        Singleton indi2 = (Singleton)bsc;
                        OWLNamedIndividualNode node = new OWLNamedIndividualNode();
                        for (Basic equa : indi2.equivalence) {
                            if (!(equa instanceof Singleton)) continue;
                            node.add((OWLObject)this.factory.getOWLNamedIndividual(equa.asSingleton().uri));
                        }
                        if (node.getSize() > 0) {
                            toreturn.addNode((Node)node);
                        }
                        indi2s.removeAll(indi2.equivalence);
                    }
                    indi2s.remove(bsc);
                    indi2s.removeAll(bsc.equivalence);
                }
            }
            for (RoleConcept rc : indi.LeftConnection) {
                if (!rc.role.inverse.subsumers.contains(role0) || !(rc.concept instanceof Singleton)) continue;
                OWLNamedIndividualNode node = new OWLNamedIndividualNode();
                for (Basic equa : rc.concept.equivalence) {
                    if (!equa.original || !(equa instanceof Singleton)) continue;
                    node.add((OWLObject)this.factory.getOWLNamedIndividual(equa.asSingleton().uri));
                }
                if (node.getSize() <= 0) continue;
                toreturn.addNode((Node)node);
            }
        }
        return toreturn;
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return this.toadd;
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return this.toremove;
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return this.changes;
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return this.supported_Precompute;
    }

    public String getReasonerName() {
        return "REL";
    }

    public Version getReasonerVersion() {
        return this.version;
    }

    public OWLOntology getRootOntology() {
        return this.ontology;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.aBox_Classified) {
            this.precomputeInferences(InferenceType.SAME_INDIVIDUAL);
        }
        OWLNamedIndividualNode node = new OWLNamedIndividualNode();
        Singleton indi = this.getIndividual((OWLIndividual)arg0);
        if (indi != null) {
            for (Basic equa : indi.equivalence) {
                if (!equa.original || !(equa instanceof Singleton)) continue;
                node.add((OWLObject)this.factory.getOWLNamedIndividual(((Singleton)equa).uri));
            }
        }
        return node;
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression concept, boolean direct) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        }
        OWLClassNodeSet descendants = new OWLClassNodeSet();
        Description desc = this.getDescription(concept);
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        boolean duo = false;
        if (desc == null || !(desc instanceof Atomic)) {
            duo = true;
            OWLClass tempclass = this.factory.getOWLClass(IRI.create((String)"http://trowl.eu/REL#tempC"));
            OWLSubClassOfAxiom axiom = this.factory.getOWLSubClassOfAxiom(concept, (OWLClassExpression)tempclass);
            Map.Entry<Basic, Basic> entry = elcfactory.loadAxiom(axiom);
            Iterator<Atomic> classifier = new CombinedClassifier();
            ((CombinedClassifier)((Object)classifier)).ontology = this.elcontology;
            ((CombinedClassifier)((Object)classifier)).completion_duo(this.elcontology.aBox_Classified);
            desc = (Atomic)entry.getValue();
        }
        Atomic atom = (Atomic)desc;
        if (atom.equivalence.contains(bot) || atom.tempSubsumers.contains(bot)) {
            return descendants;
        }
        HashSet<Basic> subsumees = new HashSet<Basic>();
        if (direct) {
            for (Basic basic : this.elcontology.allconcepts) {
                if (basic.subsumers.contains(bot) || basic.tempSubsumers.contains(bot) || atom.equivalence.contains(basic) || subsumees.contains(basic) || !basic.subsumers.contains(atom) && !basic.tempSubsumers.contains(atom)) continue;
                boolean toadd = true;
                for (Basic subsub : basic.subsumers) {
                    if (!(subsub instanceof Atomic) || !subsub.original || basic.equivalence.contains(subsub) || atom.equivalence.contains(subsub) || !subsub.subsumers.contains(atom) && !subsub.tempSubsumers.contains(atom)) continue;
                    toadd = false;
                    break;
                }
                for (Basic subsub : basic.tempSubsumers) {
                    if (!(subsub instanceof Atomic) || !subsub.original || basic.equivalence.contains(subsub) || atom.equivalence.contains(subsub) || !subsub.subsumers.contains(atom) && !subsub.tempSubsumers.contains(atom)) continue;
                    toadd = false;
                    break;
                }
                if (!toadd) continue;
                subsumees.addAll(basic.equivalence);
            }
        } else {
            for (Basic basic : this.elcontology.allconcepts) {
                if (!basic.tempSubsumers.contains(atom) && !basic.subsumers.contains(atom) || basic.equivalence.contains(atom)) continue;
                subsumees.add(basic);
            }
        }
        while (subsumees.size() > 0) {
            Basic basic = (Basic)subsumees.iterator().next();
            subsumees.removeAll(basic.equivalence);
            OWLClassNode descendant = new OWLClassNode();
            for (Basic eq : basic.equivalence) {
                if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                descendant.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
            }
            if (descendant.getSize() <= 0) continue;
            descendants.addNode((Node)descendant);
        }
        if (!direct || descendants.getFlattened().size() == 0) {
            descendants.addNode((Node)this.unsats);
        }
        if (duo) {
            elcfactory.clean();
        }
        return descendants;
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet descendants;
        block9: {
            if (!this.isConsistent()) {
                throw new InconsistentOntologyException();
            }
            if (!this.elcontology.tBox_Classified) {
                this.precomputeInferences(InferenceType.DATA_PROPERTY_HIERARCHY);
            }
            descendants = new OWLDataPropertyNodeSet();
            Role role = this.getRole((OWLDataPropertyExpression)arg0);
            if (role == null) break block9;
            HashSet<Role> subsumees = new HashSet<Role>();
            if (arg1) {
                for (Role sub : this.elcontology.roles.values()) {
                    if (role.equivalence.contains(sub) || subsumees.contains(sub) || !sub.subsumers.contains(role)) continue;
                    boolean toadd = true;
                    for (Role subsub : sub.subsumers) {
                        if (!subsub.original || sub.equivalence.contains(subsub) || role.equivalence.contains(subsub) || !subsub.subsumers.contains(role)) continue;
                        toadd = false;
                        break;
                    }
                    if (!toadd) continue;
                    subsumees.addAll(sub.equivalence);
                }
            } else {
                for (Role sub : this.elcontology.roles.values()) {
                    if (!sub.subsumers.contains(role)) continue;
                    subsumees.add(sub);
                }
            }
            while (subsumees.size() > 0) {
                Role sub;
                sub = (Role)subsumees.iterator().next();
                subsumees.removeAll(sub.equivalence);
                OWLDataPropertyNode descendant = new OWLDataPropertyNode();
                for (Role eq : sub.equivalence) {
                    if (!eq.original) continue;
                    descendant.add((OWLObject)this.factory.getOWLDataProperty(eq.uri));
                }
                if (descendant.getSize() <= 0) continue;
                descendants.addNode((Node)descendant);
            }
        }
        return descendants;
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet descendants;
        block9: {
            if (!this.isConsistent()) {
                throw new InconsistentOntologyException();
            }
            if (!this.elcontology.tBox_Classified) {
                this.precomputeInferences(InferenceType.OBJECT_PROPERTY_HIERARCHY);
            }
            descendants = new OWLObjectPropertyNodeSet();
            Role role = this.getRole(arg0);
            if (role == null) break block9;
            HashSet<Role> subsumees = new HashSet<Role>();
            if (arg1) {
                for (Role sub : this.elcontology.roles.values()) {
                    if (role.equivalence.contains(sub) || subsumees.contains(sub) || !sub.subsumers.contains(role)) continue;
                    boolean toadd = true;
                    for (Role subsub : sub.subsumers) {
                        if (!subsub.original || sub.equivalence.contains(subsub) || role.equivalence.contains(subsub) || !subsub.subsumers.contains(role)) continue;
                        toadd = false;
                        break;
                    }
                    if (!toadd) continue;
                    subsumees.addAll(sub.equivalence);
                }
            } else {
                for (Role sub : this.elcontology.roles.values()) {
                    if (!sub.subsumers.contains(role)) continue;
                    subsumees.add(sub);
                }
            }
            while (subsumees.size() > 0) {
                Role sub;
                sub = (Role)subsumees.iterator().next();
                subsumees.removeAll(sub.equivalence);
                OWLObjectPropertyNode descendant = new OWLObjectPropertyNode();
                for (Role eq : sub.equivalence) {
                    if (!eq.original) continue;
                    descendant.add((OWLObject)this.factory.getOWLObjectProperty(eq.uri));
                }
                if (descendant.getSize() <= 0) continue;
                descendants.addNode((Node)descendant);
            }
        }
        return descendants;
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression concept, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        }
        OWLClassNodeSet ancestors = new OWLClassNodeSet();
        Description desc = this.getDescription(concept);
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        boolean duo = false;
        if (desc == null || !(desc instanceof Atomic)) {
            duo = true;
            OWLClass tempclass = this.factory.getOWLClass(IRI.create((String)"http://trowl.eu/REL#tempC"));
            OWLSubClassOfAxiom axiom = this.factory.getOWLSubClassOfAxiom((OWLClassExpression)tempclass, concept);
            Map.Entry<Basic, Basic> entry = elcfactory.loadAxiom(axiom);
            Iterator classifier = new CombinedClassifier();
            ((CombinedClassifier)((Object)classifier)).ontology = this.elcontology;
            ((CombinedClassifier)((Object)classifier)).completion_duo(this.elcontology.aBox_Classified);
            desc = (Atomic)entry.getKey();
        }
        Atomic atom = (Atomic)desc;
        HashSet<Basic> subsumers = new HashSet<Basic>();
        if (direct) {
            boolean toadd;
            if (atom.equivalence.contains(bot) || atom.tempSubsumers.contains(bot)) {
                return this.leaves;
            }
            for (Basic sub : atom.subsumers) {
                if (!(sub instanceof Atomic) || !sub.original || atom.equivalence.contains(sub) || subsumers.contains(sub)) continue;
                toadd = true;
                for (Basic sub2 : atom.subsumers) {
                    if (!(sub2 instanceof Atomic) || !sub2.original || atom.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.contains(sub) && !sub2.tempSubsumers.contains(sub)) continue;
                    toadd = false;
                    break;
                }
                for (Basic sub2 : atom.tempSubsumers) {
                    if (!(sub2 instanceof Atomic) || !sub2.original || atom.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.contains(sub) && !sub2.tempSubsumers.contains(sub)) continue;
                    toadd = false;
                    break;
                }
                if (!toadd) continue;
                subsumers.addAll(sub.equivalence);
            }
            for (Basic sub : atom.tempSubsumers) {
                if (!(sub instanceof Atomic) || !sub.original || atom.equivalence.contains(sub) || subsumers.contains(sub)) continue;
                toadd = true;
                for (Basic sub2 : atom.subsumers) {
                    if (!(sub2 instanceof Atomic) || !sub2.original || atom.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.contains(sub) && !sub2.tempSubsumers.contains(sub)) continue;
                    toadd = false;
                    break;
                }
                for (Basic sub2 : atom.tempSubsumers) {
                    if (!(sub2 instanceof Atomic) || !sub2.original || atom.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.contains(sub) && !sub2.tempSubsumers.contains(sub)) continue;
                    toadd = false;
                    break;
                }
                if (!toadd) continue;
                subsumers.addAll(sub.equivalence);
            }
        } else {
            if (atom.equivalence.contains(bot) || atom.tempSubsumers.contains(bot)) {
                return this.satisfiable;
            }
            for (Basic sub : atom.subsumers) {
                if (!(sub instanceof Atomic) || atom.equivalence.contains(sub) || !sub.original) continue;
                subsumers.add(sub);
            }
            for (Basic sub : atom.tempSubsumers) {
                if (!(sub instanceof Atomic) || atom.equivalence.contains(sub) || !sub.original) continue;
                subsumers.add(sub);
            }
        }
        while (subsumers.size() > 0) {
            Basic sub;
            sub = (Basic)subsumers.iterator().next();
            subsumers.removeAll(sub.equivalence);
            OWLClassNode ancestor = new OWLClassNode();
            for (Basic eq : sub.equivalence) {
                if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                ancestor.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
            }
            if (ancestor.getSize() <= 0) continue;
            ancestors.addNode((Node)ancestor);
        }
        if (duo) {
            elcfactory.clean();
        }
        return ancestors;
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet ancestors;
        block9: {
            if (!this.isConsistent()) {
                throw new InconsistentOntologyException();
            }
            if (!this.elcontology.tBox_Classified) {
                this.precomputeInferences(InferenceType.DATA_PROPERTY_HIERARCHY);
            }
            ancestors = new OWLDataPropertyNodeSet();
            Role role = this.getRole((OWLDataPropertyExpression)arg0);
            if (role == null) break block9;
            HashSet<Role> subsumers = new HashSet<Role>();
            if (arg1) {
                for (Role sub : role.subsumers) {
                    if (!sub.original || role.equivalence.contains(sub) || subsumers.contains(sub)) continue;
                    boolean toadd = true;
                    for (Role sub2 : role.subsumers) {
                        if (!sub2.original || role.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.contains(sub)) continue;
                        toadd = false;
                        break;
                    }
                    if (!toadd) continue;
                    subsumers.addAll(sub.equivalence);
                }
            } else {
                for (Role sub : role.subsumers) {
                    subsumers.add(sub);
                }
            }
            while (subsumers.size() > 0) {
                Role sub;
                sub = (Role)subsumers.iterator().next();
                subsumers.removeAll(sub.equivalence);
                OWLDataPropertyNode ancestor = new OWLDataPropertyNode();
                for (Role eq : sub.equivalence) {
                    if (!eq.original) continue;
                    ancestor.add((OWLObject)this.factory.getOWLDataProperty(eq.uri));
                }
                if (ancestor.getSize() <= 0) continue;
                ancestors.addNode((Node)ancestor);
            }
        }
        return ancestors;
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet ancestors;
        block9: {
            if (!this.isConsistent()) {
                throw new InconsistentOntologyException();
            }
            if (!this.elcontology.tBox_Classified) {
                this.precomputeInferences(InferenceType.OBJECT_PROPERTY_HIERARCHY);
            }
            ancestors = new OWLObjectPropertyNodeSet();
            Role role = this.getRole(arg0);
            if (role == null) break block9;
            HashSet<Role> subsumers = new HashSet<Role>();
            if (arg1) {
                for (Role sub : role.subsumers) {
                    if (!sub.original || role.equivalence.contains(sub) || subsumers.contains(sub)) continue;
                    boolean toadd = true;
                    for (Role sub2 : role.subsumers) {
                        if (!sub2.original || role.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.contains(sub)) continue;
                        toadd = false;
                        break;
                    }
                    if (!toadd) continue;
                    subsumers.addAll(sub.equivalence);
                }
            } else {
                for (Role sub : role.subsumers) {
                    subsumers.add(sub);
                }
            }
            while (subsumers.size() > 0) {
                Role sub;
                sub = (Role)subsumers.iterator().next();
                subsumers.removeAll(sub.equivalence);
                OWLObjectPropertyNode ancestor = new OWLObjectPropertyNode();
                for (Role eq : sub.equivalence) {
                    if (!eq.original) continue;
                    ancestor.add((OWLObject)this.factory.getOWLObjectProperty(eq.uri));
                }
                if (ancestor.getSize() <= 0) continue;
                ancestors.addNode((Node)ancestor);
            }
        }
        return ancestors;
    }

    public long getTimeOut() {
        return this.configuration.getTimeOut();
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.factory.getOWLThing());
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        System.out.println("getTopDataPropertyNode is not supported yet.");
        return new OWLDataPropertyNode();
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        System.out.print("getTopObjectPropertyNode is not supported yet.");
        return new OWLObjectPropertyNode();
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual arg0, boolean arg1) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.aBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_ASSERTIONS);
        }
        OWLClassNodeSet types = new OWLClassNodeSet();
        Singleton indi = this.getIndividual((OWLIndividual)arg0);
        if (indi == null) {
            return types;
        }
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        HashSet<Object> classes = new HashSet();
        if (indi.subsumers.contains(bot)) {
            classes = this.elcontology.allconcepts;
        } else {
            for (Basic cls : indi.subsumers) {
                if (!(cls instanceof Atomic) || !cls.original) continue;
                classes.add((Atomic)cls);
            }
        }
        if (arg1) {
            HashSet<Object> toremove = new HashSet<Object>(classes);
            for (Basic basic : toremove) {
                for (Basic basic2 : toremove) {
                    if (!basic.subsumers.contains(basic2) || basic.equivalence.contains(basic2)) continue;
                    classes.removeAll(basic2.equivalence);
                }
            }
        }
        while (classes.size() > 0) {
            Basic sub = (Basic)classes.iterator().next();
            classes.removeAll(sub.equivalence);
            OWLClassNode oWLClassNode = new OWLClassNode();
            for (Basic eq : sub.equivalence) {
                if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                oWLClassNode.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
            }
            if (oWLClassNode.getSize() <= 0) continue;
            types.addNode((Node)oWLClassNode);
        }
        return types;
    }

    public Node<OWLClass> getUnsatisfiableClasses() {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        }
        return this.unsats;
    }

    public boolean hasObjectPropertyRelationship(OWLNamedIndividual ind1, OWLObjectProperty ope, OWLNamedIndividual ind2) {
        Singleton sub = this.getIndividual((OWLIndividual)ind1);
        Role role = this.getRole((OWLObjectPropertyExpression)ope);
        Singleton obj = this.getIndividual((OWLIndividual)ind2);
        if (sub != null && role != null && role.subjects.contains(sub)) {
            return role.Relations.get(sub).contains(obj);
        }
        return false;
    }

    public void interrupt() {
        System.out.println("interrupt is not supported yet.");
    }

    public boolean isConsistent() {
        if (this.elcontology.consistency && !this.elcontology.aBox_Classified) {
            this.current_Precompute.addAll(this.supported_Precompute);
            this.classify(!this.elcontology.tBox_Classified, !this.elcontology.aBox_Classified);
        }
        return this.elcontology.consistency;
    }

    public boolean isEntailed(OWLAxiom arg0) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        if (arg0 instanceof OWLSubClassOfAxiom) {
            return this.entail((OWLSubClassOfAxiom)arg0);
        }
        if (arg0 instanceof OWLClassAssertionAxiom) {
            return this.entail((OWLClassAssertionAxiom)arg0);
        }
        if (arg0 instanceof OWLDisjointClassesAxiom) {
            return this.entail((OWLDisjointClassesAxiom)arg0);
        }
        if (arg0 instanceof OWLFunctionalDataPropertyAxiom) {
            return this.entail((OWLFunctionalDataPropertyAxiom)arg0);
        }
        if (arg0 instanceof OWLFunctionalObjectPropertyAxiom) {
            return this.entail((OWLFunctionalObjectPropertyAxiom)arg0);
        }
        System.out.println("This type of entailment checking is not supported yet");
        throw new UnsupportedEntailmentTypeException(arg0);
    }

    public boolean isEntailed(Set<? extends OWLAxiom> arg0) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        for (OWLAxiom oWLAxiom : arg0) {
            if (this.isEntailed(oWLAxiom)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> arg0) {
        return arg0.equals((Object)AxiomType.CLASS_ASSERTION) || arg0.equals((Object)AxiomType.SUBCLASS_OF) || arg0.equals((Object)AxiomType.DISJOINT_CLASSES) || arg0.equals((Object)AxiomType.FUNCTIONAL_DATA_PROPERTY) || arg0.equals((Object)AxiomType.FUNCTIONAL_OBJECT_PROPERTY);
    }

    public boolean isoriginal(OWLClass concept) {
        Basic elpconcept = (Basic)this.getDescription((OWLClassExpression)concept);
        if (elpconcept != null) {
            return elpconcept.original;
        }
        return false;
    }

    public boolean isPrecomputed(InferenceType arg0) {
        return this.current_Precompute.contains(arg0);
    }

    public boolean isSatisfiable(OWLClassExpression arg0) {
        OWLSubClassOfAxiom axiom1 = this.factory.getOWLSubClassOfAxiom(arg0, (OWLClassExpression)this.factory.getOWLNothing());
        return !this.entail(axiom1);
    }

    public void loadOntology() {
        elcfactory = new OntologyFactory(this.ontology, this.bgp, this.MetaOn, this.disjoint);
        elcfactory.createbuilder();
        this.elcontology = elcfactory.createELOntology();
        this.elcontology.profile = Ontology.Profile.OWL_2_EL;
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> arg0) throws OWLException {
        if (this.bufferred) {
            for (OWLOntologyChange oWLOntologyChange : arg0) {
                if (oWLOntologyChange instanceof AddAxiom) {
                    this.toadd.add(oWLOntologyChange.getAxiom());
                    continue;
                }
                this.toremove.add(oWLOntologyChange.getAxiom());
            }
            this.changes.addAll(arg0);
        } else {
            this.loadOntology();
            this.elcontology.tBox_Classified = false;
            this.elcontology.aBox_Classified = false;
            this.precomputeInferences(new InferenceType[0]);
        }
    }

    public void precomputeInferences(InferenceType ... arg0) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        InferenceType[] inferenceTypeArray = arg0;
        int n = arg0.length;
        int n2 = 0;
        while (n2 < n) {
            InferenceType type = inferenceTypeArray[n2];
            if (!this.supported_Precompute.contains(type)) {
                System.out.println("REL does not support precomputation of this inference type yet. It will be ignored.");
            } else {
                this.current_Precompute.add(type);
            }
            ++n2;
        }
        if (this.current_Precompute.contains(InferenceType.CLASS_ASSERTIONS) || this.current_Precompute.contains(InferenceType.DIFFERENT_INDIVIDUALS) || this.current_Precompute.contains(InferenceType.OBJECT_PROPERTY_ASSERTIONS) || this.current_Precompute.contains(InferenceType.SAME_INDIVIDUAL)) {
            this.current_Precompute.addAll(this.supported_Precompute);
            this.classify(!this.elcontology.tBox_Classified, !this.elcontology.aBox_Classified);
        } else if (this.current_Precompute.contains(InferenceType.CLASS_HIERARCHY) || this.current_Precompute.contains(InferenceType.DATA_PROPERTY_HIERARCHY) || this.current_Precompute.contains(InferenceType.DISJOINT_CLASSES) || this.current_Precompute.contains(InferenceType.OBJECT_PROPERTY_HIERARCHY)) {
            this.current_Precompute.addAll(this.supported_TBox_Precompute);
            this.classify(!this.elcontology.tBox_Classified, false);
        }
        if (!this.elcontology.consistency) {
            throw new InconsistentOntologyException();
        }
    }

    private boolean inconsistent() {
        Basic bot = (Basic)this.elcontology.descriptions.get(0);
        for (Integer indi : this.elcontology.individualID.values()) {
            Singleton single = (Singleton)this.elcontology.descriptions.get(indi);
            ArrayList<Basic> imps = new ArrayList<Basic>();
            for (QueueEntry entry : single.Ohat) {
                if (!(entry instanceof Implies)) continue;
                Implies imp = (Implies)entry;
                if (imp.lhs == null && imp.rhs.subsumers.contains(bot)) {
                    return true;
                }
                imps.add(imp.rhs);
            }
            for (Basic bsc1 : imps) {
                for (Basic bsc2 : imps) {
                    if (bsc1.complement != null && (bsc2.subsumers.contains(bsc1.complement) || bsc1.complement.subsumers.contains(bsc2))) {
                        return true;
                    }
                    if (bsc2.complement == null || !bsc1.subsumers.contains(bsc2.complement) && !bsc2.complement.subsumers.contains(bsc1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void save(boolean TBox, boolean Type2, boolean Relation, boolean subType, boolean clsType, OutputStream out) throws IOException {
        Singleton indi;
        Iterator<Object> iterator;
        String rdfs = "<http://www.w3.org/2000/01/rdf-schema#> .\n";
        String rdf = "<http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n";
        OutputStreamWriter writer = new OutputStreamWriter(out);
        writer.write("@prefix rdf: " + rdf);
        writer.write("@prefix rdfs: " + rdfs);
        if (TBox) {
            for (Basic basic : this.elcontology.allconcepts) {
                ArrayList<Basic> sups;
                if (!(basic instanceof Atomic) || basic.id <= 1 || (sups = this.getsubsumers(basic, subType)).size() <= 0) continue;
                writer.write("<" + basic.uri + "> rdfs:subClassOf ");
                int i = 0;
                while (i < sups.size() - 1) {
                    writer.write("<" + sups.get((int)i).uri + "> ,\n");
                    ++i;
                }
                writer.write("<" + sups.get(sups.size() - 1) + "> .\n");
            }
        }
        if (Type2 && Relation) {
            iterator = this.elcontology.individualID.values().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                indi = (Singleton)this.elcontology.descriptions.get(n);
                if (!indi.original) continue;
                ArrayList<Basic> clss = this.getcls(indi, clsType);
                if (clss.size() > 0) {
                    writer.write("<" + indi.uri + "> a ");
                    int i = 0;
                    while (i < clss.size() - 1) {
                        writer.write("<" + clss.get((int)i).uri + "> ,\n");
                        ++i;
                    }
                    writer.write("<" + clss.get(clss.size() - 1) + "> .\n");
                }
                for (Role role : this.elcontology.roles.values()) {
                    if (!role.original || role.Relations.get(indi) == null) continue;
                    ArrayList<Singleton> objs = new ArrayList<Singleton>();
                    for (Basic obj : role.Relations.get(indi)) {
                        if (!(obj instanceof Singleton) || !obj.original) continue;
                        objs.add(obj.asSingleton());
                    }
                    if (objs.size() <= 0) continue;
                    writer.write("<" + indi.uri + "> <" + role.uri + "> ");
                    int i = 0;
                    while (i < objs.size() - 1) {
                        writer.write("<" + ((Singleton)objs.get((int)i)).uri + "> ,\n");
                        ++i;
                    }
                    writer.write("<" + objs.get(objs.size() - 1) + "> .\n");
                }
            }
        } else if (Type2) {
            iterator = this.elcontology.individualID.values().iterator();
            while (iterator.hasNext()) {
                ArrayList<Basic> clss;
                int n = (Integer)iterator.next();
                indi = (Singleton)this.elcontology.descriptions.get(n);
                if (!indi.original || (clss = this.getcls(indi, clsType)).size() <= 0) continue;
                writer.write("<" + indi.uri + "> a ");
                int i = 0;
                while (i < clss.size() - 1) {
                    writer.write("<" + clss.get((int)i).uri + "> ,");
                    ++i;
                }
                writer.write("<" + clss.get(clss.size() - 1) + "> .");
            }
        } else if (Relation) {
            iterator = this.elcontology.individualID.values().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                indi = (Singleton)this.elcontology.descriptions.get(n);
                if (!indi.original) continue;
                for (Role role : this.elcontology.roles.values()) {
                    if (!role.original || role.Relations.get(indi) == null) continue;
                    writer.write("<" + indi.uri + "> <" + role.uri + "> ");
                    ArrayList<Singleton> objs = new ArrayList<Singleton>();
                    for (Basic obj : role.Relations.get(indi)) {
                        if (!(obj instanceof Singleton) || !obj.original) continue;
                        objs.add(obj.asSingleton());
                    }
                    int i = 0;
                    while (i < objs.size() - 1) {
                        writer.write("<" + ((Singleton)objs.get((int)i)).uri + "> ,");
                        ++i;
                    }
                    writer.write("<" + objs.get(objs.size() - 1) + "> .");
                }
            }
        }
        writer.close();
    }

    public void classify(boolean TBox, boolean ABox) {
        this.classifier.ontology = this.elcontology;
        if (!TBox && !ABox) {
            return;
        }
        this.elcontology.consistency = true;
        this.classifier.completion(TBox, ABox);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (!this.elcontology.consistency) {
            this.elcontology.tBox_Classified = true;
            this.elcontology.aBox_Classified = true;
            return;
        }
        if (!this.elcontology.tBox_Classified) {
            OWLClassNode ancestor;
            Basic sub;
            this.satis = new HashSet<Atomic>(this.elcontology.allconcepts);
            Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
            this.satis.removeAll(bot.equivalence);
            this.leaves = new OWLClassNodeSet();
            this.satisfiable = new OWLClassNodeSet();
            this.leaf = new HashSet<Basic>(this.satis);
            for (Basic basic : this.satis) {
                if (!this.leaf.contains(basic)) continue;
                Atomic atom = (Atomic)basic;
                for (Basic sub2 : atom.subsumers) {
                    if (atom.equivalence.contains(sub2) || !this.leaf.contains(sub2)) continue;
                    this.leaf.removeAll(sub2.equivalence);
                }
            }
            this.unsats = new OWLClassNode();
            for (Basic bsc : bot.equivalence) {
                if (!(bsc instanceof Atomic) || !bsc.original) continue;
                this.unsats.add((OWLObject)this.factory.getOWLClass(bsc.uri));
            }
            while (this.satis.size() > 0) {
                sub = this.satis.iterator().next();
                this.satis.removeAll(sub.equivalence);
                ancestor = new OWLClassNode();
                for (Basic eq : sub.equivalence) {
                    if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                    ancestor.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
                }
                if (ancestor.getSize() <= 0) continue;
                this.satisfiable.addNode((Node)ancestor);
            }
            while (this.leaf.size() > 0) {
                sub = this.leaf.iterator().next();
                this.leaf.removeAll(sub.equivalence);
                ancestor = new OWLClassNode();
                for (Basic eq : sub.equivalence) {
                    if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                    ancestor.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
                }
                if (ancestor.getSize() <= 0) continue;
                this.leaves.addNode((Node)ancestor);
            }
            this.elcontology.tBox_Classified = true;
        }
        if (ABox) {
            this.elcontology.aBox_Classified = true;
        }
    }

    protected boolean entail(OWLClassAssertionAxiom axiom) {
        Basic bsup;
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.aBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_ASSERTIONS);
        }
        Singleton indi = this.getIndividual(axiom.getIndividual());
        Description sup = this.getDescription(axiom.getClassExpression());
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        boolean answer = false;
        boolean duo = false;
        if (sup == null || !(sup instanceof Basic)) {
            duo = true;
            OWLClass tempclass = this.factory.getOWLClass(IRI.create((String)"http://trowl.eu/REL#tempD"));
            OWLSubClassOfAxiom tempaxiom = this.factory.getOWLSubClassOfAxiom(axiom.getClassExpression(), (OWLClassExpression)tempclass);
            Map.Entry<Basic, Basic> entry = elcfactory.loadAxiom(tempaxiom);
            CombinedClassifier classifier = new CombinedClassifier();
            classifier.ontology = this.elcontology;
            classifier.completion_duo(this.elcontology.aBox_Classified);
            sup = (Atomic)entry.getValue();
        }
        boolean bl = answer = indi.subsumers.contains(bsup = (Basic)sup) || indi.subsumers.contains(bot) || indi.tempSubsumers.contains(bsup) || indi.tempSubsumers.contains(bot);
        if (duo) {
            elcfactory.clean();
        }
        return answer;
    }

    protected boolean entail(OWLDisjointClassesAxiom axiom) {
        List list = axiom.getClassExpressionsAsList();
        int i = 0;
        while (i < list.size() - 1) {
            int j = i + 1;
            while (j < list.size()) {
                if (!this.entail(this.factory.getOWLSubClassOfAxiom((OWLClassExpression)list.get(i), (OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)list.get(j))))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected boolean entail(OWLFunctionalDataPropertyAxiom axiom) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.DATA_PROPERTY_HIERARCHY);
        }
        Role role = this.getRole((OWLDataPropertyExpression)axiom.getProperty());
        for (Role sup : role.subsumers) {
            if (!sup.functional) continue;
            return true;
        }
        return false;
    }

    protected boolean entail(OWLFunctionalObjectPropertyAxiom axiom) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.OBJECT_PROPERTY_HIERARCHY);
        }
        Role role = this.getRole((OWLObjectPropertyExpression)axiom.getProperty());
        for (Role sup : role.subsumers) {
            if (!sup.functional) continue;
            return true;
        }
        return false;
    }

    protected boolean entail(OWLSubClassOfAxiom axiom) {
        CombinedClassifier classifier;
        Map.Entry<Basic, Basic> entry;
        OWLSubClassOfAxiom tempaxiom;
        OWLClass tempclass;
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        }
        Description sub = this.getDescription(axiom.getSubClass());
        Description sup = this.getDescription(axiom.getSuperClass());
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        boolean answer = false;
        boolean duo = false;
        if (sub == null || !(sub instanceof Basic)) {
            duo = true;
            tempclass = this.factory.getOWLClass(IRI.create((String)"http://trowl.eu/REL#tempC"));
            tempaxiom = this.factory.getOWLSubClassOfAxiom((OWLClassExpression)tempclass, axiom.getSubClass());
            entry = elcfactory.loadAxiom(tempaxiom);
            classifier = new CombinedClassifier();
            classifier.ontology = this.elcontology;
            classifier.completion_duo(this.elcontology.aBox_Classified);
            sub = (Atomic)entry.getKey();
        }
        if (sup == null || !(sup instanceof Basic)) {
            duo = true;
            tempclass = this.factory.getOWLClass(IRI.create((String)"http://trowl.eu/REL#tempD"));
            tempaxiom = this.factory.getOWLSubClassOfAxiom(axiom.getSuperClass(), (OWLClassExpression)tempclass);
            entry = elcfactory.loadAxiom(tempaxiom);
            classifier = new CombinedClassifier();
            classifier.ontology = this.elcontology;
            classifier.completion_duo(this.elcontology.aBox_Classified);
            sup = (Atomic)entry.getValue();
        }
        Basic bsub = (Basic)sub;
        Basic bsup = (Basic)sup;
        boolean bl = answer = bsub.subsumers.contains(bsup) || bsub.subsumers.contains(bot) || bsub.tempSubsumers.contains(bsup) || bsub.tempSubsumers.contains(bot);
        if (duo) {
            elcfactory.clean();
        }
        return answer;
    }

    protected Description getDescription(OWLClassExpression desc) {
        if (this.elcontology.classID.get(desc) != null) {
            return this.elcontology.descriptions.get(this.elcontology.classID.get(desc));
        }
        return null;
    }

    protected Singleton getIndividual(OWLIndividual indi) {
        if (this.elcontology.individualID.get(indi) != null) {
            return (Singleton)this.elcontology.descriptions.get(this.elcontology.individualID.get(indi));
        }
        return null;
    }

    protected NodeSet<OWLNamedIndividual> getIndividuals(OWLClassExpression concept) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.aBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_ASSERTIONS);
        }
        OWLNamedIndividualNodeSet individuals = new OWLNamedIndividualNodeSet();
        HashSet<Singleton> indis = new HashSet<Singleton>();
        boolean duo = false;
        Atomic elpconcept = null;
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        if (this.elcontology.classID.get(concept) == null || !(this.elcontology.descriptions.get(this.elcontology.classID.get(concept)) instanceof Atomic)) {
            duo = true;
            OWLClass tempclass = this.factory.getOWLClass(IRI.create((String)"http://trowl.eu/REL#tempC"));
            OWLSubClassOfAxiom axiom = this.factory.getOWLSubClassOfAxiom(concept, (OWLClassExpression)tempclass);
            Map.Entry<Basic, Basic> entry = elcfactory.loadAxiom(axiom);
            CombinedClassifier classifier = new CombinedClassifier();
            classifier.ontology = this.elcontology;
            classifier.completion_duo(this.elcontology.aBox_Classified);
            elpconcept = (Atomic)entry.getValue();
        } else {
            elpconcept = (Atomic)this.elcontology.descriptions.get(this.elcontology.classID.get(concept));
        }
        for (Description bsc : this.elcontology.descriptions.values()) {
            if (!(bsc instanceof Singleton)) continue;
            Singleton indi = (Singleton)bsc;
            if (!indi.subsumers.contains(bot) && !indi.subsumers.contains(elpconcept) && !indi.tempSubsumers.contains(elpconcept)) continue;
            indis.add(indi);
        }
        while (indis.size() > 0) {
            Singleton head = (Singleton)indis.iterator().next();
            indis.removeAll(head.equivalence);
            OWLNamedIndividualNode node = new OWLNamedIndividualNode();
            for (Basic same : head.equivalence) {
                if (!(same instanceof Singleton) || !((Singleton)same).original) continue;
                node.add((OWLObject)this.factory.getOWLNamedIndividual(same.asSingleton().uri));
            }
            individuals.addNode((Node)node);
        }
        if (duo) {
            elcfactory.clean();
        }
        return individuals;
    }

    protected Role getRole(OWLDataPropertyExpression role) {
        OWLObjectProperty objrole = this.factory.getOWLObjectProperty(role.asOWLDataProperty().getIRI());
        if (this.elcontology.roleID.get(objrole) != null) {
            return this.elcontology.roles.get(this.elcontology.roleID.get(objrole));
        }
        return null;
    }

    protected Role getRole(OWLObjectPropertyExpression role) {
        if (this.elcontology.roleID.get(role) != null) {
            return this.elcontology.roles.get(this.elcontology.roleID.get(role));
        }
        return null;
    }

    protected void initialiseClassifier() {
        this.classifier = new CombinedClassifier();
    }

    ArrayList<Basic> getcls(Singleton indi, boolean arg1) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.DATA_PROPERTY_HIERARCHY);
        }
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        ArrayList<Basic> classes = new ArrayList();
        if (indi.subsumers.contains(bot)) {
            classes = new ArrayList<Atomic>(this.elcontology.allconcepts);
        } else {
            for (Basic cls : indi.subsumers) {
                if (!(cls instanceof Atomic) || !cls.original) continue;
                classes.add(cls);
            }
        }
        if (arg1) {
            ArrayList<Basic> toremove = new ArrayList<Basic>(classes);
            for (Basic basic : toremove) {
                for (Basic basic2 : toremove) {
                    if (!basic.subsumers.contains(basic2) || basic.equivalence.contains(basic2)) continue;
                    classes.removeAll(basic2.equivalence);
                }
            }
        }
        return classes;
    }

    ArrayList<Basic> getsubsumers(Basic desc, boolean arg1) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        }
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        ArrayList<Basic> subsumers = new ArrayList<Basic>();
        Atomic atom = (Atomic)desc;
        if (arg1) {
            if (atom.equivalence.contains(bot)) {
                return new ArrayList<Basic>(this.leaf);
            }
            for (Basic sub : atom.subsumers) {
                if (!sub.original || !(sub instanceof Atomic) || subsumers.contains(sub)) continue;
                boolean toadd = true;
                for (Basic sub2 : atom.subsumers) {
                    if (!sub2.original || atom.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.contains(sub)) continue;
                    toadd = false;
                    break;
                }
                for (Basic sub2 : atom.tempSubsumers) {
                    if (!sub2.original || atom.equivalence.contains(sub2) || sub.equivalence.contains(sub2) || !sub2.subsumers.contains(sub)) continue;
                    toadd = false;
                    break;
                }
                if (!toadd) continue;
                subsumers.add(sub);
            }
        } else {
            if (atom.equivalence.contains(bot)) {
                return new ArrayList<Basic>(this.satis);
            }
            for (Basic sub : atom.subsumers) {
                if (!sub.original) continue;
                subsumers.add(sub);
            }
        }
        return subsumers;
    }
}

