/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owl.syntax;

import eu.trowl.owl.syntax.AbstractOWLLanguageGroupChecker;
import eu.trowl.owl.syntax.OWLLanguage;
import eu.trowl.owl.syntax.OWLLanguageGroupChecker;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWL2QLProfile;
import org.semanticweb.owlapi.profiles.OWL2RLProfile;

public class OWL2ProfileChecker
extends AbstractOWLLanguageGroupChecker
implements OWLLanguageGroupChecker {
    @Override
    public void check(OWLOntologyManager man) {
        OWL2ELProfile el = new OWL2ELProfile();
        OWL2RLProfile rl = new OWL2RLProfile();
        OWL2QLProfile ql = new OWL2QLProfile();
        OWL2DLProfile dl = new OWL2DLProfile();
        boolean in = true;
        for (OWLOntology ont : man.getOntologies()) {
            boolean bl = in = in && ql.checkOntology(ont).isInProfile();
            if (!in) break;
        }
        if (in) {
            this.languages.add(OWLLanguage.OWL2QL);
        }
        in = true;
        for (OWLOntology ont : man.getOntologies()) {
            boolean bl = in = in && el.checkOntology(ont).isInProfile();
            if (!in) break;
        }
        if (in) {
            this.languages.add(OWLLanguage.OWL2EL);
        }
        in = true;
        for (OWLOntology ont : man.getOntologies()) {
            boolean bl = in = in && rl.checkOntology(ont).isInProfile();
            if (!in) break;
        }
        if (in) {
            this.languages.add(OWLLanguage.OWL2RL);
        }
        in = true;
        for (OWLOntology ont : man.getOntologies()) {
            boolean bl = in = in && dl.checkOntology(ont).isInProfile();
            if (!in) break;
        }
        if (in) {
            this.languages.add(OWLLanguage.OWL2DL);
        }
    }

    public OWL2ProfileChecker() {
        super(OWLLanguage.OWL2EL, OWLLanguage.OWL2QL, OWLLanguage.OWL2RL, OWLLanguage.OWL2DL);
    }

    @Override
    public String getGroupName() {
        return "OWL 2 Profiles " + this.getLanguageNames();
    }
}

