/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owl.rel.util;

public class Timer {
    private boolean started;
    private String name;
    private long startTime;
    private long lastTime;
    private long totalTime;
    private int count;

    public Timer(String n) {
        this.name = n;
        this.reset();
    }

    public void reset() {
        this.started = false;
        this.totalTime = 0L;
        this.startTime = 0L;
        this.lastTime = 0L;
        this.count = 0;
    }

    public void start() {
        if (!this.started) {
            this.startTime = System.currentTimeMillis();
            this.started = true;
        }
        ++this.count;
    }

    public void stop() {
        if (this.started) {
            this.lastTime = System.currentTimeMillis() - this.startTime;
            this.totalTime += this.lastTime;
            this.started = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public double getTotal() {
        return (double)this.totalTime / 1000.0;
    }

    public double getAverage() {
        return (double)this.totalTime / (double)this.count;
    }

    public long getLast() {
        return this.lastTime;
    }

    public String toString() {
        if (this.count > 1) {
            return String.valueOf(this.name) + " Avg: " + this.getAverage() + " Count: " + this.count + " Total: " + this.getTotal() + " s";
        }
        return String.valueOf(this.name) + " Total: " + this.getTotal() + " s";
    }
}

