/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owl.api3;

import eu.trowl.db.DB;
import eu.trowl.db.DBFactory;
import eu.trowl.owl.api3.Reasoner;
import eu.trowl.owl.api3.ReasonerBase;
import eu.trowl.util.Settings;
import eu.trowl.util.Types;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.util.Version;

public class DLReasoner
extends ReasonerBase
implements Reasoner {
    private OWLReasoner pellet;
    private Set<OWLOntology> onts;
    private boolean dirty = false;
    private boolean allConsistent = true;

    @Override
    public void load(OWLOntologyManager man) {
        try {
            this.manager = man;
            OWLReasonerFactory fact = (OWLReasonerFactory)Class.forName(Settings.get("trowl.DLReasonerFactory")).newInstance();
            this.pellet = fact.createReasoner((OWLOntology)this.manager.getOntologies().iterator().next());
            for (OWLOntology ont : man.getOntologies()) {
                this.onts.addAll(man.getImportsClosure(ont));
            }
            if (!this.pellet.isConsistent()) {
                this.allConsistent = false;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void store() {
        try {
            DB db = DBFactory.construct();
            this.store(db);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void store(String repository) {
        try {
            DB db = DBFactory.construct(repository);
            this.store(db);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void storeNegative() {
        try {
            DB db = DBFactory.construct();
            this.storeNegative(db);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void storeNegative(String repository) {
        try {
            DB db = DBFactory.construct(repository);
            this.storeNegative(db);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void storeNegative(DB repository) {
        for (OWLOntology ont : this.onts) {
            for (OWLClass c : ont.getClassesInSignature()) {
                try {
                    IRI invUri = IRI.create((String)("urn:class:inverse:" + c.getIRI()));
                    OWLClass inv = this.manager.getOWLDataFactory().getOWLClass(invUri);
                    OWLDisjointClassesAxiom ax = this.manager.getOWLDataFactory().getOWLDisjointClassesAxiom(new OWLClassExpression[]{c, inv});
                    this.manager.addAxiom(ont, (OWLAxiom)ax);
                    this.dirty = true;
                }
                catch (OWLOntologyChangeException ex) {
                    Logger.getLogger(DLReasoner.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.reload();
        this.store(repository);
    }

    @Override
    public void store(DB repository) {
        if (this.dirty) {
            this.reload();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean allConsistent() {
        if (this.dirty) {
            this.reload();
        }
        return this.allConsistent;
    }

    @Override
    public boolean allSatisfiable() {
        if (this.dirty) {
            this.reload();
        }
        return this.getUnsatisfiable().isEmpty();
    }

    @Override
    public Set<OWLClass> getUnsatisfiable() {
        if (this.dirty) {
            this.reload();
        }
        Set<OWLClass> unsatisfiable = Types.newSet();
        return unsatisfiable;
    }

    private void closeDirect(OWLClass c) {
    }

    @Override
    public void closeTree(OWLClass c) {
        for (OWLClass toClose : this.pellet.getSubClasses((OWLClassExpression)c, false).getFlattened()) {
            this.closeDirect(toClose);
        }
    }

    @Override
    public void close(OWLClass c) {
        this.closeDirect(c);
    }

    @Override
    public void close(OWLObjectProperty p) {
        this.closeDirect(p);
    }

    @Override
    public void closeTree(OWLObjectProperty p) {
        for (OWLObjectPropertyExpression toClose : this.pellet.getSubObjectProperties((OWLObjectPropertyExpression)p, true).getFlattened()) {
            if (toClose.isAnonymous()) continue;
            this.closeDirect(toClose.asOWLObjectProperty());
        }
    }

    private void closeDirect(OWLObjectProperty p) {
        OWLDataFactory fact = this.manager.getOWLDataFactory();
        throw new UnsupportedOperationException();
    }

    @Override
    public void reload() {
        this.pellet.dispose();
        this.load(this.manager);
        this.dirty = false;
    }

    @Override
    public Set<OWLAxiom> justify(OWLAxiom ax) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<OWLAxiom> justify(Set<OWLAxiom> axes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void setupExplanation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<OWLAxiom> justifySatisfiable(OWLClassExpression c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Class promoteTo() {
        return null;
    }

    @Override
    public OWLOntologyManager getManager() {
        return this.manager;
    }

    @Override
    public Set<OWLAxiom> justifyInconsistent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Set<OWLAxiom>> justifyInconsistentAll() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Set<OWLAxiom>> justifyAll(OWLAxiom ax) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Set<OWLAxiom>> justifySatisfiableAll(OWLClassExpression c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OWLDataFactory getDataFactory() {
        return this.manager.getOWLDataFactory();
    }

    @Override
    public Object getUnderlyingReasoner() {
        return this.pellet;
    }

    public boolean isSatisfiable(OWLClassExpression owlce) throws ReasonerInterruptedException {
        return this.pellet.isSatisfiable(owlce);
    }

    public boolean isEntailmentCheckingSupported(AxiomType at) {
        return this.pellet.isEntailmentCheckingSupported(at);
    }

    public boolean isEntailed(OWLAxiom owla) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException {
        return this.pellet.isEntailed(owla);
    }

    public boolean isConsistent() throws ReasonerInterruptedException {
        return this.pellet.isConsistent();
    }

    public void interrupt() {
        this.pellet.interrupt();
    }

    public void precomputeInferences(InferenceType ... its) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        this.pellet.precomputeInferences(its);
    }

    public boolean isPrecomputed(InferenceType it) {
        return this.pellet.isPrecomputed(it);
    }

    public boolean isEntailed(Set<? extends OWLAxiom> set) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return this.pellet.isEntailed(set);
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        return this.pellet.getUnsatisfiableClasses();
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual owlni, boolean bln) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getTypes(owlni, bln);
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.pellet.getTopObjectPropertyNode();
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return this.pellet.getTopDataPropertyNode();
    }

    public Node<OWLClass> getTopClassNode() {
        return this.pellet.getTopClassNode();
    }

    public long getTimeOut() {
        return this.pellet.getTimeOut();
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression owlope, boolean bln) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getSuperObjectProperties(owlope, bln);
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty owldp, boolean bln) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getSuperDataProperties(owldp, bln);
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression owlce, boolean bln) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getSuperClasses(owlce, bln);
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression owlope, boolean bln) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getSubObjectProperties(owlope, bln);
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty owldp, boolean bln) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getSubDataProperties(owldp, bln);
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression owlce, boolean bln) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        return this.pellet.getSubClasses(owlce, bln);
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual owlni) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getSameIndividuals(owlni);
    }

    public OWLOntology getRootOntology() {
        return this.pellet.getRootOntology();
    }

    public Version getReasonerVersion() {
        return this.pellet.getReasonerVersion();
    }

    public String getReasonerName() {
        return this.pellet.getReasonerName();
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return this.pellet.getPrecomputableInferenceTypes();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return this.pellet.getPendingChanges();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return this.pellet.getPendingAxiomRemovals();
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return this.pellet.getPendingAxiomAdditions();
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual owlni, OWLObjectPropertyExpression owlope) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getObjectPropertyValues(owlni, owlope);
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression owlope, boolean bln) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getObjectPropertyRanges(owlope, bln);
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression owlope, boolean bln) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getObjectPropertyDomains(owlope, bln);
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression owlope) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getInverseObjectProperties(owlope);
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression owlce, boolean bln) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getInstances(owlce, bln);
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.pellet.getIndividualNodeSetPolicy();
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.pellet.getFreshEntityPolicy();
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression owlope) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getEquivalentObjectProperties(owlope);
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty owldp) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getEquivalentDataProperties(owldp);
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression owlce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getEquivalentClasses(owlce);
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression owlope) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getDisjointObjectProperties(owlope);
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression owldpe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getDisjointDataProperties(owldpe);
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression owlce) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        return this.pellet.getDisjointClasses(owlce);
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual owlni) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getDifferentIndividuals(owlni);
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual owlni, OWLDataProperty owldp) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getDataPropertyValues(owlni, owldp);
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty owldp, boolean bln) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.pellet.getDataPropertyDomains(owldp, bln);
    }

    public BufferingMode getBufferingMode() {
        return this.pellet.getBufferingMode();
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.pellet.getBottomObjectPropertyNode();
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.pellet.getBottomDataPropertyNode();
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.pellet.getBottomClassNode();
    }

    public void flush() {
        this.pellet.flush();
    }

    public void dispose() {
        this.pellet.dispose();
    }
}

