/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.loader;

import eu.trowl.db.SQLBuilder;
import eu.trowl.loader.Loader;
import eu.trowl.loader.LoaderInitException;
import eu.trowl.owl.OntologyLoadException;
import eu.trowl.owl.api3.ReasonerFactory;
import eu.trowl.util.Types;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.ReaderDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class OWLDLLoader
extends Loader {
    public static final String ID = "TROWL_LOADER_OWLDL";
    public static final boolean THREAD_SAFE = false;
    private OWLReasoner reasoner;
    private OWLOntologyManager manager;
    private OWLOntology ont;
    private ArrayList<OWLClass> classes;
    private ArrayList<OWLObjectProperty> objectProperties;
    private OWLClass nothing;

    @Override
    public void init() throws LoaderInitException {
        try {
            this.manager = OWLManager.createOWLOntologyManager();
            ReaderDocumentSource readerInput = new ReaderDocumentSource((Reader)this.in);
            this.ont = this.manager.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)readerInput);
            this.nameRestrictions();
            this.objectProperties = new ArrayList();
            ReasonerFactory rf = new ReasonerFactory();
            this.reasoner = rf.load(this.manager);
            this.nothing = this.manager.getOWLDataFactory().getOWLNothing();
        }
        catch (OntologyLoadException ex) {
            LoaderInitException e = new LoaderInitException();
            e.initCause(ex);
            throw e;
        }
        catch (URISyntaxException ex) {
            LoaderInitException e = new LoaderInitException();
            e.initCause(ex);
            throw e;
        }
        catch (OWLOntologyChangeException ex) {
            LoaderInitException e = new LoaderInitException();
            e.initCause(ex);
            throw e;
        }
        catch (OWLOntologyCreationException ex) {
            LoaderInitException e = new LoaderInitException();
            e.initCause(ex);
            throw e;
        }
    }

    @Override
    public void run() {
        this.go(0);
    }

    public void go(int completenessLevels) {
        try {
            this.reasoner.precomputeInferences(new InferenceType[]{InferenceType.CLASS_HIERARCHY});
            if (!this.reasoner.isConsistent()) {
                throw new RuntimeException("Submitted ontology is not consistent");
            }
            this.getClasses(this.out, this.manager.getOWLDataFactory().getOWLThing());
            this.getObjectProperties(this.out);
            this.getDatatypeProperties(this.out);
            this.getInstances(this.out);
            this.getPropertyInstances(this.out);
            if (completenessLevels > 1) {
                this.getCompleteness(completenessLevels);
            }
            this.stopTimer();
        }
        catch (Exception ex) {
            Logger.getLogger(OWLDLLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void nameRestrictions() throws URISyntaxException, OWLOntologyChangeException {
        OWLDataFactory factory = this.manager.getOWLDataFactory();
        for (OWLObjectProperty o : this.ont.getObjectPropertiesInSignature()) {
            IRI newClassIRI = IRI.create((String)("urn:class:" + SQLBuilder.getPathHash(o.getIRI().toString())));
            OWLClass newClass = factory.getOWLClass(newClassIRI);
            this.manager.addAxiom(this.ont, (OWLAxiom)factory.getOWLEquivalentClassesAxiom((OWLClassExpression)factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)o, (OWLClassExpression)factory.getOWLThing()), (OWLClassExpression)newClass));
            newClassIRI = IRI.create((String)("urn:class:" + SQLBuilder.getPathHash("neg:" + o.getIRI().toString())));
            newClass = factory.getOWLClass(newClassIRI);
            this.manager.addAxiom(this.ont, (OWLAxiom)factory.getOWLEquivalentClassesAxiom((OWLClassExpression)factory.getOWLObjectSomeValuesFrom(o.getInverseProperty(), (OWLClassExpression)factory.getOWLThing()), (OWLClassExpression)newClass));
        }
    }

    public void getClasses(SQLBuilder sql, OWLClass cur) {
        try {
            sql.createClass(cur.getIRI().toURI());
            for (Node subs : this.reasoner.getSubClasses((OWLClassExpression)cur, true)) {
                for (OWLClass sub : subs) {
                    if (sub.equals(cur) || sub.equals(this.nothing)) continue;
                    sql.setSubClassOf(cur.getIRI().toURI(), sub.getIRI().toURI());
                    this.getClasses(sql, sub);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OWLDLLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void finish() {
        try {
            this.reasoner.dispose();
        }
        catch (Exception ex) {
            Logger.getLogger(OWLDLLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.out.storePaths();
        this.out.rebuildIndices();
        this.out.close();
    }

    public void getObjectProperties(SQLBuilder sql) {
        for (OWLObjectProperty p : this.ont.getObjectPropertiesInSignature()) {
            try {
                sql.createObjectProperty(p.getIRI().toURI());
                for (Node subs : this.reasoner.getSubObjectProperties((OWLObjectPropertyExpression)p, true)) {
                    for (OWLObjectPropertyExpression sub : subs) {
                        if (sub.isAnonymous()) continue;
                        OWLObjectProperty pr = sub.asOWLObjectProperty();
                        sql.setSubPropertyOf(p.getIRI().toURI(), pr.getIRI().toURI());
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(OWLDLLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void getDatatypeProperties(SQLBuilder sql) {
        for (OWLDataProperty p : this.ont.getDataPropertiesInSignature()) {
            try {
                sql.createDatatypeProperty(p.getIRI().toURI());
                for (Node subs : this.reasoner.getSubDataProperties(p, true)) {
                    for (OWLDataProperty sub : subs) {
                        sql.setSubPropertyOf(p.getIRI().toURI(), sub.getIRI().toURI());
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(OWLDLLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void getInstances(SQLBuilder sql) {
        for (OWLClass c : this.ont.getClassesInSignature()) {
            try {
                for (Node n : this.reasoner.getInstances((OWLClassExpression)c, true)) {
                    for (OWLNamedIndividual i : n) {
                        sql.createIndividual(i.getIRI().toURI(), c.getIRI().toURI());
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(OWLDLLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void getObjectPropertyInstancesNoReasoner(SQLBuilder sql) throws Exception {
        for (OWLNamedIndividual subject : this.ont.getIndividualsInSignature()) {
            for (OWLObjectPropertyAssertionAxiom a : this.ont.getObjectPropertyAssertionAxioms((OWLIndividual)subject)) {
                OWLObjectProperty property = ((OWLObjectPropertyExpression)a.getProperty()).getNamedProperty();
                OWLIndividual object = (OWLIndividual)a.getObject();
                if (object.isAnonymous()) continue;
                sql.createObjectPropertyInstance(subject.getIRI().toURI(), property.getIRI().toURI(), object.asOWLNamedIndividual().getIRI().toURI());
            }
        }
    }

    private void getPropertyInstances(SQLBuilder sql) {
        for (OWLNamedIndividual subject : this.ont.getIndividualsInSignature()) {
            for (OWLDataProperty dp : this.ont.getDataPropertiesInSignature()) {
                try {
                    Set values = this.reasoner.getDataPropertyValues(subject, dp);
                    for (OWLLiteral v : values) {
                        sql.createDatatypePropertyInstance(subject.getIRI().toURI(), dp.getIRI().toURI(), v.getLiteral(), "");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private Set<OWLNamedIndividual> getIndividuals() {
        Set<OWLNamedIndividual> i = Types.newSet();
        Set done = Types.newSet();
        for (OWLOntology ground : this.manager.getOntologies()) {
            for (OWLOntology o : this.manager.getImportsClosure(ground)) {
                if (done.contains(o)) continue;
                i.addAll(o.getIndividualsInSignature());
            }
        }
        return i;
    }

    private Set<OWLClass> getClasses() {
        Set<OWLClass> i = Types.newSet();
        Set done = Types.newSet();
        for (OWLOntology ground : this.manager.getOntologies()) {
            for (OWLOntology o : this.manager.getImportsClosure(ground)) {
                if (done.contains(o)) continue;
                i.addAll(o.getClassesInSignature());
                done.add(o);
            }
        }
        return i;
    }

    private Set<OWLObjectProperty> getObjectProperties() {
        Set<OWLObjectProperty> i = Types.newSet();
        Set done = Types.newSet();
        for (OWLOntology ground : this.manager.getOntologies()) {
            for (OWLOntology o : this.manager.getImportsClosure(ground)) {
                if (done.contains(o)) continue;
                i.addAll(o.getObjectPropertiesInSignature());
                done.add(o);
            }
        }
        return i;
    }

    private Set<OWLDataProperty> getDataProperties() {
        Set<OWLDataProperty> i = Types.newSet();
        Set done = Types.newSet();
        for (OWLOntology ground : this.manager.getOntologies()) {
            for (OWLOntology o : this.manager.getImportsClosure(ground)) {
                if (done.contains(o)) continue;
                i.addAll(o.getDataPropertiesInSignature());
                done.add(o);
            }
        }
        return i;
    }

    private void getCompleteness(int level) {
        for (OWLObjectProperty predicate : this.getObjectProperties()) {
            this.followRole(level, 0, (OWLObjectPropertyExpression)predicate, (OWLClassExpression)this.manager.getOWLDataFactory().getOWLThing(), "T");
        }
        for (OWLObjectProperty predicate : this.getObjectProperties()) {
            this.followRole(level, 0, (OWLObjectPropertyExpression)this.manager.getOWLDataFactory().getOWLObjectInverseOf((OWLObjectPropertyExpression)predicate), (OWLClassExpression)this.manager.getOWLDataFactory().getOWLThing(), "T");
        }
    }

    private void followRole(int maxLevel, int level, OWLObjectPropertyExpression role, OWLClassExpression stem, String name) {
        if (++level <= maxLevel) {
            OWLObjectSomeValuesFrom newStem = this.manager.getOWLDataFactory().getOWLObjectSomeValuesFrom(role, stem);
            OWLObjectProperty namedRole = null;
            try {
                namedRole = role.asOWLObjectProperty();
            }
            catch (Exception e) {
                try {
                    namedRole = ((OWLObjectInverseOf)role).getInverse().asOWLObjectProperty();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (this.reasoner.isSatisfiable((OWLClassExpression)newStem)) {
                    NodeSet is = this.reasoner.getInstances((OWLClassExpression)newStem, false);
                    String fname = String.valueOf(namedRole.getIRI().getFragment()) + "." + name;
                    if (!is.isEmpty()) {
                        for (Node node : is) {
                        }
                        for (OWLObjectProperty predicate : this.getObjectProperties()) {
                            this.followRole(maxLevel, level, (OWLObjectPropertyExpression)predicate, (OWLClassExpression)newStem, fname);
                        }
                    }
                }
                newStem = this.manager.getOWLDataFactory().getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.manager.getOWLDataFactory().getOWLObjectInverseOf(role), stem);
            }
            catch (Exception e) {
                System.out.println("Reasoner choked, continuing...");
            }
        }
    }
}

