/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.loader;

import eu.trowl.loader.RDFLoader;
import eu.trowl.rdf.NTripleReader;
import eu.trowl.rdf.RDFHandler;
import eu.trowl.rdf.Triple;
import eu.trowl.vocab.OWLRDF;
import eu.trowl.vocab.RDF;
import eu.trowl.vocab.RDFS;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NTripleMemLoader
extends RDFLoader {
    public static final String ID = "TROWL_LOADER_NTRIPLE";
    private URI base;
    public static final boolean THREAD_SAFE = true;

    @Override
    public void init() {
        this.out.init();
    }

    @Override
    public void run() {
        NTripleReader reader = new NTripleReader();
        reader.read((RDFHandler)this, this.in, this.base);
        this.out.close();
    }

    public void setBase(String uri) {
        try {
            this.out.setURI(new URI(uri));
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(NTripleMemLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void setBase(URI uri) {
        this.base = uri;
    }

    @Override
    public void processTriple(Triple t) {
        if (t.isType()) {
            if (t.getObject().sameAs(RDFS.CLASS) || t.getObject().equals(OWLRDF.CLASS)) {
                this.out.createClass(t.getSubject().getURI());
            } else if (!(t.getObject().sameAs(RDF.PROPERTY) || t.getObject().sameAs(OWLRDF.OBJECT_PROPERTY) || t.getObject().sameAs(OWLRDF.DATATYPE_PROPERTY))) {
                this.out.createIndividual(t.getSubject().getURI(), t.getObject().getURI());
            }
        } else if (t.isSubClass()) {
            this.out.setSubClassOf(t.getSubject().getURI(), t.getObject().getURI());
        } else if (t.isSubProperty()) {
            this.out.setSubPropertyOf(t.getSubject().getURI(), t.getObject().getURI());
        } else if (!t.isTBox()) {
            if (t.getObject().isResource()) {
                this.out.createObjectPropertyInstance(t.getSubject().getURI(), t.getPredicate().getURI(), t.getObject().getURI());
            } else {
                this.out.createDatatypePropertyInstance(t.getSubject().getURI(), t.getPredicate().getURI(), t.getObject().toString(), t.getObject().getLang());
            }
        }
    }

    @Override
    public void finish() {
        this.out.close();
    }
}

