/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.loader;

import eu.trowl.db.DB;
import eu.trowl.db.DBFactory;
import eu.trowl.db.OntologyMeta;
import eu.trowl.db.SQLBuilder;
import eu.trowl.loader.Loader;
import eu.trowl.loader.NTripleLoader;
import eu.trowl.loader.ThreadSafeLoader;
import eu.trowl.util.Types;
import java.io.BufferedReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoaderFactory {
    private List<Thread> workers;
    private Loader last;
    private Long startTime;
    private String base;
    private Set<String> oldBases;
    private Class loaderType = null;
    private static final Class DEFAULT_LOADER_TYPE = NTripleLoader.class;

    public LoaderFactory() {
        this.init();
    }

    public LoaderFactory(String base) {
        this.base = base;
        this.init();
    }

    private void init() {
        this.workers = new ArrayList<Thread>();
        this.oldBases = new HashSet<String>();
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setLoader(Class loaderClass) {
        if (Loader.class.isAssignableFrom(loaderClass)) {
            this.loaderType = loaderClass;
        } else {
            System.out.println("Incorrect loader type selected, using default");
        }
    }

    public void createLoader(Reader input, int number, String repository, String uri) {
        this.base = uri;
        this.createLoader(input, number, repository);
    }

    public void createLoader(Reader input, int number, String repository) {
        BufferedReader r = new BufferedReader(input);
        if (this.loaderType == null) {
            this.loaderType = DEFAULT_LOADER_TYPE;
        }
        OntologyMeta m = new OntologyMeta();
        Loader worker = null;
        List<Thread> newWorkers = Types.newList();
        if (!this.loaderType.isAssignableFrom(ThreadSafeLoader.class)) {
            number = 1;
        }
        if (number < 1) {
            number = 1;
        }
        if (this.base == null) {
            this.base = "http://www.trowl.eu/example/";
        }
        DB db = null;
        try {
            db = DBFactory.construct(repository);
            int i = 0;
            while (i < number) {
                try {
                    SQLBuilder builder = new SQLBuilder(db, new URI(this.base), m);
                    if (this.oldBases.contains(this.base)) {
                        this.oldBases.add(this.base);
                    }
                    worker = (Loader)this.loaderType.newInstance();
                    worker.setLoaderBase(URI.create(this.base));
                    worker.setIn(r);
                    worker.setOut(builder);
                    worker.init();
                    Thread t = new Thread(worker);
                    newWorkers.add(t);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(LoaderFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(LoaderFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(LoaderFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.last = worker;
        this.startTime = System.currentTimeMillis();
        for (Thread t : newWorkers) {
            t.start();
            this.workers.add(t);
        }
    }

    public void waitAll() {
        try {
            for (Thread t : this.workers) {
                if (!t.isAlive()) continue;
                t.join();
            }
            this.last.finish();
            System.out.println("Elapsed time: " + (System.currentTimeMillis() - this.startTime));
        }
        catch (InterruptedException ex) {
            return;
        }
    }
}

