/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.loader;

import eu.trowl.db.DB;
import eu.trowl.db.SQLBuilder;
import eu.trowl.loader.LoaderInitException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public abstract class Loader
implements Runnable {
    public static final String ID = "LOADER";
    public static final boolean THREAD_SAFE = false;
    protected BufferedReader in;
    protected DB db;
    protected SQLBuilder out;
    protected static Set<Loader> workers = new HashSet<Loader>();
    private Long elapsed;
    private Long start;
    protected URI loaderBase;

    public void setLoaderBase(URI base) {
        this.loaderBase = base;
    }

    public Loader(Reader in, SQLBuilder out) {
        this.in = new BufferedReader(in);
        this.out = out;
    }

    protected static String readToString(BufferedReader input) throws IOException {
        int readCount;
        StringBuilder data = new StringBuilder(1000);
        char[] buf = new char[1024];
        while ((readCount = input.read(buf)) != -1) {
            data.append(buf, 0, readCount);
        }
        return data.toString();
    }

    public Loader() {
    }

    public void setIn(BufferedReader in) {
        this.in = in;
    }

    public void setOut(SQLBuilder out) {
        this.out = out;
    }

    public abstract void init() throws LoaderInitException;

    @Override
    public abstract void run();

    public abstract void finish();

    public Long getElapsedTime() {
        if (this.elapsed != null) {
            return this.elapsed;
        }
        if (this.start != null) {
            return new Long(System.currentTimeMillis() - this.start);
        }
        return new Long(0L);
    }

    public void startTimer() {
        this.start = System.currentTimeMillis();
    }

    public void stopTimer() {
        if (this.start != null) {
            this.elapsed = System.currentTimeMillis() - this.start;
        }
    }
}

