/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.jena;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import eu.trowl.jena.TrOWLInfGraph;
import eu.trowl.jena.TrOWLJenaFactory;
import java.util.logging.Logger;

public class TrOWLJenaReasoner
implements Reasoner {
    protected static Logger log = Logger.getLogger(TrOWLJenaReasoner.class.getName());
    private Model reasonerCapabilities;
    private Capabilities graphCapabilities;
    private Graph schema;

    public TrOWLJenaReasoner() {
        this(null, TrOWLJenaFactory.theInstance().getCapabilities());
    }

    public TrOWLJenaReasoner(Graph schema) {
        this(schema, TrOWLJenaFactory.theInstance().getCapabilities());
    }

    protected TrOWLJenaReasoner(Model reasonerCapabilities) {
        this(null, reasonerCapabilities);
    }

    protected TrOWLJenaReasoner(Graph schema, Model reasonerCapabilities) {
        this.schema = schema;
        this.reasonerCapabilities = reasonerCapabilities;
        this.graphCapabilities = new BaseInfGraph.InfFindSafeCapabilities();
    }

    public Graph getSchema() {
        return this.schema;
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        return new TrOWLJenaReasoner(graph, this.reasonerCapabilities);
    }

    public Reasoner bindSchema(Model model) throws ReasonerException {
        return this.bindSchema(model.getGraph());
    }

    public TrOWLInfGraph bind(Graph graph) throws ReasonerException {
        log.fine("In bind!");
        return new TrOWLInfGraph(graph, this);
    }

    public InfModel bind(Model model) throws ReasonerException {
        log.fine("In bind!");
        return ModelFactory.createInfModel((InfGraph)this.bind(model.getGraph()));
    }

    public void setDerivationLogging(boolean enable) {
    }

    public void setParameter(Property arg0, Object arg1) {
    }

    public Model getReasonerCapabilities() {
        return this.reasonerCapabilities;
    }

    public Capabilities getGraphCapabilities() {
        return this.graphCapabilities;
    }

    public void addDescription(Model arg0, Resource arg1) {
    }

    public boolean supportsProperty(Property property) {
        Model caps = this.getReasonerCapabilities();
        if (caps == null) {
            return false;
        }
        return caps.contains(null, ReasonerVocabulary.supportsP, (RDFNode)property);
    }
}

