/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.db;

import eu.trowl.db.Queries;
import eu.trowl.util.Settings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public abstract class DB {
    protected String dbDriver;
    protected String database;
    protected Connection dbCon;
    protected Statement stmt;

    public DB(String repo) {
        this.database = String.valueOf(Settings.get("Database.RepositoryPrefix")) + repo;
    }

    public void setRepository(String repo) {
        this.database = String.valueOf(Settings.get("Database.RepositoryPrefix")) + repo;
    }

    public DB() {
        this.database = String.valueOf(Settings.get("Database.RepositoryPrefix")) + Settings.get("Database.DefaultRepository");
    }

    public boolean connect(String dbName) throws Exception {
        this.database = dbName;
        return this.connect();
    }

    public abstract boolean connect() throws Exception;

    public void close() {
        if (this.dbCon != null) {
            try {
                this.dbCon.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void commit() throws SQLException {
        this.dbCon.commit();
    }

    public void setAutoCommit(boolean autocommit) throws SQLException {
        this.dbCon.setAutoCommit(autocommit);
    }

    public void rollback() throws SQLException {
        this.dbCon.rollback();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement s = this.dbCon.prepareStatement(sql);
        return s;
    }

    public Statement createStatement() throws SQLException {
        Statement s = this.dbCon.createStatement();
        return s;
    }

    protected Statement getStatement() throws SQLException {
        if (this.stmt == null) {
            this.stmt = this.createStatement();
        }
        return this.stmt;
    }

    public int executeUpdate(String s) throws SQLException {
        int count = this.createStatement().executeUpdate(s);
        return count;
    }

    public ResultSet execSQL(String sql) throws SQLException {
        Statement s = this.dbCon.createStatement();
        ResultSet rs = null;
        rs = s.executeQuery(sql);
        return rs;
    }

    public boolean execute(String s) throws SQLException {
        return this.getStatement().execute(s);
    }

    public ResultSet execSQL(StringBuffer sql) throws SQLException {
        return this.execSQL(sql.toString());
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public void setDbDriver(String newValue) {
        this.dbDriver = newValue;
    }

    public void checkTables() {
        int i = 0;
        String[] types = new String[]{"TABLE"};
        ArrayList<String> tablesFound = new ArrayList<String>();
        try {
            ResultSet tabRS = this.dbCon.getMetaData().getTables(null, null, "%", types);
            while (tabRS.next()) {
                tablesFound.add(tabRS.getString("TABLE_NAME").toUpperCase());
            }
        }
        catch (SQLException ex) {
            System.err.print("Error checking tables exist");
        }
        String[] stringArray = Queries.TABLES;
        int n = Queries.TABLES.length;
        int n2 = 0;
        while (n2 < n) {
            String table = stringArray[n2];
            if (!tablesFound.contains(table.toUpperCase())) {
                try {
                    this.execute(Queries.CREATE_TABLES[i]);
                }
                catch (SQLException ex) {
                    System.err.println("Unable to create table: " + table);
                    ex.printStackTrace();
                    System.exit(1);
                }
            }
            ++i;
            ++n2;
        }
        stringArray = Queries.CREATE_INDEXES;
        n = Queries.CREATE_INDEXES.length;
        n2 = 0;
        while (n2 < n) {
            String query = stringArray[n2];
            try {
                this.execute(query);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public List<String> queryAtomicList(String qry, String param) throws SQLException {
        PreparedStatement s = this.dbCon.prepareStatement(qry);
        s.setString(1, param);
        ResultSet r = s.executeQuery();
        r.next();
        ArrayList<String> results = new ArrayList<String>();
        try {
            int i = 0;
            while (i < r.getMetaData().getColumnCount()) {
                results.add(r.getString(i + 1));
                ++i;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return results;
    }

    public String queryAtomic(String qry, String param) throws SQLException {
        PreparedStatement s = this.dbCon.prepareStatement(qry);
        s.setString(1, param);
        ResultSet r = s.executeQuery();
        r.next();
        try {
            return r.getString(1);
        }
        catch (SQLException e) {
            return "";
        }
    }

    public String queryAtomic(String qry, Long param) throws SQLException {
        PreparedStatement s = this.dbCon.prepareStatement(qry);
        s.setLong(1, param);
        ResultSet r = s.executeQuery();
        r.next();
        try {
            return r.getString(1);
        }
        catch (SQLException e) {
            return "";
        }
    }

    public String queryAtomic(String qry) throws SQLException {
        PreparedStatement s = this.prepareStatement(qry);
        ResultSet r = s.executeQuery();
        r.next();
        try {
            return r.getString(1);
        }
        catch (SQLException e) {
            System.out.print("Atomic Query Failed: " + e.getMessage());
            return "";
        }
    }

    public String getClassPath(String uri) throws SQLException {
        return this.queryAtomic("SELECT path FROM classpaths, classes WHERE classpaths.class_id=classes.id AND classes.uri=?", uri);
    }

    public String getPropertyPath(String uri) throws SQLException {
        return this.queryAtomic("SELECT path, type FROM propertypaths, (SELECT id, uri FROM oproperties UNION SELECT id, uri FROM dproperties) as properties  WHERE propertypaths.property_id=properties.id AND properties.uri=?", uri);
    }
}

