/*
 * Decompiled with CFR 0.152.
 */
package com.truemesh.squiggle.criteria;

import com.truemesh.squiggle.Column;
import com.truemesh.squiggle.Criteria;
import com.truemesh.squiggle.Matchable;
import com.truemesh.squiggle.Table;
import com.truemesh.squiggle.literal.BooleanLiteral;
import com.truemesh.squiggle.literal.FloatLiteral;
import com.truemesh.squiggle.literal.IntegerLiteral;
import com.truemesh.squiggle.literal.StringLiteral;
import com.truemesh.squiggle.output.Output;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;

public class MatchCriteria
extends Criteria {
    public static final String EQUALS = "=";
    public static final String GREATER = ">";
    public static final String GREATEREQUAL = ">=";
    public static final String LESS = "<";
    public static final String LESSEQUAL = "<=";
    public static final String LIKE = "LIKE";
    public static final String NOTEQUAL = "<>";
    private final Matchable left;
    private final String operator;
    private final Matchable right;

    public MatchCriteria(Matchable left, String operator, Matchable right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public MatchCriteria(Column column, String matchType, boolean value) {
        this((Matchable)column, matchType, new BooleanLiteral(value));
    }

    public MatchCriteria(Column column, String operator, Date operand) {
        this(column, operator, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S").format(operand));
    }

    public MatchCriteria(Column column, String matchType, double value) {
        this((Matchable)column, matchType, new FloatLiteral(value));
    }

    public MatchCriteria(Column column, String matchType, long value) {
        this((Matchable)column, matchType, new IntegerLiteral(value));
    }

    public MatchCriteria(Column column, String matchType, String value) {
        this((Matchable)column, matchType, new StringLiteral(value));
    }

    public MatchCriteria(Table table, String columnname, String matchType, boolean value) {
        this(table.getColumn(columnname), matchType, value);
    }

    public MatchCriteria(Table table, String columnName, String operator, Date operand) {
        this(table.getColumn(columnName), operator, operand);
    }

    public MatchCriteria(Table table, String columnname, String matchType, double value) {
        this(table.getColumn(columnname), matchType, value);
    }

    public MatchCriteria(Table table, String columnname, String matchType, long value) {
        this(table.getColumn(columnname), matchType, value);
    }

    public MatchCriteria(Table table, String columnname, String matchType, String value) {
        this(table.getColumn(columnname), matchType, value);
    }

    public Matchable getLeft() {
        return this.left;
    }

    public String getComparisonOperator() {
        return this.operator;
    }

    public Matchable getRight() {
        return this.right;
    }

    @Override
    public void write(Output out) {
        this.left.write(out);
        out.print(' ').print(this.operator).print(' ');
        this.right.write(out);
    }

    @Override
    public void addReferencedTablesTo(Set<Table> tables) {
        this.left.addReferencedTablesTo(tables);
        this.right.addReferencedTablesTo(tables);
    }
}

