/*
 * Decompiled with CFR 0.152.
 */
package com.truemesh.squiggle;

import com.truemesh.squiggle.Literal;
import com.truemesh.squiggle.ValueSet;
import com.truemesh.squiggle.literal.BigDecimalLiteral;
import com.truemesh.squiggle.literal.DateTimeLiteral;
import com.truemesh.squiggle.literal.FloatLiteral;
import com.truemesh.squiggle.literal.IntegerLiteral;
import com.truemesh.squiggle.literal.StringLiteral;
import com.truemesh.squiggle.output.Output;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class LiteralValueSet
implements ValueSet {
    private final Collection<Literal> literals;

    public LiteralValueSet(Collection<Literal> literals) {
        this.literals = literals;
    }

    public LiteralValueSet(String ... values) {
        this.literals = new ArrayList<Literal>(values.length);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.literals.add(new StringLiteral(value));
            ++n2;
        }
    }

    public LiteralValueSet(long ... values) {
        this.literals = new ArrayList<Literal>(values.length);
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long value = lArray[n2];
            this.literals.add(new IntegerLiteral(value));
            ++n2;
        }
    }

    public LiteralValueSet(double ... values) {
        this.literals = new ArrayList<Literal>(values.length);
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            this.literals.add(new FloatLiteral(value));
            ++n2;
        }
    }

    public LiteralValueSet(BigDecimal ... values) {
        this.literals = new ArrayList<Literal>(values.length);
        BigDecimal[] bigDecimalArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            BigDecimal value = bigDecimalArray[n2];
            this.literals.add(new BigDecimalLiteral(value));
            ++n2;
        }
    }

    public LiteralValueSet(Date ... values) {
        this.literals = new ArrayList<Literal>(values.length);
        Date[] dateArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Date value = dateArray[n2];
            this.literals.add(new DateTimeLiteral(value));
            ++n2;
        }
    }

    @Override
    public void write(Output out) {
        Iterator<Literal> it = this.literals.iterator();
        while (it.hasNext()) {
            Literal literal = it.next();
            literal.write(out);
            if (!it.hasNext()) continue;
            out.print(", ");
        }
    }
}

