/*
 * Decompiled with CFR 0.152.
 */
package trowl;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import eu.trowl.query.Query;
import eu.trowl.query.QueryFactory;
import eu.trowl.query.ResultSet;
import eu.trowl.query.ResultSetFormatter;
import eu.trowl.query.TextResultSetFormatter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

public class QueryTool {
    public static void main(String[] args) throws Exception {
        JSAPResult config = QueryTool.getArgs(args);
        String query = "";
        query = config.getString("query") != null ? config.getString("query") : QueryTool.readFileToString(new File(config.getString("file")));
        Query q = QueryFactory.create(query);
        ResultSet rs = q.execute(config.getString("repo"));
        TextResultSetFormatter f = new TextResultSetFormatter(rs);
        System.out.println(((ResultSetFormatter)f).format());
    }

    private static String readFileToString(File in) throws FileNotFoundException, IOException {
        StringBuffer out = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(in)));
        try {
            String buf;
            while ((buf = reader.readLine()) != null) {
                out.append(buf);
            }
        }
        finally {
            reader.close();
        }
        return out.toString();
    }

    private static JSAPResult getArgs(String[] args) throws Exception {
        SimpleJSAP jsap = new SimpleJSAP("trowl.Query", "Performs queries on a TrOWL knowledge base", new Parameter[]{new FlaggedOption("repo", (StringParser)JSAP.STRING_PARSER, "default", false, 'r', "repo", "The repository you wish to query"), new FlaggedOption("file", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'f', "file", "A file containing the query you wish to execute"), new UnflaggedOption("query", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "A SPARQL query to execute across the repository")});
        JSAPResult result = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        return result;
    }
}

