/*
 * Decompiled with CFR 0.152.
 */
package trowl;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import eu.trowl.query.sparql.endpoint.QueryServlet;
import eu.trowl.util.Log;
import eu.trowl.util.Settings;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class QueryServer {
    public static void main(String[] args) throws Exception {
        JSAPResult config = QueryServer.getArgs(args);
        Log.info("Starting server on port " + Settings.get("Server.Port"));
        Server server = new Server(Integer.parseInt(Settings.get("Server.Port")));
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new QueryServlet(config.getString("repo"))), "/*");
        server.start();
        server.join();
    }

    private static JSAPResult getArgs(String[] args) throws Exception {
        SimpleJSAP jsap = new SimpleJSAP("trowl.QueryServer", "A SPARQL endpoint for serving queries", new Parameter[]{new FlaggedOption("repo", (StringParser)JSAP.STRING_PARSER, Settings.get("Database.DefaultRepository"), false, 'r', "repo", "The repository you wish to query")});
        JSAPResult result = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        return result;
    }
}

