/*
 * Decompiled with CFR 0.152.
 */
package trowl;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import eu.trowl.TrOWLRuntimeException;
import eu.trowl.loader.LoaderFactory;
import eu.trowl.util.Settings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;

public class LoadTool {
    public static void main(String[] args) throws Exception {
        JSAPResult config = LoadTool.getArgs(args);
        String baseURI = null;
        System.out.println("Creating loader factory");
        LoaderFactory loaderFactory = new LoaderFactory();
        if (config.contains("uri")) {
            baseURI = config.getURL("uri").toString();
            loaderFactory.setBase(baseURI);
        }
        String[] stringArray = config.getStringArray("files");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String loaderName;
            InputStreamReader r;
            GZIPInputStream gz;
            FileInputStream in;
            String filename = stringArray[n2];
            File f = new File(filename);
            String extension = "";
            if (filename.endsWith(".gz")) {
                System.out.println("Opening GZip compressed stream");
                in = new FileInputStream(f);
                gz = new GZIPInputStream(in);
                r = new InputStreamReader(gz);
                extension = LoadTool.getExtension(LoadTool.stripExtension(filename));
            } else if (filename.endsWith(".bz2")) {
                System.out.println("Opening BZip2 compressed stream");
                in = new FileInputStream(f);
                gz = new CBZip2InputStream((InputStream)in);
                r = new InputStreamReader(gz);
                extension = LoadTool.getExtension(LoadTool.stripExtension(filename));
            } else {
                extension = LoadTool.getExtension(filename);
                System.out.println("Opening uncompressed stream");
                r = new FileReader(f);
            }
            try {
                loaderName = Settings.get("Loader.For." + extension);
            }
            catch (TrOWLRuntimeException ex) {
                loaderName = Settings.get("Loader.For._OTHER_");
            }
            System.out.println("Using loader " + loaderName);
            Class<?> loaderClass = Class.forName(loaderName);
            loaderFactory.setLoader(loaderClass);
            String currentURI = null;
            if (baseURI == null) {
                currentURI = f.toURI().toString();
                loaderFactory.createLoader(r, config.getShort("workers"), config.getString("repo"), currentURI);
            } else {
                loaderFactory.createLoader(r, config.getShort("workers"), config.getString("repo"), baseURI);
            }
            loaderFactory.waitAll();
            ++n2;
        }
    }

    private static JSAPResult getArgs(String[] args) throws Exception {
        SimpleJSAP jsap = new SimpleJSAP("trowl.Load", "Loads knowledge from RDF or OWL files into a TrOWL knowledge base", new Parameter[]{new FlaggedOption("workers", (StringParser)JSAP.SHORT_PARSER, "1", true, 'w', "workers", "The number of worker threads to initialise, may be overridden by non-thread-safe parsers."), new FlaggedOption("repo", (StringParser)JSAP.STRING_PARSER, "default", true, 'r', "repository", "The name of the TrOWL repository to use."), new FlaggedOption("uri", (StringParser)JSAP.URL_PARSER, JSAP.NO_DEFAULT, false, 'u', "uri", "The base URI to use, default is file:/// URI, or will be taken from RDFXML base: if present."), new UnflaggedOption("files", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "One or more names of files you would like to load.")});
        JSAPResult result = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        return result;
    }

    private static String getExtension(String in) {
        return in.substring(in.lastIndexOf(".") + 1).toLowerCase();
    }

    private static String stripExtension(String in) {
        return in.substring(0, in.lastIndexOf("."));
    }
}

