/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.rdf;

import eu.trowl.rdf.Node;
import eu.trowl.vocab.OWLRDF;
import eu.trowl.vocab.RDF;
import eu.trowl.vocab.RDFS;
import eu.trowl.vocab.TrOWL;

public class SPARQLTriple {
    protected Node subject;
    protected Node predicate;
    protected Node object;

    public SPARQLTriple() {
        this.subject = null;
        this.predicate = null;
        this.object = null;
    }

    public SPARQLTriple(Node s, Node p, Node o) {
        this.subject = s;
        this.predicate = p;
        this.object = o;
    }

    public Node getSubject() {
        return this.subject;
    }

    public Node getObject() {
        return this.object;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public boolean isType() {
        return RDF.TYPE.equals(this.predicate.getURI());
    }

    public boolean isFoundAt() {
        return TrOWL.FOUNDAT.equals(this.predicate.getURI());
    }

    public boolean isClass() {
        return this.isType() && (RDFS.CLASS.equals(this.object.getURI()) || OWLRDF.CLASS.equals(this.object.getURI()));
    }

    public boolean isProperty() {
        return this.isType() && (RDF.PROPERTY.equals(this.object.getURI()) || OWLRDF.OBJECT_PROPERTY.equals(this.object.getURI()) || OWLRDF.DATATYPE_PROPERTY.equals(this.object.getURI()));
    }

    public boolean isSubProperty() {
        return RDFS.SUB_PROPERTY_OF.equals(this.predicate.getURI());
    }

    public boolean isSubClass() {
        return RDFS.SUB_CLASS_OF.equals(this.predicate.getURI());
    }

    public boolean isTBox() {
        return false;
    }

    public String toString() {
        return String.valueOf(this.subject.toString()) + " " + this.predicate.toString() + " " + this.object.toString();
    }
}

