/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.query.sparql;

import eu.trowl.query.QuerySyntaxException;
import eu.trowl.query.QueryTypeException;
import eu.trowl.query.sparql.GraphPattern;
import eu.trowl.query.sparql.JavaCharStream;
import eu.trowl.query.sparql.ParseException;
import eu.trowl.query.sparql.SPARQLParserBase;
import eu.trowl.query.sparql.SPARQLParserConstants;
import eu.trowl.query.sparql.SPARQLParserTokenManager;
import eu.trowl.query.sparql.Token;
import eu.trowl.rdf.Node;
import eu.trowl.vocab.RDF;
import eu.trowl.vocab.XSD;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SPARQLParser
extends SPARQLParserBase
implements SPARQLParserConstants {
    public SPARQLParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[36];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        SPARQLParser.jj_la1_init_0();
        SPARQLParser.jj_la1_init_1();
        SPARQLParser.jj_la1_init_2();
        SPARQLParser.jj_la1_init_3();
    }

    public final void CompilationUnit() throws ParseException, QueryTypeException, QuerySyntaxException {
        this.Query();
        this.jj_consume_token(0);
    }

    public final void Query() throws ParseException, QueryTypeException, QuerySyntaxException {
        this.Prologue();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.SelectQuery();
                break;
            }
            case 24: {
                this.ConstructQuery();
                break;
            }
            case 23: {
                this.DescribeQuery();
                break;
            }
            case 25: {
                this.AskQuery();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Prologue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.BaseDecl();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block6;
                }
            }
            this.PrefixDecl();
        }
    }

    public final void BaseDecl() throws ParseException {
        this.jj_consume_token(18);
        Node n = this.IRI_REF();
        this.getQuery().setBaseURI(n.getURI());
    }

    public final void PrefixDecl() throws ParseException {
        this.jj_consume_token(19);
        Token t = this.jj_consume_token(9);
        Node n = this.IRI_REF();
        this.setFixedPrefix(t.image, n.getURI());
    }

    public final void SelectQuery() throws ParseException, QueryTypeException, QuerySyntaxException {
        this.jj_consume_token(20);
        this.getQuery().setQuerySelectType();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: 
            case 22: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        this.getQuery().setDistinct(true);
                        break block0;
                    }
                    case 22: {
                        this.jj_consume_token(22);
                        this.getQuery().setReduced(true);
                        break block0;
                    }
                }
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                block17: while (true) {
                    Node v = this.Var();
                    this.getQuery().getSelectClause().addVariable(v);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: 
                        case 13: {
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[5] = this.jj_gen;
                this.getQuery().setQueryResultStar(false);
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                this.getQuery().setQueryResultStar(true);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block18;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
    }

    public final void ConstructQuery() throws ParseException, QueryTypeException {
        this.jj_consume_token(24);
        throw new QueryTypeException("Construct queries are not currently supported");
    }

    public final void DescribeQuery() throws ParseException, QueryTypeException {
        this.jj_consume_token(23);
        throw new QueryTypeException("Describe queries are not currently supported");
    }

    public final void AskQuery() throws ParseException, QueryTypeException, QuerySyntaxException {
        this.jj_consume_token(25);
        this.getQuery().setQueryAskType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
    }

    public final void DatasetClause() throws ParseException, QuerySyntaxException {
        this.jj_consume_token(33);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: {
                this.DefaultGraphClause();
                break;
            }
            case 32: {
                this.NamedGraphClause();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DefaultGraphClause() throws ParseException, QuerySyntaxException {
        Node n = this.SourceSelector();
        this.getQuery().getFromClause().addGraphURI(n.getURI());
    }

    public final void NamedGraphClause() throws ParseException, QuerySyntaxException {
        this.jj_consume_token(32);
        Node n = this.SourceSelector();
    }

    public final Node SourceSelector() throws ParseException, QuerySyntaxException {
        Node n = this.IRIref();
        if (!n.isResource()) {
            throw new QuerySyntaxException("Not a URI: " + n.toString(), this.token.beginLine, this.token.beginColumn);
        }
        return n;
    }

    public final void WhereClause() throws ParseException, QuerySyntaxException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        GraphPattern bgp = this.GroupGraphPattern();
        this.getQuery().getWhereClause().setBasicGraphPattern(bgp);
    }

    public final GraphPattern GroupGraphPattern() throws ParseException, QuerySyntaxException {
        GraphPattern bgp = null;
        this.jj_consume_token(74);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 76: 
            case 78: {
                bgp = this.TriplesBlock(null);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(75);
        return bgp;
    }

    public final GraphPattern TriplesBlock(GraphPattern bgp) throws ParseException, QuerySyntaxException {
        if (bgp == null) {
            bgp = new GraphPattern();
        }
        this.TriplesSameSubject(bgp);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: {
                this.jj_consume_token(81);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 51: 
                    case 52: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 73: 
                    case 76: 
                    case 78: {
                        this.TriplesBlock(bgp);
                        break block0;
                    }
                }
                this.jj_la1[12] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        return bgp;
    }

    public final void TriplesSameSubject(GraphPattern acc) throws ParseException, QuerySyntaxException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 78: {
                Node s = this.VarOrTerm();
                this.PropertyListNotEmpty(s, acc);
                break;
            }
            case 76: {
                Node s = this.TriplesNode(acc);
                this.PropertyList(s, acc);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PropertyListNotEmpty(Node s, GraphPattern acc) throws ParseException, QuerySyntaxException {
        Node p = this.Verb();
        this.ObjectList(s, p, acc);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 79: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(79);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 17: {
                    p = this.Verb();
                    this.ObjectList(s, p, acc);
                    continue block6;
                }
            }
            this.jj_la1[16] = this.jj_gen;
        }
    }

    public final void PropertyList(Node s, GraphPattern acc) throws ParseException, QuerySyntaxException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                this.PropertyListNotEmpty(s, acc);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
    }

    public final void ObjectList(Node s, Node p, GraphPattern acc) throws ParseException, QuerySyntaxException {
        this.Object(s, p, acc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 80: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(80);
            this.Object(s, p, acc);
        }
    }

    public final void Object(Node s, Node p, GraphPattern acc) throws ParseException, QuerySyntaxException {
        Node o = this.GraphNode(acc);
        this.insert(acc, s, p, o);
    }

    public final Node Verb() throws ParseException, QuerySyntaxException {
        Node p;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                p = this.VarOrIRIref();
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                p = Node.fromURI(RDF.TYPE);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return p;
    }

    public final Node TriplesNode(GraphPattern acc) throws ParseException, QuerySyntaxException {
        Node n = this.BlankNodePropertyList(acc);
        return n;
    }

    public final Node BlankNodePropertyList(GraphPattern acc) throws ParseException, QuerySyntaxException {
        this.jj_consume_token(76);
        Node n = this.createBNode();
        this.PropertyListNotEmpty(n, acc);
        this.jj_consume_token(77);
        return n;
    }

    public final Node GraphNode(GraphPattern acc) throws ParseException, QuerySyntaxException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 78: {
                Node n = this.VarOrTerm();
                return n;
            }
            case 76: {
                Node n = this.TriplesNode(acc);
                return n;
            }
        }
        this.jj_la1[20] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node VarOrTerm() throws ParseException, QuerySyntaxException {
        Node n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                n = this.Var();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 78: {
                n = this.GraphTerm();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Node VarOrIRIref() throws ParseException, QuerySyntaxException {
        Node n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                n = this.Var();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n = this.IRIref();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Node Var() throws ParseException, QuerySyntaxException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                t = this.jj_consume_token(12);
                break;
            }
            case 13: {
                t = this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.createVariable(t.image, t.beginLine, t.beginColumn);
    }

    public final Node GraphTerm() throws ParseException, QuerySyntaxException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: {
                Node n = this.IRIref();
                return n;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                Node n = this.RDFLiteral();
                return n;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                Node n = this.NumericLiteral();
                return n;
            }
            case 51: 
            case 52: {
                Node n = this.BooleanLiteral();
                return n;
            }
            case 11: 
            case 78: {
                Node n = this.BlankNode();
                return n;
            }
            case 73: {
                this.jj_consume_token(73);
                return Node.fromURI(RDF.NIL);
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node RDFLiteral() throws ParseException, QuerySyntaxException {
        String lex = null;
        lex = this.String();
        String lang = null;
        Node uri = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 97: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        Token t = this.jj_consume_token(14);
                        lang = t.image.substring(1);
                        break block0;
                    }
                    case 97: {
                        this.jj_consume_token(97);
                        uri = this.IRIref();
                        break block0;
                    }
                }
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        return this.makeNode(lex, lang, uri);
    }

    public final Node NumericLiteral() throws ParseException {
        Node n;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: 
            case 56: {
                n = this.NumericLiteralUnsigned();
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                n = this.NumericLiteralPositive();
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                n = this.NumericLiteralNegative();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Node NumericLiteralUnsigned() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                Token t = this.jj_consume_token(54);
                return this.makeNodeInteger(t.image);
            }
            case 55: {
                Token t = this.jj_consume_token(55);
                return this.makeNodeDecimal(t.image);
            }
            case 56: {
                Token t = this.jj_consume_token(56);
                return this.makeNodeDouble(t.image);
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node NumericLiteralPositive() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                Token t = this.jj_consume_token(57);
                return this.makeNodeInteger(t.image);
            }
            case 58: {
                Token t = this.jj_consume_token(58);
                return this.makeNodeDecimal(t.image);
            }
            case 59: {
                Token t = this.jj_consume_token(59);
                return this.makeNodeDouble(t.image);
            }
        }
        this.jj_la1[29] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node NumericLiteralNegative() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                Token t = this.jj_consume_token(60);
                return this.makeNodeInteger(t.image);
            }
            case 61: {
                Token t = this.jj_consume_token(61);
                return this.makeNodeDecimal(t.image);
            }
            case 62: {
                Token t = this.jj_consume_token(62);
                return this.makeNodeDouble(t.image);
            }
        }
        this.jj_la1[30] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                return Node.fromURI(XSD.TRUE);
            }
            case 52: {
                this.jj_consume_token(52);
                return Node.fromURI(XSD.FALSE);
            }
        }
        this.jj_la1[31] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String String() throws ParseException {
        String lex;
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                t = this.jj_consume_token(67);
                lex = this.stripQuotes(t.image);
                break;
            }
            case 68: {
                t = this.jj_consume_token(68);
                lex = this.stripQuotes(t.image);
                break;
            }
            case 69: {
                t = this.jj_consume_token(69);
                lex = this.stripQuotes3(t.image);
                break;
            }
            case 70: {
                t = this.jj_consume_token(70);
                lex = t.image;
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        lex = this.unescapeString(lex, t.beginLine, t.beginColumn);
        return lex;
    }

    public final Node IRIref() throws ParseException, QuerySyntaxException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                Node n = this.IRI_REF();
                return n;
            }
            case 9: 
            case 10: {
                Node n = this.PrefixedName();
                return n;
            }
        }
        this.jj_la1[33] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node PrefixedName() throws ParseException, QuerySyntaxException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                Token t = this.jj_consume_token(10);
                return this.createNodeFromPrefixedName(t.image, t.beginLine, t.beginColumn);
            }
            case 9: {
                Token t = this.jj_consume_token(9);
                return this.createNodeFromPrefixedName(t.image, t.beginLine, t.beginColumn);
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BlankNode() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                t = this.jj_consume_token(11);
                return this.createBNode(t.image, t.beginLine, t.beginColumn);
            }
            case 78: {
                this.jj_consume_token(78);
                return this.createBNode();
            }
        }
        this.jj_la1[35] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node IRI_REF() throws ParseException {
        Token t = this.jj_consume_token(8);
        try {
            return this.createNodeFromURI(t.image, t.beginLine, t.beginColumn);
        }
        catch (QuerySyntaxException ex) {
            Logger.getLogger(SPARQLParser.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error("Missing return statement in function");
        }
    }

    private static void jj_la1_init_0() {
        int[] nArray = new int[36];
        nArray[0] = 0x3900000;
        nArray[1] = 262144;
        nArray[2] = 524288;
        nArray[3] = 0x600000;
        nArray[4] = 0x600000;
        nArray[5] = 12288;
        nArray[6] = 12288;
        nArray[9] = 1792;
        nArray[11] = 16128;
        nArray[12] = 16128;
        nArray[14] = 16128;
        nArray[16] = 145152;
        nArray[17] = 145152;
        nArray[19] = 145152;
        nArray[20] = 16128;
        nArray[21] = 16128;
        nArray[22] = 14080;
        nArray[23] = 12288;
        nArray[24] = 3840;
        nArray[25] = 16384;
        nArray[26] = 16384;
        nArray[33] = 1792;
        nArray[34] = 1536;
        nArray[35] = 2048;
        jj_la1_0 = nArray;
    }

    private static void jj_la1_init_1() {
        int[] nArray = new int[36];
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 1;
        nArray[10] = 4;
        nArray[11] = 2144862208;
        nArray[12] = 2144862208;
        nArray[14] = 2144862208;
        nArray[20] = 2144862208;
        nArray[21] = 2144862208;
        nArray[24] = 2144862208;
        nArray[27] = 2143289344;
        nArray[28] = 0x1C00000;
        nArray[29] = 0xE000000;
        nArray[30] = 0x70000000;
        nArray[31] = 0x180000;
        jj_la1_1 = nArray;
    }

    private static void jj_la1_init_2() {
        int[] nArray = new int[36];
        nArray[6] = Integer.MIN_VALUE;
        nArray[11] = 21112;
        nArray[12] = 21112;
        nArray[13] = 131072;
        nArray[14] = 21112;
        nArray[15] = 32768;
        nArray[18] = 65536;
        nArray[20] = 21112;
        nArray[21] = 17016;
        nArray[24] = 17016;
        nArray[32] = 120;
        nArray[35] = 16384;
        jj_la1_2 = nArray;
    }

    private static void jj_la1_init_3() {
        int[] nArray = new int[36];
        nArray[25] = 2;
        nArray[26] = 2;
        jj_la1_3 = nArray;
    }

    public SPARQLParser(InputStream stream) {
        this(stream, null);
    }

    public SPARQLParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SPARQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 36) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 36) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public SPARQLParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new SPARQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 36) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 36) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public SPARQLParser(SPARQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 36) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(SPARQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 36) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[106];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 36) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jj_la1_2[i] & 1 << j) != 0) {
                        la1tokens[64 + j] = true;
                    }
                    if ((jj_la1_3[i] & 1 << j) != 0) {
                        la1tokens[96 + j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 106) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.add(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

