/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.query;

import eu.trowl.db.DB;
import eu.trowl.query.ResultSetMetaData;
import eu.trowl.util.Types;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResultSet {
    private List<Map<String, Object>> rows = Types.newList();
    private List<Map<String, String>> metarows = Types.newList();
    private DB db;
    private Map<Map<String, Object>, Float> rowRanks = new HashMap<Map<String, Object>, Float>();
    private ResultSetMetaData rsmd;
    private int cursor = -1;

    private ResultSet(DB db) {
        this.db = db;
        this.rsmd = new ResultSetMetaData();
    }

    public ResultSet(DB db, ResultSetMetaData rsmd) {
        this.db = db;
        this.rsmd = rsmd;
    }

    private ResultSet(DB db, java.sql.ResultSetMetaData sqlrsmd) throws SQLException {
        this.db = db;
        this.rsmd = ResultSetMetaData.fromSQLResultSetMetaData(sqlrsmd);
    }

    public void beforeFirst() {
        this.cursor = -1;
    }

    public boolean first() {
        if (!this.hasResult()) {
            this.beforeFirst();
            return false;
        }
        this.cursor = 0;
        return true;
    }

    public boolean next() {
        try {
            return this.rows.get(++this.cursor) != null;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public int getRow() {
        return this.cursor + 1;
    }

    public ResultSetMetaData getMetaData() {
        return this.rsmd;
    }

    public void addValue(Object o, int row, int column) {
        if (row > this.rows.size()) {
            this.rows.add(new LinkedHashMap());
            this.addValue(o, row, column);
        } else {
            this.rows.get(row - 1).put(this.rsmd.getColumnName(column), o);
        }
    }

    public void setRank(float rank) {
        this.rowRanks.put(this.rows.get(this.cursor), Float.valueOf(rank));
    }

    public float getRank() {
        return this.rowRanks.get(this.rows.get(this.cursor)).floatValue();
    }

    public boolean hasRowRanks() {
        return !this.rowRanks.isEmpty();
    }

    public void sortByRank() {
        Collections.sort(this.rows, new RankComparator());
    }

    public Object getObject(String columnName) {
        return this.hasResult() ? this.rows.get(this.cursor).get(columnName) : null;
    }

    public Object getObject(int index) {
        return this.getObject(this.rsmd.getColumnName(index));
    }

    public String getString(String columnName) {
        return String.valueOf(this.getObject(columnName));
    }

    public String getString(int index) {
        return this.getString(this.rsmd.getColumnName(index));
    }

    public Double getDouble(String columnName) {
        return (Double)this.getObject(columnName);
    }

    public Double getDouble(int index) {
        return this.getDouble(this.rsmd.getColumnName(index));
    }

    public URI getSource(int index) {
        return this.getSource(this.rsmd.getColumnName(index));
    }

    public URI getSource(String columnName) {
        try {
            Long sourceId = Long.decode(this.metarows.get(this.cursor).get(columnName));
            String sourceURI = this.db.queryAtomic("SELECT uri FROM ontologies WHERE id=?", sourceId);
            return new URI(sourceURI);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ResultSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SQLException ex) {
            Logger.getLogger(ResultSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException ex) {
            return null;
        }
        return null;
    }

    public int size() {
        return this.rows.size();
    }

    private boolean hasResult() {
        return this.rows.size() > 0;
    }

    private void addRow(Map<String, Object> row) {
        this.rows.add(row);
    }

    private void addMetaRow(Map<String, String> row) {
        this.metarows.add(row);
    }

    public static ResultSet fromSQLResultSet(DB db, java.sql.ResultSet sqlrs) throws SQLException {
        ResultSet rs = new ResultSet(db, sqlrs.getMetaData());
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = sqlrs.getMetaData().getColumnCount();
        while (sqlrs.next()) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, String> metarow = new LinkedHashMap<String, String>();
            int i = 1;
            while (i <= cols) {
                String colname = sqlrs.getMetaData().getColumnLabel(i);
                if (colname.toUpperCase().startsWith("SOURCE_")) {
                    metarow.put(colname.substring(7), sqlrs.getString(i));
                } else {
                    row.put(colname, sqlrs.getObject(i));
                }
                ++i;
            }
            rs.addRow(row);
            rs.addMetaRow(metarow);
        }
        return rs;
    }

    public Set<URI> getRowSources() {
        Set<URI> out = Types.newSet();
        return out;
    }

    private class RankComparator
    implements Comparator<Map<String, Object>> {
        private RankComparator() {
        }

        @Override
        public int compare(Map<String, Object> r1, Map<String, Object> r2) {
            return -((Float)ResultSet.this.rowRanks.get(r1)).compareTo((Float)ResultSet.this.rowRanks.get(r2));
        }
    }
}

