/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.query;

import com.truemesh.squiggle.Column;
import com.truemesh.squiggle.SelectQuery;
import com.truemesh.squiggle.Table;
import com.truemesh.squiggle.criteria.MatchCriteria;
import eu.trowl.db.DB;
import eu.trowl.db.DBFactory;
import eu.trowl.hashing.FNV;
import eu.trowl.query.Bindings;
import eu.trowl.query.Concept;
import eu.trowl.query.End;
import eu.trowl.query.QueryDatabaseException;
import eu.trowl.query.QueryException;
import eu.trowl.query.QuerySyntaxException;
import eu.trowl.query.ResultSet;
import eu.trowl.query.Role;
import eu.trowl.query.VarColBinding;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Query {
    protected int limit = 0;
    protected int offset = 0;
    protected boolean distinct = false;
    protected Map resultVars;
    protected List<Concept> classes;
    protected List<Role> properties;
    protected Bindings varBindings;
    private Set<String> distinguishedVars;
    private Map<String, String> classPaths;
    private Map<String, String> propertyPaths;
    private Map<String, String> propertyTypes;
    private Map<String, String> classPathBindings;
    private Map<String, String> propertyPathBindings;
    private Bindings varClassBindings;
    private Bindings tableBindings;
    private List<String> tables;
    private List<String> cpTables;
    private List<String> ppTables;
    private DB db;
    private static final String TABLE_IDENTIFIER = "t";
    private static final String CPATH_TABLE_IDENTIFIER = "c";
    private static final String PPATH_TABLE_IDENTIFIER = "p";
    protected static String VARIABLE_PREFIX = "?";
    protected Map<String, String> foundAt;
    protected VarColBinding varColBinding;
    private SelectQuery query;
    protected boolean queryResultStar = false;

    public Query() throws Exception {
        this.init();
    }

    public void setDB(DB database) {
        this.db = database;
    }

    private void init() {
        this.tables = new ArrayList<String>();
        this.cpTables = new ArrayList<String>();
        this.ppTables = new ArrayList<String>();
        this.varBindings = new Bindings();
        this.tableBindings = new Bindings();
        this.varClassBindings = new Bindings();
        this.classPaths = new HashMap<String, String>();
        this.propertyPaths = new HashMap<String, String>();
        this.propertyTypes = new HashMap<String, String>();
        this.classPathBindings = new HashMap<String, String>();
        this.propertyPathBindings = new HashMap<String, String>();
        this.distinguishedVars = new HashSet<String>();
        this.classes = new ArrayList<Concept>();
        this.properties = new ArrayList<Role>();
        this.resultVars = new HashMap();
        this.foundAt = new HashMap<String, String>();
        this.varColBinding = new VarColBinding();
        this.query = new SelectQuery();
    }

    public abstract void process() throws QuerySyntaxException;

    public ResultSet execute(String repo) throws QueryException {
        try {
            if (this.db == null) {
                this.db = DBFactory.construct(repo);
                this.db.connect();
            }
        }
        catch (Exception e) {
            throw new QueryDatabaseException("Unable to connect to database: " + e.getLocalizedMessage());
        }
        return this.execute();
    }

    public ResultSet execute() throws QueryException {
        try {
            if (this.db == null) {
                this.db = DBFactory.construct();
                this.db.connect();
            }
        }
        catch (Exception e) {
            throw new QueryDatabaseException("Unable to connect to database: " + e.getLocalizedMessage());
        }
        this.process();
        try {
            java.sql.ResultSet res = this.db.execSQL(this.toSQL());
            return ResultSet.fromSQLResultSet(this.db, res);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new QueryDatabaseException();
        }
    }

    public boolean ask(String repo) throws QueryException {
        try {
            this.db = DBFactory.construct(repo);
            this.db.connect();
        }
        catch (Exception e) {
            throw new QueryDatabaseException("Unable to connect to database: " + e.getLocalizedMessage());
        }
        this.process();
        try {
            java.sql.ResultSet res = this.db.execSQL(this.toSQL());
            return res.next();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new QueryDatabaseException();
        }
    }

    private List<String> getPropertyPathType(String uri) throws SQLException {
        return this.db.queryAtomicList("SELECT path, type FROM propertypaths, (SELECT id, uri FROM oproperties UNION SELECT id, uri FROM dproperties) as properties  WHERE propertypaths.property_id=properties.id AND properties.uri=?", uri);
    }

    private String getClassPath(String uri) throws SQLException {
        return this.db.queryAtomic("SELECT path FROM classpaths, classes WHERE classpaths.class_id=classes.id AND classes.uri=?", uri);
    }

    private String addPropertyPath(String uri) throws QueryException {
        if (!this.propertyPaths.containsKey(uri)) {
            List<String> data;
            try {
                data = this.getPropertyPathType(uri);
            }
            catch (SQLException ex) {
                QueryException e = new QueryException("Unable to find path for property: " + uri, ex);
                throw e;
            }
            if (!data.isEmpty()) {
                if (data.get(0) == null || data.get(1) == null) {
                    throw new QueryException("Unknown property used in query: " + uri);
                }
                this.propertyPaths.put(uri, data.get(0));
                this.propertyTypes.put(uri, data.get(1));
            } else {
                throw new QueryException("Unknown property in query: " + uri);
            }
        }
        String tableId = this.propertyTypes.get(uri).equals("d") ? this.addTable("dproperty_instances") : this.addTable("oproperty_instances");
        String pTable = this.addPPTable("propertypaths");
        this.propertyPathBindings.put(pTable, this.propertyPaths.get(uri));
        this.tableBindings.put(this.appendColumn(pTable, "property_id"), this.appendColumn(tableId, "property_id"));
        return tableId;
    }

    private void addClassPath(String uri, String table) throws QueryException {
        if (!this.classPaths.containsKey(uri)) {
            String path;
            try {
                path = this.getClassPath(uri);
            }
            catch (SQLException ex) {
                throw new QueryException("Unable to lookup class path: " + uri, ex);
            }
            if (path == null) {
                throw new QueryException("Unknown class used in query: " + uri);
            }
            this.classPaths.put(uri, path);
        }
        String pTable = this.addCPTable("classpaths");
        this.classPathBindings.put(pTable, this.classPaths.get(uri));
        this.tableBindings.put(this.appendColumn(pTable, "class_id"), this.appendColumn(table, "class_id"));
    }

    private void addClassPath(String uri, Column col) throws Exception {
        if (!this.classPaths.containsKey(uri)) {
            this.classPaths.put(uri, this.getClassPath(uri));
        }
        Table cpTab = new Table("classpaths");
        Column cpCol = new Column(cpTab, "path");
        this.query.addJoin(col.getTable(), col.getName(), cpTab, "class_id");
        this.query.addCriteria(new MatchCriteria(cpCol, "LIKE", String.valueOf(this.classPaths.get(uri)) + '%'));
    }

    public String addTable(String table) {
        this.tables.add(table);
        return TABLE_IDENTIFIER + this.tables.size();
    }

    public String addCPTable(String table) {
        this.cpTables.add(table);
        return CPATH_TABLE_IDENTIFIER + this.cpTables.size();
    }

    public String addPPTable(String table) {
        this.ppTables.add(table);
        return PPATH_TABLE_IDENTIFIER + this.ppTables.size();
    }

    private void prepClasses() throws Exception {
        for (Concept c : this.classes) {
            String tableId = this.addTable("individuals");
            Table t = new Table("individuals");
            Column col = new Column(t, "class_id");
            this.addClassPath(c.getName(), tableId);
            this.addClassPath(c.getName(), col);
            if (c.getValue().isVar()) {
                this.bindVar(c.getValue().getVar(), this.appendColumn(tableId, "uri"));
                this.query.addColumn(col);
                this.bindVarClass(c.getValue().getVar(), tableId);
                this.addDistinguishedVar(c.getValue().getVar());
                this.varColBinding.put(c.getValue().getVar(), col);
                continue;
            }
            this.bindURI(c.getValue().getURI().toString(), this.appendColumn(tableId, "uri"));
            this.query.addCriteria(new MatchCriteria(t, "uri", "=", c.getValue().getURI().toString()));
        }
    }

    private void identifyDistinguishedVars() {
        HashSet<String> dvcDomain = new HashSet<String>();
        HashSet<String> dvcRange = new HashSet<String>();
        for (Role r : this.properties) {
            if (this.isVar(r.getDomain())) {
                dvcDomain.add(r.getDomain());
            }
            if (!this.isVar(r.getRange())) continue;
            dvcRange.add(r.getRange());
        }
        dvcDomain.retainAll(dvcRange);
        this.distinguishedVars.addAll(dvcDomain);
    }

    private void prepProperties() throws Exception {
        this.identifyDistinguishedVars();
        for (Role r : this.properties) {
            String tableId = this.addPropertyPath(r.getURI());
            if (this.isVar(r.getDomain())) {
                this.bindVar(r.getDomain(), this.appendColumn(tableId, "subject_id"));
            } else {
                this.bindURI(r.getDomain(), this.appendColumn(tableId, "subject_id"));
            }
            if (this.propertyTypes.get(r.getURI()).equals("d")) {
                if (this.isVar(r.getRange())) {
                    this.bindVar(r.getRange(), this.appendColumn(tableId, "object"));
                    continue;
                }
                this.bindURI(r.getRange(), this.appendColumn(tableId, "object"));
                continue;
            }
            if (this.isVar(r.getRange())) {
                this.bindVar(r.getRange(), this.appendColumn(tableId, "object_id"));
                continue;
            }
            this.bindURI(r.getRange(), this.appendColumn(tableId, "object_id"));
        }
    }

    private String stripColumn(String in) {
        int firstDot = in.indexOf(46);
        if (firstDot == -1) {
            return in;
        }
        return in.substring(0, firstDot);
    }

    private String sourceOf(String in) {
        return String.valueOf(this.stripColumn(in)) + ".ontology";
    }

    private String sourceName(String in) {
        return "source_" + in;
    }

    private String toSQL() throws Exception {
        this.prepClasses();
        this.prepProperties();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT ");
        for (String currentVar : this.resultVars.keySet()) {
            String col = this.varBindings.getOneOf(currentVar);
            if (col.endsWith("_id")) {
                Iterator<String> resultTableId = this.addTable("individuals");
                this.bindVar(currentVar, String.valueOf(resultTableId) + ".id");
                col = String.valueOf(resultTableId) + ".uri";
            }
            sql.append(" " + col + " AS " + currentVar + ", ");
            sql.append(" " + this.sourceOf(col) + " AS " + this.sourceName(currentVar) + ", ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append("\nFROM ");
        int i = 0;
        for (String currentTable : this.tables) {
            sql.append(String.valueOf(currentTable) + " as " + TABLE_IDENTIFIER + ++i + ", ");
        }
        i = 0;
        for (String currentTable : this.cpTables) {
            sql.append("classpaths as c" + ++i + ", ");
        }
        i = 0;
        for (String currentTable : this.ppTables) {
            sql.append("propertypaths as p" + ++i + ", ");
        }
        sql.delete(sql.length() - 2, sql.length());
        Iterator varI = this.varBindings.keySet().iterator();
        Iterator tabBindI = this.tableBindings.keySet().iterator();
        sql.append("\nWHERE ");
        while (varI.hasNext()) {
            String currentVar = (String)varI.next();
            Iterator<String> tabI = this.varBindings.get(currentVar).iterator();
            String baseTab = this.makeId(tabI.next());
            while (tabI.hasNext()) {
                String cmpTab = this.makeId(tabI.next());
                sql.append(String.valueOf(baseTab) + " = " + cmpTab + "\nAND ");
            }
        }
        for (String var : this.varColBinding.keySet()) {
            Iterator<Column> it = this.varColBinding.get(var).iterator();
            if (!it.hasNext()) continue;
            Column baseCol = it.next();
            while (it.hasNext()) {
                Column col = it.next();
                this.query.addJoin(baseCol.getTable(), baseCol.getName(), col.getTable(), col.getName());
            }
        }
        while (tabBindI.hasNext()) {
            String currentTab;
            String currentTabVal = currentTab = (String)tabBindI.next();
            for (String cmpTab : this.tableBindings.get(currentTab)) {
                sql.append(String.valueOf(currentTabVal) + " = " + cmpTab + "\nAND ");
            }
        }
        for (Map.Entry<String, String> e : this.classPathBindings.entrySet()) {
            sql.append(String.valueOf(e.getKey()) + ".path LIKE '" + e.getValue() + "%'\nAND ");
        }
        for (Map.Entry<String, String> e : this.propertyPathBindings.entrySet()) {
            sql.append(String.valueOf(e.getKey()) + ".path LIKE '" + e.getValue() + "%'\nAND ");
        }
        if (sql.toString().endsWith("\nAND ")) {
            sql.delete(sql.length() - 4, sql.length());
        }
        if (sql.toString().endsWith("\nWHERE ")) {
            sql.delete(sql.length() - 6, sql.length());
        }
        if (this.limit > 0) {
            sql.append(" LIMIT " + this.limit);
        }
        if (this.offset > 0) {
            sql.append(" OFFSET " + this.offset);
        }
        return sql.toString();
    }

    protected void addBoundVar(String var) {
        this.resultVars.put(var, Boolean.TRUE);
        this.addDistinguishedVar(var);
    }

    protected void addDistinguishedVar(String var) {
        this.distinguishedVars.add(var);
    }

    protected String makeId(String in) {
        if (!in.endsWith("id")) {
            return in.substring(0, in.indexOf(".")).concat(".id");
        }
        return in;
    }

    protected boolean isVar(String candidate) {
        return candidate.startsWith("?");
    }

    private String appendColumn(String table, String column) {
        return String.valueOf(table) + "." + column;
    }

    private void bindVar(String var, String column) {
        if (var.startsWith(VARIABLE_PREFIX)) {
            var = var.substring(1);
        }
        this.varBindings.put(var, column);
    }

    private void bindVarClass(String var, String column) {
        this.varClassBindings.put(var, column);
    }

    private void bindURI(String uri, String column) {
        this.tableBindings.put(String.valueOf(FNV.hash(this.removeQuotes(uri))), column);
    }

    private String removeQuotes(String in) {
        if (in != null && in.charAt(0) == '\"' && in.charAt(in.length() - 1) == '\"') {
            return in.substring(1, in.length() - 1);
        }
        return in;
    }

    private String incrementPath(String path) {
        if (path.length() > 0) {
            char last = path.charAt(path.length() - 1);
            last = (char)(last + '\u0001');
            return String.valueOf(path.substring(0, path.length() - 1)) + last;
        }
        return path;
    }

    private Set<Node> findProxyNodes() {
        HashSet<Node> ns = new HashSet<Node>();
        HashSet<String> ndv = new HashSet<String>();
        for (Role r : this.properties) {
            if (this.isVar(r.getDomain()) && !this.resultVars.containsKey(r.getDomain()) && !ndv.contains(r.getDomain())) {
                ndv.add(r.getDomain());
            }
            if (!this.isVar(r.getRange()) || this.resultVars.containsKey(r.getRange()) || ndv.contains(r.getRange())) continue;
            ndv.add(r.getRange());
        }
        for (Role r : this.properties) {
            Node n;
            if (this.isVar(r.getDomain()) && ndv.contains(r.getDomain()) && !ndv.contains(r.getRange())) {
                n = new Node();
                n.end = End.RANGE;
                n.role = r;
                ns.add(n);
            }
            if (!this.isVar(r.getRange()) || !ndv.contains(r.getRange()) || ndv.contains(r.getDomain())) continue;
            n = new Node();
            n.end = End.DOMAIN;
            n.role = r;
            ns.add(n);
        }
        return ns;
    }

    class Node {
        public Role role;
        public End end;

        Node() {
        }
    }

    class PropertyMetaData {
        public String path;
        public char type;

        PropertyMetaData() {
        }
    }
}

